/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.themes.service;

import java.util.List;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.themes.Theme;
import org.lamsfoundation.lams.themes.dao.IThemeDAO;
import org.lamsfoundation.lams.themes.service.IThemeService;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;

public class ThemeService
implements IThemeService {
    protected Logger log = Logger.getLogger(ThemeService.class);
    protected IThemeDAO themeDAO;
    protected IUserManagementService userManagementService;

    public IThemeDAO getThemeDAO() {
        return this.themeDAO;
    }

    public void setThemeDAO(IThemeDAO themeDAO) {
        this.themeDAO = themeDAO;
    }

    public void setUserManagementService(IUserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    @Override
    public Theme getTheme(Long themeId) {
        return this.themeDAO.getThemeById(themeId);
    }

    @Override
    public Theme getTheme(String themeName) {
        List<Theme> themes = this.themeDAO.getThemeByName(themeName);
        if (themes != null && themes.size() > 0) {
            return themes.get(0);
        }
        return null;
    }

    @Override
    public List<Theme> getAllThemes() {
        return this.themeDAO.getAllThemes();
    }

    @Override
    public void removeTheme(Long themeId) {
        this.themeDAO.deleteThemeById(themeId);
    }

    @Override
    public void saveOrUpdateTheme(Theme theme) {
        this.themeDAO.saveOrUpdateTheme(theme);
    }

    @Override
    public Theme getDefaultTheme() {
        List<Theme> themes = this.getAllThemes();
        String defaultTheme = Configuration.get(ConfigurationKeys.DEFAULT_THEME);
        for (Theme theme : themes) {
            if (!theme.getName().equals(defaultTheme)) continue;
            return theme;
        }
        return null;
    }
}

