/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.dao.hibernate;

import java.io.Serializable;
import java.util.List;
import org.lamsfoundation.lams.dao.hibernate.LAMSBaseDAO;
import org.lamsfoundation.lams.tool.Tool;
import org.lamsfoundation.lams.tool.dao.IToolDAO;
import org.springframework.stereotype.Repository;

@Repository
public class ToolDAO
extends LAMSBaseDAO
implements IToolDAO {
    private static final String FIND_ALL = "from obj in class " + Tool.class.getName();
    private static final String LOAD_TOOL_BY_SIG = "from tool in class Tool where tool.toolSignature=:toolSignature";

    @Override
    public Tool getToolByID(Long toolID) {
        return (Tool)this.getSession().get(Tool.class, (Serializable)toolID);
    }

    @Override
    public List getAllTools() {
        return this.doFind(FIND_ALL, new Object[0]);
    }

    @Override
    public Tool getToolBySignature(String toolSignature) {
        return (Tool)this.getSession().createQuery(LOAD_TOOL_BY_SIG).setString("toolSignature", toolSignature).uniqueResult();
    }

    @Override
    public long getToolDefaultContentIdBySignature(String toolSignature) {
        Tool tool = (Tool)this.getSession().createQuery(LOAD_TOOL_BY_SIG).setString("toolSignature", toolSignature).uniqueResult();
        if (tool != null) {
            return tool.getDefaultToolContentId();
        }
        return 0L;
    }

    @Override
    public void saveOrUpdateTool(Tool tool) {
        this.getSession().saveOrUpdate((Object)tool);
    }
}

