/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.service;

import java.io.IOException;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Hibernate;
import org.hibernate.proxy.HibernateProxy;
import org.lamsfoundation.lams.confidencelevel.ConfidenceLevelDTO;
import org.lamsfoundation.lams.gradebook.service.IGradebookService;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ActivityEvaluation;
import org.lamsfoundation.lams.learningdesign.FloatingActivity;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dao.IActivityDAO;
import org.lamsfoundation.lams.lesson.CompletedActivityProgress;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.logevent.service.ILogEventService;
import org.lamsfoundation.lams.tool.IToolVO;
import org.lamsfoundation.lams.tool.Tool;
import org.lamsfoundation.lams.tool.ToolOutput;
import org.lamsfoundation.lams.tool.ToolSession;
import org.lamsfoundation.lams.tool.dao.IToolContentDAO;
import org.lamsfoundation.lams.tool.dao.IToolDAO;
import org.lamsfoundation.lams.tool.dao.IToolSessionDAO;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.service.ILamsCoreToolService;
import org.lamsfoundation.lams.tool.service.ILamsToolService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.FileUtilException;

public class LamsToolService
implements ILamsToolService {
    private static Logger log = Logger.getLogger(LamsToolService.class);
    private static final String LEADER_SELECTION_TOOL_OUTPUT_NAME_LEADER_USERID = "leader.user.id";
    private static final String TOOL_SIGNATURE_ASSESSMENT = "laasse10";
    private static final String TOOL_SIGNATURE_MCQ = "lamc11";
    private IActivityDAO activityDAO;
    private ILogEventService logEventService;
    private IToolDAO toolDAO;
    private IToolSessionDAO toolSessionDAO;
    private IToolContentDAO toolContentDAO;
    private IGradebookService gradebookService;
    private ILamsCoreToolService lamsCoreToolService;
    private ILessonService lessonService;

    @Override
    public IToolVO getToolByID(Long toolId) {
        Tool tool = this.toolDAO.getToolByID(toolId);
        return tool.createBasicToolVO();
    }

    @Override
    public IToolVO getToolBySignature(String toolSignature) {
        Tool tool = this.toolDAO.getToolBySignature(toolSignature);
        return tool.createBasicToolVO();
    }

    @Override
    public Tool getPersistToolBySignature(String toolSignature) {
        return this.toolDAO.getToolBySignature(toolSignature);
    }

    @Override
    public long getToolDefaultContentIdBySignature(String toolSignature) {
        return this.toolDAO.getToolDefaultContentIdBySignature(toolSignature);
    }

    @Override
    public String generateUniqueContentFolder() throws FileUtilException, IOException {
        return FileUtil.generateUniqueContentFolderID();
    }

    @Override
    public String getLearnerContentFolder(Long toolSessionId, Long userId) {
        ToolSession toolSession = this.getToolSession(toolSessionId);
        Long lessonId = toolSession.getLesson().getLessonId();
        String learnerContentFolder = FileUtil.getLearnerContentFolder(lessonId, userId);
        return learnerContentFolder;
    }

    @Override
    public void saveOrUpdateTool(Tool tool) {
        this.toolDAO.saveOrUpdateTool(tool);
    }

    @Override
    public ToolSession getToolSession(Long toolSessionId) {
        return this.toolSessionDAO.getToolSession(toolSessionId);
    }

    @Override
    public Boolean isGroupedActivity(long toolContentID) {
        ToolActivity toolActivity = this.activityDAO.getToolActivityByToolContentId(toolContentID);
        boolean isGroupedActivity = toolActivity == null ? null : toolActivity.getApplyGrouping();
        return isGroupedActivity;
    }

    @Override
    public void auditLogStartEditingActivityInMonitor(long toolContentID) {
        this.logEventService.logStartEditingActivityInMonitor(toolContentID);
    }

    @Override
    public String getActivityEvaluation(Long toolContentId) {
        ToolActivity toolActivity = this.activityDAO.getToolActivityByToolContentId(toolContentId);
        ActivityEvaluation evaluation = toolActivity.getEvaluation();
        return evaluation == null ? null : evaluation.getToolOutputDefinition();
    }

    @Override
    public void setActivityEvaluation(Long toolContentId, String toolOutputDefinition) {
        if (StringUtils.isEmpty((String)toolOutputDefinition)) {
            this.gradebookService.removeActivityMark(toolContentId);
            return;
        }
        ToolActivity toolActivity = this.activityDAO.getToolActivityByToolContentId(toolContentId);
        ActivityEvaluation evaluation = toolActivity.getEvaluation();
        boolean isToolOutputDefinitionChanged = true;
        if (evaluation == null) {
            evaluation = new ActivityEvaluation();
            evaluation.setActivity(toolActivity);
            toolActivity.setEvaluation(evaluation);
        } else {
            isToolOutputDefinitionChanged = !toolOutputDefinition.equals(evaluation.getToolOutputDefinition());
        }
        evaluation.setToolOutputDefinition(toolOutputDefinition);
        this.activityDAO.update(toolActivity);
        if (isToolOutputDefinitionChanged) {
            this.gradebookService.recalculateGradebookMarksForActivity((Activity)toolActivity);
        }
    }

    @Override
    public Long getLeaderUserId(Long toolSessionId, Integer learnerId) {
        Long leaderUserId = null;
        ToolSession toolSession = this.getToolSession(toolSessionId);
        ToolActivity specifiedActivity = toolSession.getToolActivity();
        Activity leaderSelectionActivity = this.getNearestLeaderSelectionActivity(specifiedActivity, learnerId, toolSession.getLesson().getLessonId());
        if (leaderSelectionActivity != null) {
            ToolOutput output;
            User learner = (User)this.toolContentDAO.find(User.class, learnerId);
            String outputName = LEADER_SELECTION_TOOL_OUTPUT_NAME_LEADER_USERID;
            ToolSession leaderSelectionSession = this.toolSessionDAO.getToolSessionByLearner(learner, leaderSelectionActivity);
            if (leaderSelectionSession != null && (output = this.lamsCoreToolService.getOutputFromTool(outputName, leaderSelectionSession, null)) != null && output.getValue() != null) {
                leaderUserId = output.getValue().getLong();
            }
        }
        return leaderUserId;
    }

    @Override
    public Set<Long> getAllLeaderUserIds(Long toolSessionId, Integer learnerId) {
        Set<Long> leaderUserIds = null;
        ToolSession toolSession = this.getToolSession(toolSessionId);
        ToolActivity specifiedActivity = toolSession.getToolActivity();
        Activity leaderSelectionActivity = this.getNearestLeaderSelectionActivity(specifiedActivity, learnerId, toolSession.getLesson().getLessonId());
        if (leaderSelectionActivity != null) {
            leaderUserIds = this.getLeaderUserId(leaderSelectionActivity.getActivityId());
        }
        return leaderUserIds;
    }

    @Override
    public Set<Long> getLeaderUserId(Long leaderSelectionActivityId) {
        Activity activity = this.activityDAO.getActivityByActivityId(leaderSelectionActivityId);
        List toolSessions = this.toolSessionDAO.getToolSessionByActivity(activity);
        TreeSet<Long> result = new TreeSet<Long>();
        for (ToolSession toolSession : toolSessions) {
            ToolOutput output = this.lamsCoreToolService.getOutputFromTool(LEADER_SELECTION_TOOL_OUTPUT_NAME_LEADER_USERID, toolSession, null);
            if (output == null || output.getValue() == null) continue;
            result.add(output.getValue().getLong());
        }
        return result;
    }

    private Activity getNearestLeaderSelectionActivity(Activity activity, Integer userId, Long lessonId) {
        Transition transitionTo;
        Class activityClass = Hibernate.getClass((Object)activity);
        if (activityClass.equals(ToolActivity.class)) {
            Hibernate.initialize((Object)activity);
            ToolActivity toolActivity = activity instanceof HibernateProxy ? (ToolActivity)((HibernateProxy)activity).getHibernateLazyInitializer().getImplementation() : (ToolActivity)activity;
            if ("lalead11".equals(toolActivity.getTool().getToolSignature())) {
                return activity;
            }
        } else if (activityClass.equals(FloatingActivity.class)) {
            LearnerProgress learnerProgress = this.lessonService.getUserProgressForLesson(userId, lessonId);
            Map<Activity, CompletedActivityProgress> completedActivities = learnerProgress.getCompletedActivities();
            Date leaderSelectActivityFinishDate = null;
            ToolActivity leaderSelectionActivity = null;
            for (Activity completedActivity : completedActivities.keySet()) {
                ToolActivity completedToolActivity;
                if (!(completedActivity instanceof ToolActivity) || !"lalead11".equals((completedToolActivity = (ToolActivity)completedActivity).getTool().getToolSignature())) continue;
                Date finishDate = completedActivities.get(completedActivity).getFinishDate();
                if (leaderSelectActivityFinishDate != null && finishDate.compareTo(leaderSelectActivityFinishDate) >= 0) continue;
                leaderSelectionActivity = completedToolActivity;
                leaderSelectActivityFinishDate = completedActivities.get(completedActivity).getFinishDate();
            }
            return leaderSelectionActivity;
        }
        if ((transitionTo = activity.getTransitionTo()) != null) {
            Activity fromActivity = transitionTo.getFromActivity();
            return this.getNearestLeaderSelectionActivity(fromActivity, userId, lessonId);
        }
        Activity parent = activity.getParentActivity();
        if (parent != null) {
            return this.getNearestLeaderSelectionActivity(parent, userId, lessonId);
        }
        return null;
    }

    @Override
    public Set<ToolActivity> getPrecedingConfidenceLevelsActivities(Long toolContentId) {
        ToolActivity specifiedActivity = this.activityDAO.getToolActivityByToolContentId(toolContentId);
        if (specifiedActivity == null) {
            return null;
        }
        LinkedHashSet<Long> confidenceProvidingActivityIds = new LinkedHashSet<Long>();
        this.findPrecedingConfidenceProvidingActivities(specifiedActivity, confidenceProvidingActivityIds);
        LinkedHashSet<ToolActivity> confidenceProvidingActivities = new LinkedHashSet<ToolActivity>();
        for (Long confidenceProvidingActivityId : confidenceProvidingActivityIds) {
            ToolActivity confidenceProvidingActivity = (ToolActivity)this.activityDAO.getActivityByActivityId(confidenceProvidingActivityId, ToolActivity.class);
            confidenceProvidingActivities.add(confidenceProvidingActivity);
        }
        return confidenceProvidingActivities;
    }

    private void findPrecedingConfidenceProvidingActivities(Activity activity, Set<Long> confidenceProvidingActivityIds) {
        Class activityClass = Hibernate.getClass((Object)activity);
        if (activityClass.equals(ToolActivity.class)) {
            Hibernate.initialize((Object)activity);
            ToolActivity toolActivity = activity instanceof HibernateProxy ? (ToolActivity)((HibernateProxy)activity).getHibernateLazyInitializer().getImplementation() : (ToolActivity)activity;
            String toolSignature = toolActivity.getTool().getToolSignature();
            if (TOOL_SIGNATURE_ASSESSMENT.equals(toolSignature) || TOOL_SIGNATURE_MCQ.equals(toolSignature)) {
                confidenceProvidingActivityIds.add(toolActivity.getActivityId());
            }
        } else if (activityClass.equals(FloatingActivity.class)) {
            Set activities = activity.getLearningDesign().getActivities();
            for (Activity activityIter : activities) {
                String toolSignatureIter;
                if (!(activityIter instanceof ToolActivity) || !TOOL_SIGNATURE_ASSESSMENT.equals(toolSignatureIter = ((ToolActivity)activityIter).getTool().getToolSignature()) && !TOOL_SIGNATURE_MCQ.equals(toolSignatureIter)) continue;
                confidenceProvidingActivityIds.add(activityIter.getActivityId());
            }
            return;
        }
        Transition transitionTo = activity.getTransitionTo();
        if (transitionTo != null) {
            Activity fromActivity = transitionTo.getFromActivity();
            this.findPrecedingConfidenceProvidingActivities(fromActivity, confidenceProvidingActivityIds);
            return;
        }
        Activity parent = activity.getParentActivity();
        if (parent != null) {
            this.findPrecedingConfidenceProvidingActivities(parent, confidenceProvidingActivityIds);
            return;
        }
    }

    @Override
    public List<ConfidenceLevelDTO> getConfidenceLevelsByActivity(Integer confidenceLevelActivityUiid, Integer requestorUserId, Long requestorToolSessionId) {
        User user = (User)this.activityDAO.find(User.class, requestorUserId);
        if (user == null) {
            throw new ToolException("No user found for userId=" + requestorUserId);
        }
        ToolSession requestorSession = this.toolSessionDAO.getToolSession(requestorToolSessionId);
        if (requestorSession == null) {
            throw new ToolException("No session found for toolSessionId=" + requestorToolSessionId);
        }
        Activity confidenceLevelActivity = this.activityDAO.getActivityByUIID(confidenceLevelActivityUiid, requestorSession.getToolActivity().getLearningDesign());
        ToolSession confidenceLevelSession = this.toolSessionDAO.getToolSessionByLearner(user, confidenceLevelActivity);
        List<ConfidenceLevelDTO> confidenceLevelDtos = this.lamsCoreToolService.getConfidenceLevelsByToolSession(confidenceLevelSession);
        return confidenceLevelDtos;
    }

    @Override
    public Integer getCountUsersForActivity(Long toolSessionId) {
        ToolSession session = this.toolSessionDAO.getToolSession(toolSessionId);
        return session.getLearners().size();
    }

    public void setToolDAO(IToolDAO toolDAO) {
        this.toolDAO = toolDAO;
    }

    public void setActivityDAO(IActivityDAO activityDAO) {
        this.activityDAO = activityDAO;
    }

    public void setLogEventService(ILogEventService logEventService) {
        this.logEventService = logEventService;
    }

    public void setToolSessionDAO(IToolSessionDAO toolSessionDAO) {
        this.toolSessionDAO = toolSessionDAO;
    }

    public void setToolContentDAO(IToolContentDAO toolContentDAO) {
        this.toolContentDAO = toolContentDAO;
    }

    public void setGradebookService(IGradebookService gradebookService) {
        this.gradebookService = gradebookService;
    }

    public void setLamsCoreToolService(ILamsCoreToolService lamsCoreToolService) {
        this.lamsCoreToolService = lamsCoreToolService;
    }

    public void setLessonService(ILessonService lessonService) {
        this.lessonService = lessonService;
    }
}

