/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.lamsfoundation.lams.themes.dto.ThemeDTO;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.web.session.SessionManager;

public class CSSThemeUtil {
    public static String DEFAULT_HTML_THEME = "defaultHTML";

    public static List<String> getAllUserThemes() {
        String serverDefaultTheme;
        ArrayList<String> themeList = new ArrayList<String>();
        HttpSession ss = SessionManager.getSession();
        if (ss != null) {
            String themeName;
            ThemeDTO theme;
            UserDTO user = null;
            try {
                user = (UserDTO)ss.getAttribute("user");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (user != null && (theme = user.getTheme()) != null && (themeName = theme.getName()) != null) {
                themeList.add(theme.getName());
            }
        }
        if (themeList.size() == 0 && (serverDefaultTheme = Configuration.get(ConfigurationKeys.DEFAULT_THEME)) != null) {
            themeList.add(serverDefaultTheme);
        }
        if (themeList.size() == 0) {
            themeList.add(DEFAULT_HTML_THEME);
        }
        return themeList;
    }

    public static ThemeDTO getUserTheme() {
        UserDTO user;
        ThemeDTO theme = null;
        HttpSession ss = SessionManager.getSession();
        if (ss != null && (user = (UserDTO)ss.getAttribute("user")) != null) {
            theme = user.getTheme();
        }
        return theme;
    }

    public static boolean isLAMSDefaultTheme(String themeName) {
        return themeName.equals(DEFAULT_HTML_THEME);
    }
}

