/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import com.thoughtworks.xstream.security.AnyTypePermission;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.mail.internet.MimeUtility;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.id.Configurable;
import org.hibernate.id.UUIDGenerator;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.lamsfoundation.lams.learningdesign.service.ToolContentVersionFilter;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.FileUtilException;
import org.lamsfoundation.lams.util.TempDirectoryFilter;
import org.lamsfoundation.lams.util.UploadFileUtil;
import org.w3c.dom.Document;

public class FileUtil {
    private static Logger log = Logger.getLogger(FileUtil.class);
    public static final String ENCODING_UTF_8 = "UTF8";
    public static final SimpleDateFormat EXPORT_TO_SPREADSHEET_TITLE_DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    public static final SimpleDateFormat EXPORT_TO_SPREADSHEET_CELL_DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy");
    public static final String LAMS_WWW_SECURE_DIR = "secure";
    public static final String LAMS_WWW_DIR = "lams-www.war";
    public static final String LAMS_RUNTIME_CONTENT_DIR = "runtime";
    private static final long numMilliSecondsInADay = 86400000L;
    public static final String ALLOWED_EXTENSIONS_FLASH = ".swf,.fla";
    public static final String ALLOWED_EXTENSIONS_IMAGE = ".jpg,.gif,.jpeg,.png,.bmp";
    public static final String ALLOWED_EXTENSIONS_MEDIA = ".3gp,.avi,.flv,.m4v,.mkv,.mov,.mp3,.mp4,.mpe,.mpeg,.mpg,.mpv,.mts,.m2ts,ogg,.wma,.wmv";
    protected static final String prefix = "lamstmp_";
    private static Transformer xmlTransformer = null;

    public static boolean deleteDirectory(File directory) {
        boolean retValue = true;
        File[] files = directory.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (file.isDirectory()) {
                    FileUtil.deleteDirectory(file);
                    continue;
                }
                if (file.delete()) continue;
                log.error((Object)("Unable to delete file " + file.getName()));
                retValue = false;
            }
        }
        if (directory.delete()) {
            return retValue;
        }
        return false;
    }

    public static boolean deleteDirectory(String directoryName) throws FileUtilException {
        boolean isDeleted = false;
        if (directoryName == null || directoryName.length() == 0) {
            throw new FileUtilException("A directory name must be specified");
        }
        File dir = new File(directoryName);
        isDeleted = FileUtil.deleteDirectory(dir);
        return isDeleted;
    }

    public static boolean isEmptyDirectory(String directoryName, boolean checkSubdirectories) throws FileUtilException {
        if (directoryName == null || directoryName.length() == 0) {
            throw new FileUtilException("A directory name must be specified");
        }
        return FileUtil.isEmptyDirectory(new File(directoryName), checkSubdirectories);
    }

    private static boolean isEmptyDirectory(File directory, boolean checkSubdirectories) throws FileUtilException {
        if (directory.exists()) {
            File[] files = directory.listFiles();
            if (files.length > 0) {
                if (!checkSubdirectories) {
                    return false;
                }
                boolean isEmpty = true;
                for (int i = 0; i < files.length && isEmpty; ++i) {
                    File file = files[i];
                    isEmpty = file.isDirectory() ? FileUtil.isEmptyDirectory(file, true) : false;
                }
                return isEmpty;
            }
            return true;
        }
        return true;
    }

    public static String createTempDirectory(String suffix) throws FileUtilException {
        String tempSysDirName = FileUtil.getTempDir();
        if (tempSysDirName == null) {
            throw new FileUtilException("No temporary directory known to the server. [System.getProperty( \"java.io.tmpdir\" ) returns null. ]\n Cannot upload package.");
        }
        if (!new File(tempSysDirName).canWrite()) {
            String javaTemp = System.getProperty("java.io.tmpdir");
            if (!new File(javaTemp).canWrite()) {
                throw new FileUtilException("Do not have write permissions for temporary directory: " + tempSysDirName + " or java temp dir: " + javaTemp);
            }
            tempSysDirName = javaTemp;
        }
        String tempDirName = tempSysDirName + File.separator + prefix + FileUtil.generateUniqueContentFolderID() + "_" + suffix;
        File tempDir = new File(tempDirName);
        for (int i = 0; tempDir.exists() && i < 100; ++i) {
            tempDirName = tempSysDirName + File.separator + prefix + FileUtil.generateUniqueContentFolderID() + "_" + suffix;
            tempDir = new File(tempDirName);
        }
        if (tempDir.exists()) {
            throw new FileUtilException("Unable to create temporary directory. The temporary filename/directory that we would use to extract files already exists: " + tempDirName);
        }
        tempDir.mkdirs();
        return tempDirName;
    }

    public static boolean createDirectory(String directoryName) throws FileUtilException {
        boolean isCreated = false;
        if (directoryName == null || directoryName.length() == 0) {
            throw new FileUtilException("A directory name must be specified");
        }
        File dir = new File(directoryName);
        isCreated = dir.exists() ? false : dir.mkdirs();
        return isCreated;
    }

    public static boolean createDirectory(String parentDirName, String subDirName) throws FileUtilException {
        String combinedDirName;
        boolean isSubDirCreated = false;
        if (parentDirName == null || parentDirName.length() == 0 || subDirName == null || subDirName.length() == 0) {
            throw new FileUtilException("A parent or subdirectory name must be specified");
        }
        File parentDir = new File(parentDirName);
        boolean isParentDirCreated = !parentDir.exists() ? FileUtil.createDirectory(parentDirName) : true;
        if (FileUtil.trailingForwardSlashPresent(parentDirName)) {
            parentDirName = FileUtil.removeTrailingForwardSlash(parentDirName);
        }
        return (isSubDirCreated = FileUtil.createDirectory(combinedDirName = parentDirName + File.separator + subDirName)) && isParentDirCreated;
    }

    public static String removeTrailingForwardSlash(String stringToModify) {
        String stringWithoutSlashAtEnd = stringToModify.substring(0, stringToModify.length() - 1);
        return stringWithoutSlashAtEnd;
    }

    public static boolean trailingForwardSlashPresent(String stringToCheck) {
        int indexOfSlash = stringToCheck.lastIndexOf("/");
        return indexOfSlash == stringToCheck.length() - 1;
    }

    public static boolean directoryExist(String directoryToCheck) {
        File dir = new File(directoryToCheck);
        return dir.exists();
    }

    public static String getFileName(String fileName) {
        if (fileName == null) {
            return "";
        }
        fileName = fileName.trim();
        int dotPos = fileName.lastIndexOf("/");
        int dotPos2 = fileName.lastIndexOf("\\");
        if ((dotPos = Math.max(dotPos, dotPos2)) == -1) {
            return fileName;
        }
        return fileName.substring(dotPos + 1, fileName.length());
    }

    public static String getFileDirectory(String fileName) {
        if (fileName == null) {
            return "";
        }
        fileName = fileName.trim();
        int dotPos = fileName.lastIndexOf("/");
        int dotPos2 = fileName.lastIndexOf("\\");
        if ((dotPos = Math.max(dotPos, dotPos2)) == -1) {
            return "";
        }
        return fileName.substring(0, dotPos + 1);
    }

    public static String getFullPath(String path, String file) {
        String fullpath = path.endsWith(File.separator) ? path + file : path + File.separator + file;
        return FileUtil.makeCanonicalPath(fullpath);
    }

    public static String makeCanonicalPath(String pathfile) {
        pathfile = File.separator.indexOf("\\") != -1 ? pathfile.replaceAll("\\/", "\\\\") : pathfile.replaceAll("\\\\", File.separator);
        return pathfile;
    }

    public static String getFileExtension(String fileName) {
        if (fileName == null) {
            return "";
        }
        int dotPos = (fileName = fileName.trim()).lastIndexOf(".");
        if (dotPos == -1) {
            return "";
        }
        return fileName.substring(dotPos + 1, fileName.length());
    }

    public static boolean isExecutableFile(String filename) {
        String extname = FileUtil.getFileExtension(filename);
        log.debug((Object)("Check executable file for extension name " + extname));
        if (StringUtils.isBlank((String)extname)) {
            return false;
        }
        extname = "." + extname;
        String exeListStr = Configuration.get(ConfigurationKeys.EXE_EXTENSIONS);
        String[] extList = StringUtils.split((String)exeListStr, (char)',');
        boolean executable = false;
        for (String ext : extList) {
            if (!StringUtils.equalsIgnoreCase((String)ext, (String)extname)) continue;
            executable = true;
            break;
        }
        return executable;
    }

    public static boolean isExtensionAllowed(String fileType, String fileName) {
        String[] allowedExtensionsList;
        String allowedExtensions;
        String ext = UploadFileUtil.getFileExtension(fileName);
        ext = "." + ext;
        if ("File".equals(fileType)) {
            return !FileUtil.isExecutableFile(fileName);
        }
        if ("Image".equals(fileType)) {
            allowedExtensions = ALLOWED_EXTENSIONS_IMAGE;
        } else if ("Flash".equals(fileType)) {
            allowedExtensions = ALLOWED_EXTENSIONS_FLASH;
        } else if ("Media".equals(fileType)) {
            allowedExtensions = ALLOWED_EXTENSIONS_MEDIA;
        } else {
            return false;
        }
        for (String allowedExtension : allowedExtensionsList = StringUtils.split((String)allowedExtensions, (char)',')) {
            if (!StringUtils.equalsIgnoreCase((String)ext, (String)allowedExtension)) continue;
            return true;
        }
        return false;
    }

    public static int cleanupOldFiles(File[] directories) {
        int numDeleted = 0;
        if (directories != null) {
            for (int i = 0; i < directories.length; ++i) {
                if (FileUtil.deleteDirectory(directories[i])) {
                    log.info((Object)("Directory " + directories[i].getPath() + " deleted."));
                } else {
                    log.info((Object)("Directory " + directories[i].getPath() + " partially deleted - some directories/files could not be deleted."));
                }
                ++numDeleted;
            }
        }
        return numDeleted;
    }

    public static File[] getOldTempFiles(int numDays) throws FileUtilException {
        if (numDays < 0) {
            throw new FileUtilException("Invalid getOldTempFiles call - the parameter numDays is " + numDays + ". Must not be less than 0.");
        }
        long newestDateToKeep = System.currentTimeMillis() - (long)numDays * 86400000L;
        Date date = new Date(newestDateToKeep);
        log.info((Object)("Getting all temp zipfile expanded directories before " + date.toString() + " (server time) (" + newestDateToKeep + ")"));
        File tempSysDir = new File(FileUtil.getTempDir());
        File[] candidates = tempSysDir.listFiles(new TempDirectoryFilter(newestDateToKeep, log));
        return candidates;
    }

    public static long calculateFileSize(File file) {
        if (file != null) {
            if (file.isFile()) {
                return file.length();
            }
            if (file.isDirectory()) {
                File[] fileList = file.listFiles();
                long totalSize = 0L;
                if (fileList != null) {
                    for (int i = 0; i < fileList.length; ++i) {
                        totalSize += FileUtil.calculateFileSize(fileList[i]);
                    }
                    return totalSize;
                }
                return 0L;
            }
        } else {
            return 0L;
        }
        return 0L;
    }

    public static String stripInvalidChars(String name) {
        name = name.replaceAll("\\\\", "");
        name = name.replaceAll("\\/", "");
        name = name.replaceAll("\\:", "");
        name = name.replaceAll("\\*", "");
        name = name.replaceAll("\\?", "");
        name = name.replaceAll("\\>", "");
        name = name.replaceAll("\\<", "");
        name = name.replaceAll("\\|", "");
        name = name.replaceAll("\\#", "");
        name = name.replaceAll("\\%", "");
        name = name.replaceAll("\\$", "");
        name = name.replaceAll("\\;", "");
        return name;
    }

    public static String encodeFilenameForDownload(HttpServletRequest request, String unEncodedFilename) throws UnsupportedEncodingException {
        String agent = request.getHeader("USER-AGENT");
        String filename = null;
        filename = null != agent && -1 != agent.indexOf("MSIE") ? URLEncoder.encode(unEncodedFilename, ENCODING_UTF_8) : (null != agent && -1 != agent.indexOf("Mozilla") ? MimeUtility.encodeText((String)unEncodedFilename, (String)ENCODING_UTF_8, (String)"B") : unEncodedFilename);
        filename = "\"" + filename + "\"";
        return filename;
    }

    public static String generateUniqueContentFolderID() {
        UUIDGenerator uuidGen = new UUIDGenerator();
        ((Configurable)uuidGen).configure((Type)StringType.INSTANCE, new Properties(), null);
        return ((String)((Object)uuidGen.generate(null, null))).toLowerCase();
    }

    public static String getLearnerContentFolder(Long lessonId, Long userId) {
        return "runtime/" + lessonId + "/" + userId;
    }

    public static String getLearnerContentFolder(Long lessonId) {
        return "runtime/" + lessonId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getObjectFromXML(XStream xStream, String fullFilePath) throws IOException {
        Reader file = null;
        XStream conversionXml = xStream != null ? xStream : new XStream((HierarchicalStreamDriver)new StaxDriver());
        conversionXml.addPermission(AnyTypePermission.ANY);
        ConversionException finalException = null;
        String lastFieldRemoved = "";
        ToolContentVersionFilter contentFilter = null;
        int maxRetries = 30;
        int numTries = 0;
        while (true) {
            try {
                if (numTries <= maxRetries) {
                    ++numTries;
                    file = new InputStreamReader((InputStream)new FileInputStream(fullFilePath), ENCODING_UTF_8);
                    Object object = conversionXml.fromXML(file);
                    return object;
                }
            }
            catch (ConversionException ce) {
                Class problemClass;
                log.debug((Object)"Failed import", (Throwable)ce);
                finalException = ce;
                file.close();
                if (ce.getMessage() == null) break;
                String message = ce.getMessage();
                String classname = FileUtil.extractValue(message, "required-type");
                String fieldname = FileUtil.extractValue(message, "message");
                if (fieldname == null || fieldname.equals("") || lastFieldRemoved.equals(classname + "." + fieldname)) break;
                if (contentFilter == null) {
                    contentFilter = new ToolContentVersionFilter();
                }
                if ((problemClass = FileUtil.getClass(classname)) == null) break;
                contentFilter.removeField(problemClass, fieldname);
                contentFilter.transformXML(fullFilePath);
                lastFieldRemoved = classname + "." + fieldname;
                log.debug((Object)("Retrying import after removing field " + fieldname));
                continue;
            }
            finally {
                if (file == null) continue;
                file.close();
                continue;
            }
            break;
        }
        throw finalException;
    }

    private static String extractValue(String message, String fieldToLookFor) {
        try {
            int startIndex = message.indexOf(fieldToLookFor);
            if (startIndex > -1 && (startIndex = message.indexOf(":", startIndex + 1)) > -1 && startIndex + 2 < message.length()) {
                int endIndex = message.indexOf(" ", startIndex += 2);
                String value = message.substring(startIndex, endIndex);
                return value.trim();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return "";
    }

    private static Class getClass(String classname) {
        try {
            return Class.forName(classname);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Trying to remove unwanted fields from import but we can't find the matching class " + classname + ". Aborting retry."), (Throwable)e);
            return null;
        }
    }

    public static String getTempDir() {
        boolean success;
        String ret = Configuration.get(ConfigurationKeys.LAMS_TEMP_DIR);
        File tempDir = new File(ret);
        if (!tempDir.exists() && !(success = tempDir.mkdirs())) {
            log.error((Object)("Could not create temp directory: " + ret));
            return System.getProperty("java.io.tmpdir");
        }
        if (!tempDir.canWrite()) {
            return System.getProperty("java.io.tmpdir");
        }
        return ret;
    }

    public static void writeXMLtoFile(Document doc, File file) throws IOException {
        StreamResult streamResult = new StreamResult(new FileOutputStream(file));
        DOMSource domSource = new DOMSource(doc);
        try {
            xmlTransformer.transform(domSource, streamResult);
        }
        catch (TransformerException e) {
            throw new IOException("Error while writing out XML document to file", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String writeXMLtoString(Document doc) {
        try (StringWriter writer = new StringWriter();){
            StreamResult streamResult = new StreamResult(writer);
            DOMSource domSource = new DOMSource(doc);
            xmlTransformer.transform(domSource, streamResult);
            String string = writer.toString();
            return string;
        }
        catch (Exception e) {
            log.error((Object)"Error while writing out XML document to string", (Throwable)e);
            return null;
        }
    }

    static {
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            xmlTransformer = tf.newTransformer();
            xmlTransformer.setOutputProperty("encoding", "UTF-8");
            xmlTransformer.setOutputProperty("indent", "yes");
            xmlTransformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        }
        catch (Exception e) {
            log.error((Object)"Error while initialising XML transformer", (Throwable)e);
        }
    }
}

