/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web.session;

import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SessionManager {
    public static final String SYS_SESSION_COOKIE = "JSESSIONID";
    public static final String LOG_OUT_FLAG = "lamsLogOutFlag";
    private static SessionManager sessionManager;
    private static final Map<String, HttpSession> sessionIdMapping;
    private static final Map<String, HttpSession> loginMapping;
    private ThreadLocal<String> currentSessionIdContainer = new ThreadLocal();
    private static ServletContext servletContext;
    private static String jvmRoute;

    public void init() {
        if (sessionManager == null) {
            sessionManager = this;
        }
    }

    public void destroy() {
        sessionManager = null;
    }

    public static void startSession(HttpServletRequest request) {
        HttpSession session = request.getSession();
        if (session.getAttribute(LOG_OUT_FLAG) != null) {
            session.invalidate();
            throw new SecurityException("You were logged out");
        }
        String sessionId = session.getId();
        sessionIdMapping.put(sessionId, session);
        SessionManager.sessionManager.currentSessionIdContainer.set(sessionId);
        String login = request.getRemoteUser();
        if (login != null) {
            HttpSession existingSession = loginMapping.get(login);
            if (existingSession != null && !existingSession.getId().equals(sessionId)) {
                if (session.getCreationTime() > existingSession.getCreationTime()) {
                    existingSession.setAttribute(LOG_OUT_FLAG, (Object)true);
                } else {
                    session.invalidate();
                    throw new SecurityException("You were logged out");
                }
            }
            loginMapping.put(login, session);
        }
    }

    public static void endSession() {
        SessionManager.sessionManager.currentSessionIdContainer.set(null);
    }

    public static void removeSessionByLogin(String login, boolean invalidate) {
        HttpSession session = loginMapping.get(login);
        if (session == null) {
            return;
        }
        loginMapping.remove(login);
        if (invalidate) {
            session.setAttribute(LOG_OUT_FLAG, (Object)true);
        }
    }

    public static void removeSessionByID(String sessionID, boolean invalidate, boolean clearLoginMapping) {
        HttpSession session = SessionManager.getSession(sessionID);
        if (session != null) {
            sessionIdMapping.remove(sessionID);
            if (invalidate) {
                session.setAttribute(LOG_OUT_FLAG, (Object)true);
            }
        }
        if (clearLoginMapping) {
            String login = null;
            for (Map.Entry<String, HttpSession> sessionEntry : loginMapping.entrySet()) {
                if (!sessionID.equals(sessionEntry.getValue().getId())) continue;
                login = sessionEntry.getKey();
                break;
            }
            if (login != null) {
                loginMapping.remove(login);
            }
        }
    }

    public static void updateSessionID(String sessionID) {
        HttpSession session = SessionManager.getSession(sessionID);
        if (session == null) {
            return;
        }
        String newSessionID = session.getId();
        if (!sessionID.equals(newSessionID)) {
            sessionIdMapping.remove(sessionID);
            sessionIdMapping.put(newSessionID, session);
            SessionManager.sessionManager.currentSessionIdContainer.set(newSessionID);
        }
    }

    public static HttpSession getSession() {
        String sessionId = SessionManager.sessionManager.currentSessionIdContainer.get();
        return SessionManager.getSession(sessionId);
    }

    public static HttpSession getSession(String sessionId) {
        return sessionId == null ? null : sessionIdMapping.get(sessionId);
    }

    public static HttpSession getSessionForLogin(String login) {
        return loginMapping.get(login);
    }

    public static int getSessionCount() {
        return sessionIdMapping.size();
    }

    public static Map<String, String> getLoginToSessionIDMappings() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Map.Entry<String, HttpSession> entry : loginMapping.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getId());
        }
        return result;
    }

    public static void setServletContext(ServletContext servletContext) {
        SessionManager.servletContext = servletContext;
    }

    public static ServletContext getServletContext() {
        return servletContext;
    }

    public static String getJvmRoute() {
        return jvmRoute;
    }

    public static void setJvmRoute(String jvmRoute) {
        SessionManager.jvmRoute = jvmRoute;
    }

    static {
        sessionIdMapping = new ConcurrentHashMap<String, HttpSession>();
        loginMapping = new ConcurrentHashMap<String, HttpSession>();
    }
}

