/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ActivityOrderComparator;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.LearningLibrary;
import org.lamsfoundation.lams.learningdesign.SimpleActivity;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.strategy.ToolActivityStrategy;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.LessonClass;
import org.lamsfoundation.lams.tool.GroupedToolSession;
import org.lamsfoundation.lams.tool.NonGroupedToolSession;
import org.lamsfoundation.lams.tool.Tool;
import org.lamsfoundation.lams.tool.ToolSession;
import org.lamsfoundation.lams.usermanagement.User;

public class ToolActivity
extends SimpleActivity
implements Serializable {
    private static Logger log = Logger.getLogger(ToolActivity.class);
    private Long toolContentId;
    private Tool tool;
    private Set toolSessions;

    public ToolActivity(Long activityId, Integer id, String description, String title, Integer xcoord, Integer ycoord, Integer orderId, Boolean defineLater, Date createDateTime, LearningLibrary learningLibrary, Activity parentActivity, Activity libraryActivity, Integer parentUIID, LearningDesign learningDesign, Grouping grouping, Integer activityTypeId, Transition transitionTo, Transition transitionFrom, String languageFile, Tool tool, Long toolContentId) {
        super(activityId, id, description, title, xcoord, ycoord, orderId, defineLater, createDateTime, learningLibrary, parentActivity, libraryActivity, parentUIID, learningDesign, grouping, activityTypeId, transitionTo, transitionFrom, languageFile);
        this.tool = tool;
        this.toolContentId = toolContentId;
        this.simpleActivityStrategy = new ToolActivityStrategy(this);
    }

    public ToolActivity() {
        this.simpleActivityStrategy = new ToolActivityStrategy(this);
    }

    public ToolActivity(Long activityId, Boolean defineLater, Date createDateTime, LearningLibrary learningLibrary, Activity parentActivity, LearningDesign learningDesign, Grouping grouping, Integer activityTypeId, Transition transitionTo, Transition transitionFrom, Tool tool, Long toolContentId) {
        super(activityId, defineLater, createDateTime, learningLibrary, parentActivity, learningDesign, grouping, activityTypeId, transitionTo, transitionFrom);
        this.tool = tool;
        this.toolContentId = toolContentId;
        this.simpleActivityStrategy = new ToolActivityStrategy(this);
    }

    public Activity createCopy() {
        ToolActivity newToolActivity = new ToolActivity();
        newToolActivity.setTool(this.getTool());
        newToolActivity.setToolContentId(this.getToolContentId());
        newToolActivity.setActivityUIID(this.getActivityUIID());
        newToolActivity.setDescription(this.getDescription());
        newToolActivity.setTitle(this.getTitle());
        newToolActivity.setHelpText(this.getHelpText());
        newToolActivity.setXcoord(this.getXcoord());
        newToolActivity.setYcoord(this.getYcoord());
        newToolActivity.setActivityTypeId(this.getActivityTypeId());
        newToolActivity.setGroupingSupportType(this.getGroupingSupportType());
        newToolActivity.setApplyGrouping(this.getApplyGrouping());
        newToolActivity.setGrouping(this.getGrouping());
        newToolActivity.setGroupingUIID(this.getGroupingUIID());
        newToolActivity.setOrderId(this.getOrderId());
        newToolActivity.setDefineLater(this.getDefineLater());
        newToolActivity.setLearningLibrary(this.getLearningLibrary());
        newToolActivity.setCreateDateTime(new Date());
        newToolActivity.setRunOffline(this.getRunOffline());
        newToolActivity.setActivityCategoryID(this.getActivityCategoryID());
        newToolActivity.setLibraryActivityUiImage(this.getLibraryActivityUiImage());
        newToolActivity.setLibraryActivity(this.getLibraryActivity());
        newToolActivity.setLanguageFile(this.getLanguageFile());
        return newToolActivity;
    }

    public ToolSession createToolSessionForActivity(User learner, Lesson lesson) {
        Date now = new Date(System.currentTimeMillis());
        Integer supportType = this.getGroupingSupportType();
        ToolSession session = null;
        if (supportType != null && (supportType == 3 || supportType == 2)) {
            Group learners = null;
            if (this.getApplyGrouping().booleanValue()) {
                learners = this.getGroupFor(learner);
            }
            if (supportType == 3 && learners == null) {
                log.error((Object)("Activity " + this.getActivityId() + " requires grouping (groupingSupportType=GROUPING_SUPPORT_REQUIRED) but no grouping was available. " + " applyGrouping = " + this.getApplyGrouping() + " grouping = " + this.getGrouping() + ". Falling back to a class grouping."));
            }
            if (learners == null || learners.isNull()) {
                LessonClass lessonClass = lesson.getLessonClass();
                learners = this.getGroupFor(learner, lessonClass);
            }
            if (learners != null && !learners.isNull()) {
                session = new GroupedToolSession(this, now, 1, learners, lesson);
            } else {
                log.error((Object)("Unable to get the group for a new tool session for Activity " + this.getActivityId() + " Falling back to one learner per session." + " Learner " + learner + ", lesson is " + lesson));
            }
        }
        if (session == null) {
            session = new NonGroupedToolSession(this, now, 1, learner, lesson);
        }
        return session;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("activityId", (Object)this.getActivityId()).toString();
    }

    public Long getToolContentId() {
        return this.toolContentId;
    }

    public void setToolContentId(Long toolContentId) {
        this.toolContentId = toolContentId;
    }

    public Tool getTool() {
        return this.tool;
    }

    public void setTool(Tool tool) {
        this.tool = tool;
    }

    public Set getToolSessions() {
        if (this.toolSessions == null) {
            this.setToolSessions(new TreeSet(new ActivityOrderComparator()));
        }
        return this.toolSessions;
    }

    public void setToolSessions(Set toolSessions) {
        this.toolSessions = toolSessions;
    }

    public boolean isNull() {
        return false;
    }

    protected void getToolActivitiesInActivity(SortedSet toolActivities) {
        toolActivities.add(this);
    }
}

