/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.lesson.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.Grouper;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.dao.IGroupingDAO;
import org.lamsfoundation.lams.learningdesign.exception.GroupingException;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.dao.ILessonDAO;
import org.lamsfoundation.lams.lesson.dto.LessonDTO;
import org.lamsfoundation.lams.lesson.dto.LessonDetailsDTO;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.lesson.service.LessonServiceException;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.util.MessageService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LessonService
implements ILessonService {
    private static Logger log = Logger.getLogger(LessonService.class);
    private ILessonDAO lessonDAO;
    private IGroupingDAO groupingDAO;
    private MessageService messageService;
    private HashMap<Long, HashMap> lessonMaps = new HashMap();

    public void setLessonDAO(ILessonDAO lessonDAO) {
        this.lessonDAO = lessonDAO;
    }

    public void setGroupingDAO(IGroupingDAO groupingDAO) {
        this.groupingDAO = groupingDAO;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheLessonUser(Lesson lesson, User learner) {
        Lesson lesson2 = lesson;
        synchronized (lesson2) {
            HashMap<Integer, User> lessonUsersMap = this.lessonMaps.get(lesson.getLessonId());
            if (lessonUsersMap == null) {
                lessonUsersMap = new HashMap<Integer, User>();
                this.lessonMaps.put(lesson.getLessonId(), lessonUsersMap);
            }
            if (!lessonUsersMap.containsKey(learner.getUserId())) {
                lessonUsersMap.put(learner.getUserId(), learner);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLessonUserFromCache(Lesson lesson, User learner) {
        Lesson lesson2 = lesson;
        synchronized (lesson2) {
            HashMap lessonUsersMap = this.lessonMaps.get(lesson.getLessonId());
            if (lessonUsersMap != null) {
                lessonUsersMap.remove(learner.getUserId());
            }
            if (lessonUsersMap.size() == 0) {
                this.lessonMaps.remove(lesson.getLessonId());
            }
        }
    }

    @Override
    public Collection getLoggedInLessonLearners(Long lessonId) {
        HashMap lessonUsersMap = this.lessonMaps.get(lessonId);
        if (lessonUsersMap != null) {
            return lessonUsersMap.values();
        }
        return new ArrayList();
    }

    @Override
    public List getActiveLessonLearners(Long lessonId) {
        return this.lessonDAO.getActiveLearnerByLesson(lessonId);
    }

    @Override
    public Integer getCountActiveLessonLearners(Long lessonId) {
        return this.lessonDAO.getCountActiveLearnerByLesson(lessonId);
    }

    @Override
    public LessonDetailsDTO getLessonDetails(Long lessonId) {
        Lesson lesson = this.lessonDAO.getLesson(lessonId);
        LessonDetailsDTO dto = null;
        if (lesson != null) {
            dto = lesson.getLessonDetails();
            Integer active = this.getCountActiveLessonLearners(lessonId);
            dto.setNumberStartedLearners(active != null ? active : new Integer(0));
        }
        return dto;
    }

    @Override
    public LessonDTO getLessonData(Long lessonId) {
        Lesson lesson = this.lessonDAO.getLesson(lessonId);
        LessonDTO dto = null;
        if (lesson != null) {
            dto = lesson.getLessonData();
        }
        return dto;
    }

    @Override
    public void performGrouping(Long lessonId, GroupingActivity groupingActivity, User learner) throws LessonServiceException {
        Grouping grouping = groupingActivity.getCreateGrouping();
        if (grouping != null && grouping.isRandomGrouping()) {
            Grouper grouper = (grouping = this.groupingDAO.getGroupingById(grouping.getGroupingId())).getGrouper();
            if (grouper != null) {
                grouper.setCommonMessageService(this.messageService);
                try {
                    if (grouping.getGroups().size() == 0) {
                        List usersInLesson = this.getActiveLessonLearners(lessonId);
                        grouper.doGrouping(grouping, (String)null, usersInLesson);
                    } else if (!grouping.doesLearnerExist(learner)) {
                        grouper.doGrouping(grouping, null, learner);
                    }
                }
                catch (GroupingException e) {
                    throw new LessonServiceException(e);
                }
                this.groupingDAO.update(grouping);
            }
        } else {
            String error = "The method performGrouping supports only grouping methods where the grouper decides the groups (currently only RandomGrouping). Called with a groupingActivity with the wrong grouper " + groupingActivity.getActivityId();
            log.error((Object)error);
            throw new LessonServiceException(error);
        }
    }

    @Override
    public void performGrouping(GroupingActivity groupingActivity, String groupName, List learners) throws LessonServiceException {
        Grouping grouping = groupingActivity.getCreateGrouping();
        if (grouping != null && grouping.isChosenGrouping()) {
            Grouper grouper = grouping.getGrouper();
            if (grouper != null) {
                grouper.setCommonMessageService(this.messageService);
                try {
                    grouper.doGrouping(grouping, groupName, learners);
                }
                catch (GroupingException e) {
                    throw new LessonServiceException(e);
                }
                this.groupingDAO.update(grouping);
            }
        } else {
            String error = "The method performChosenGrouping supports only grouping methods where the supplied list should be used as a single group (currently only ChosenGrouping). Called with a groupingActivity with the wrong grouper " + groupingActivity.getActivityId();
            log.error((Object)error);
            throw new LessonServiceException(error);
        }
    }

    @Override
    public void performGrouping(GroupingActivity groupingActivity, Long groupId, List learners) throws LessonServiceException {
        Grouping grouping = groupingActivity.getCreateGrouping();
        if (grouping != null && grouping.isChosenGrouping()) {
            Grouper grouper = grouping.getGrouper();
            if (grouper != null) {
                grouper.setCommonMessageService(this.messageService);
                try {
                    grouper.doGrouping(grouping, groupId, learners);
                }
                catch (GroupingException e) {
                    throw new LessonServiceException(e);
                }
                this.groupingDAO.update(grouping);
            }
        } else {
            String error = "The method performChosenGrouping supports only grouping methods where the supplied list should be used as a single group (currently only ChosenGrouping). Called with a groupingActivity with the wrong grouper " + groupingActivity.getActivityId();
            log.error((Object)error);
            throw new LessonServiceException(error);
        }
    }

    @Override
    public void removeLearnersFromGroup(GroupingActivity groupingActivity, Long groupID, List<User> learners) throws LessonServiceException {
        Grouping grouping = groupingActivity.getCreateGrouping();
        if (grouping != null) {
            Grouper grouper = (grouping = this.groupingDAO.getGroupingById(grouping.getGroupingId())).getGrouper();
            if (grouper != null) {
                try {
                    grouper.removeLearnersFromGroup(grouping, groupID, learners);
                }
                catch (GroupingException e) {
                    throw new LessonServiceException(e);
                }
            }
            this.groupingDAO.update(grouping);
        }
    }

    @Override
    public void createGroup(GroupingActivity groupingActivity, String name) throws LessonServiceException {
        Grouping grouping = groupingActivity.getCreateGrouping();
        if (grouping != null) {
            Grouper grouper = (grouping = this.groupingDAO.getGroupingById(grouping.getGroupingId())).getGrouper();
            if (grouper != null) {
                try {
                    grouper.createGroup(grouping, name);
                }
                catch (GroupingException e) {
                    throw new LessonServiceException(e);
                }
            }
            this.groupingDAO.update(grouping);
        }
    }

    @Override
    public void removeGroup(GroupingActivity groupingActivity, Long groupID) throws LessonServiceException {
        Grouping grouping = groupingActivity.getCreateGrouping();
        if (grouping != null) {
            Grouper grouper = (grouping = this.groupingDAO.getGroupingById(grouping.getGroupingId())).getGrouper();
            if (grouper != null) {
                try {
                    grouper.removeGroup(grouping, groupID);
                }
                catch (GroupingException e) {
                    throw new LessonServiceException(e);
                }
            }
            this.groupingDAO.update(grouping);
        }
    }
}

