/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.usermanagement.dao.hibernate;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.lamsfoundation.lams.dao.hibernate.BaseDAO;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.dao.IOrganisationDAO;

public class OrganisationDAO
extends BaseDAO
implements IOrganisationDAO {
    private static final String TABLENAME = "lams_organisation";
    private static final String FIND_BY_WORKSPACE = "from lams_organisation in class " + Organisation.class.getName() + " where workspace_id=?";

    public List getAllOrganisations() {
        return this.getHibernateTemplate().find("from Organisation");
    }

    public Organisation getOrganisationById(Integer organisationId) {
        return (Organisation)this.getHibernateTemplate().get(Organisation.class, (Serializable)organisationId);
    }

    public List getOrganisationsByName(String name) {
        String queryString = "from Organisation o where o.name=?";
        return this.getHibernateTemplate().find(queryString, (Object)name);
    }

    public List getChildOrganisations(Organisation parentOrg) {
        String queryString = "from Organisation o where o.parentOrganisation.organisationId=?";
        return this.getHibernateTemplate().find(queryString, (Object)parentOrg.getOrganisationId());
    }

    public void delete(Organisation organisation) {
        Iterator iter = organisation.getChildOrganisations().iterator();
        Organisation parentOrganisation = organisation.getParentOrganisation();
        while (iter.hasNext()) {
            Organisation childOrganisation = (Organisation)iter.next();
            childOrganisation.setParentOrganisation(parentOrganisation);
            iter.remove();
        }
        this.delete(organisation);
    }

    public void deleteOrganisationById(Integer organisationId) {
        this.delete(this.getOrganisationById(organisationId));
    }

    public Organisation getOrganisationByWorkspaceID(Integer workspaceID) {
        List list = this.getHibernateTemplate().find(FIND_BY_WORKSPACE, (Object)workspaceID);
        if (list.size() != 0) {
            return (Organisation)list.get(0);
        }
        return null;
    }

    public List getOrganisationsByType(Integer organisationTypeId) {
        String queryString = "from Organisation o where o.organisationType.organisationTypeId=?";
        return this.getHibernateTemplate().find(queryString, (Object)organisationTypeId);
    }
}

