/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.usermanagement.dao.hibernate;

import java.io.Serializable;
import java.util.List;
import org.lamsfoundation.lams.dao.hibernate.BaseDAO;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.UserOrganisation;
import org.lamsfoundation.lams.usermanagement.dao.IUserOrganisationDAO;

public class UserOrganisationDAO
extends BaseDAO
implements IUserOrganisationDAO {
    public List getAllUserOrganisations() {
        return this.getHibernateTemplate().find("from UserOrganisation");
    }

    public UserOrganisation getUserOrganisationById(Integer userOrganisationId) {
        return (UserOrganisation)this.getHibernateTemplate().get(UserOrganisation.class, (Serializable)userOrganisationId);
    }

    public UserOrganisation getUserOrganisation(Integer userId, Integer orgnisationId) {
        String queryString = "from UserOrganisation uo where uo.user.userId=? and uo.organisation.organisationId=?";
        List list = this.getHibernateTemplate().find(queryString, new Object[]{userId, orgnisationId});
        if (list.size() == 0) {
            return null;
        }
        return (UserOrganisation)list.get(0);
    }

    public List getUserOrganisationsByUser(User user) {
        String queryString = "from UserOrganisation uo where uo.user.userId=?";
        return this.getHibernateTemplate().find(queryString, (Object)user.getUserId());
    }

    public List getChildUserOrganisationsByUser(User user, Organisation parentOrganisation) {
        String queryString = "from UserOrganisation uo where uo.user.userId=?  and uo.organisation.parentOrganisation.organisationId=?";
        return this.getHibernateTemplate().find(queryString, new Object[]{user.getUserId(), parentOrganisation.getOrganisationId()});
    }

    public List getUserOrganisationsByOrganisation(Organisation organisation) {
        String queryString = "from UserOrganisation uo where uo.organisation.organisationId=?";
        return this.getHibernateTemplate().find(queryString, (Object)organisation.getOrganisationId());
    }

    public List getUserOrganisationsByOrganisationId(Integer organisationId) {
        String queryString = "from UserOrganisation uo where uo.organisation.organisationId=?";
        return this.getHibernateTemplate().find(queryString, (Object)organisationId);
    }

    public void deleteUserOrganisationById(Integer userOrganisationId) {
        this.delete(this.getUserOrganisationById(userOrganisationId));
    }

    public List getUserOrganisationsByType(Integer organisationTypeId) {
        String queryString = "from UserOrganisation uo where uo.organisation.organisationType.organisationTypeId=?";
        return this.getHibernateTemplate().find(queryString, (Object)organisationTypeId);
    }
}

