/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.stp.services.messages;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.opera.core.systems.scope.Message;
import java.util.Map;

public enum EcmascriptDebuggerMessage implements Message
{
    LIST_RUNTIMES(1),
    EVAL(3),
    INSPECT_DOM(13),
    EXAMINE_OBJECTS(4),
    SET_CONFIGURATION(10),
    RELEASE_OBJECTS(29),
    RUNTIME_STARTED(14),
    RUNTIME_STOPPED(15),
    NEW_SCRIPT(16),
    THREAD_STARTED(17),
    THREAD_FINISHED(18),
    THREAD_STOPPED_AT(19),
    HANDLE_EVENT(20),
    OBJECT_SELECTED(21),
    PARSE_ERROR(28),
    DEFAULT(-1);

    private static final Map<Integer, EcmascriptDebuggerMessage> lookup;
    private final int code;

    private EcmascriptDebuggerMessage(int code) {
        this.code = code;
    }

    @Override
    public int getID() {
        return this.code;
    }

    @Override
    public String getServiceName() {
        return "ecmascript-debugger";
    }

    public static EcmascriptDebuggerMessage get(int code) {
        EcmascriptDebuggerMessage message = lookup.get(code);
        return message != null ? message : DEFAULT;
    }

    static {
        lookup = Maps.uniqueIndex((Iterable)ImmutableList.copyOf((Object[])EcmascriptDebuggerMessage.values()), (Function)new Function<EcmascriptDebuggerMessage, Integer>(){

            public Integer apply(EcmascriptDebuggerMessage command) {
                return command.getID();
            }
        });
    }
}

