/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.chat.JabberHTTPBind;

import java.io.StringWriter;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.lamsfoundation.lams.tool.chat.JabberHTTPBind.JHBServlet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Response {
    private static TransformerFactory tff = TransformerFactory.newInstance();
    public static final String STATUS_LEAVING = "leaving";
    public static final String STATUS_PENDING = "pending";
    public static final String STATUS_DONE = "done";
    private HttpServletResponse response;
    private long cDate;
    private Document doc;
    private Element body;
    private int rid;
    private String status;

    public Response(HttpServletResponse response, Document doc) {
        this.response = response;
        this.doc = doc;
        this.body = this.doc.createElement("body");
        this.doc.appendChild(this.body);
        this.body.setAttribute("xmlns", "http://jabber.org/protocol/httpbind");
        this.cDate = System.currentTimeMillis();
        this.setStatus(STATUS_PENDING);
    }

    public Response setAttribute(String key, String val) {
        this.body.setAttribute(key, val);
        return this;
    }

    public Response setContentType(String type) {
        this.response.setContentType(type);
        return this;
    }

    public Response addNode(Node n) {
        try {
            if (((Element)n).getAttribute("xmlns") == "") {
                ((Element)n).setAttribute("xmlns", "jabber:client");
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.body.appendChild(this.doc.importNode(n, true));
        return this;
    }

    public synchronized void send() {
        StringWriter strWtr = new StringWriter();
        StreamResult strResult = new StreamResult(strWtr);
        try {
            Transformer tf = tff.newTransformer();
            tf.setOutputProperty("omit-xml-declaration", "yes");
            tf.transform(new DOMSource(this.doc.getDocumentElement()), strResult);
            this.response.getWriter().println(strResult.getWriter().toString());
            JHBServlet.dbg("sent response for " + this.getRID(), 3);
        }
        catch (Exception e) {
            JHBServlet.dbg("XML.toString(Document): " + e, 1);
        }
        this.setStatus(STATUS_DONE);
    }

    public synchronized String getStatus() {
        return this.status;
    }

    public synchronized void setStatus(String status) {
        JHBServlet.dbg("response status " + status + " for " + this.getRID(), 3);
        this.status = status;
    }

    public int getRID() {
        return this.rid;
    }

    public Response setRID(int rid) {
        this.rid = rid;
        return this;
    }

    public synchronized long getCDate() {
        return this.cDate;
    }
}

