/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.chat.dto;

import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.tool.chat.dto.ChatAttachmentDTO;
import org.lamsfoundation.lams.tool.chat.dto.ChatSessionDTO;
import org.lamsfoundation.lams.tool.chat.model.Chat;
import org.lamsfoundation.lams.tool.chat.model.ChatAttachment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChatDTO {
    private static Logger logger = Logger.getLogger(ChatDTO.class);
    public Long toolContentId;
    public String title;
    public String instructions;
    public String onlineInstructions;
    public String offlineInstructions;
    public boolean defineLater;
    public boolean contentInUse;
    public boolean reflectOnActivity;
    public boolean lockOnFinish;
    public boolean filteringEnabled;
    public String filteredKeyWords;
    public String reflectInstructions;
    public Set<ChatAttachmentDTO> onlineInstructionsFiles = new TreeSet<ChatAttachmentDTO>();
    public Set<ChatAttachmentDTO> offlineInstructionsFiles = new TreeSet<ChatAttachmentDTO>();
    public Set<ChatSessionDTO> sessionDTOs = new TreeSet<ChatSessionDTO>();
    public Long currentTab;

    public ChatDTO(Chat chat) {
        this.toolContentId = chat.getToolContentId();
        this.title = chat.getTitle();
        this.instructions = chat.getInstructions();
        this.onlineInstructions = chat.getOnlineInstructions();
        this.offlineInstructions = chat.getOfflineInstructions();
        this.contentInUse = chat.isContentInUse();
        this.reflectInstructions = chat.getReflectInstructions();
        this.reflectOnActivity = chat.isReflectOnActivity();
        this.lockOnFinish = chat.isLockOnFinished();
        this.filteringEnabled = chat.isFilteringEnabled();
        this.filteredKeyWords = chat.getFilterKeywords();
        for (ChatAttachment att : chat.getChatAttachments()) {
            ChatAttachmentDTO attDTO;
            if (att.getFileType().equals("OFFLINE")) {
                attDTO = new ChatAttachmentDTO(att);
                this.offlineInstructionsFiles.add(attDTO);
                continue;
            }
            if (att.getFileType().equals("ONLINE")) {
                attDTO = new ChatAttachmentDTO(att);
                this.onlineInstructionsFiles.add(attDTO);
                continue;
            }
            logger.error((Object)("File with uid " + att.getFileUuid() + " contains invalid fileType: " + att.getFileType()));
        }
    }

    public Set<ChatSessionDTO> getSessionDTOs() {
        return this.sessionDTOs;
    }

    public void setSessionDTOs(Set<ChatSessionDTO> sessionDTOs) {
        this.sessionDTOs = sessionDTOs;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public void setInstructions(String instructions) {
        this.instructions = instructions;
    }

    public String getOfflineInstructions() {
        return this.offlineInstructions;
    }

    public void setOfflineInstructions(String offlineInstructions) {
        this.offlineInstructions = offlineInstructions;
    }

    public Set<ChatAttachmentDTO> getOfflineInstructionsFiles() {
        return this.offlineInstructionsFiles;
    }

    public void setOfflineInstructionsFiles(Set<ChatAttachmentDTO> offlineInstructionsFiles) {
        this.offlineInstructionsFiles = offlineInstructionsFiles;
    }

    public String getOnlineInstructions() {
        return this.onlineInstructions;
    }

    public void setOnlineInstructions(String onlineInstructions) {
        this.onlineInstructions = onlineInstructions;
    }

    public Set<ChatAttachmentDTO> getOnlineInstructionsFiles() {
        return this.onlineInstructionsFiles;
    }

    public void setOnlineInstructionsFiles(Set<ChatAttachmentDTO> onlineInstructionsFiles) {
        this.onlineInstructionsFiles = onlineInstructionsFiles;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Long getToolContentId() {
        return this.toolContentId;
    }

    public void setToolContentId(Long toolContentID) {
        this.toolContentId = toolContentID;
    }

    public String getReflectInstructions() {
        return this.reflectInstructions;
    }

    public void setReflectInstructions(String reflectInstructions) {
        this.reflectInstructions = reflectInstructions;
    }

    public boolean isContentInUse() {
        return this.contentInUse;
    }

    public void setContentInUse(boolean contentInUse) {
        this.contentInUse = contentInUse;
    }

    public boolean isDefineLater() {
        return this.defineLater;
    }

    public void setDefineLater(boolean defineLater) {
        this.defineLater = defineLater;
    }

    public boolean isReflectOnActivity() {
        return this.reflectOnActivity;
    }

    public void setReflectOnActivity(boolean reflectOnActivity) {
        this.reflectOnActivity = reflectOnActivity;
    }

    public boolean isLockOnFinish() {
        return this.lockOnFinish;
    }

    public void setLockOnFinish(boolean lockOnFinish) {
        this.lockOnFinish = lockOnFinish;
    }

    public Long getCurrentTab() {
        return this.currentTab;
    }

    public void setCurrentTab(Long currentTab) {
        this.currentTab = currentTab;
    }

    public boolean isFilteringEnabled() {
        return this.filteringEnabled;
    }

    public void setFilteringEnabled(boolean filteringEnabled) {
        this.filteringEnabled = filteringEnabled;
    }

    public String getFilteredKeyWords() {
        return this.filteredKeyWords;
    }

    public void setFilteredKeyWords(String filteredKeyWords) {
        this.filteredKeyWords = filteredKeyWords;
    }
}

