/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.chat.web.actions;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.chat.dto.ChatDTO;
import org.lamsfoundation.lams.tool.chat.dto.ChatSessionDTO;
import org.lamsfoundation.lams.tool.chat.dto.ChatUserDTO;
import org.lamsfoundation.lams.tool.chat.model.Chat;
import org.lamsfoundation.lams.tool.chat.model.ChatMessage;
import org.lamsfoundation.lams.tool.chat.model.ChatSession;
import org.lamsfoundation.lams.tool.chat.model.ChatUser;
import org.lamsfoundation.lams.tool.chat.service.ChatServiceProxy;
import org.lamsfoundation.lams.tool.chat.service.IChatService;
import org.lamsfoundation.lams.tool.chat.web.forms.MonitoringForm;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;

public class MonitoringAction
extends LamsDispatchAction {
    private static Logger log = Logger.getLogger(MonitoringAction.class);
    public IChatService chatService;

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        log.info((Object)"excuting monitoring action");
        Long toolContentID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID"));
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        if (this.chatService == null) {
            this.chatService = ChatServiceProxy.getChatService(this.getServlet().getServletContext());
        }
        Chat chat = this.chatService.getChatByContentId(toolContentID);
        ChatDTO chatDTO = new ChatDTO(chat);
        Long currentTab = WebUtil.readLongParam((HttpServletRequest)request, (String)"currentTab", (boolean)true);
        chatDTO.setCurrentTab(currentTab);
        Map<Long, Integer> sessCountMap = this.chatService.getMessageCountBySession(chat.getUid());
        for (ChatSession session : chat.getChatSessions()) {
            List latestMessages = this.chatService.getLastestMessages(session, 5);
            ChatSessionDTO sessionDTO = new ChatSessionDTO(session, latestMessages);
            Integer count = sessCountMap.get(session.getUid());
            if (count == null) {
                count = 0;
            }
            sessionDTO.setNumberOfPosts(count);
            Map<Long, Integer> userCountMap = this.chatService.getMessageCountByFromUser(session.getUid());
            sessionDTO.setNumberOfLearners(userCountMap.size());
            for (ChatUser user : session.getChatUsers()) {
                ChatUserDTO userDTO = new ChatUserDTO(user);
                count = userCountMap.get(user.getUid());
                if (count == null) {
                    count = 0;
                }
                userDTO.setPostCount(count);
                NotebookEntry notebookEntry = this.chatService.getEntry(session.getSessionId(), CoreNotebookConstants.NOTEBOOK_TOOL, "lachat11", user.getUserId().intValue());
                userDTO.finishedReflection = notebookEntry != null;
                sessionDTO.getUserDTOs().add(userDTO);
            }
            chatDTO.getSessionDTOs().add(sessionDTO);
        }
        request.setAttribute("monitoringDTO", (Object)chatDTO);
        request.setAttribute("contentFolderID", (Object)contentFolderID);
        return mapping.findForward("success");
    }

    public ActionForward openChatHistory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        MonitoringForm monitoringForm = (MonitoringForm)form;
        ChatSession chatSession = this.chatService.getSessionBySessionId(monitoringForm.getToolSessionID());
        ChatSessionDTO sessionDTO = new ChatSessionDTO(chatSession);
        request.setAttribute("sessionDTO", (Object)sessionDTO);
        return mapping.findForward("chat_history");
    }

    public ActionForward openNotebook(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long uid = WebUtil.readLongParam((HttpServletRequest)request, (String)"uid", (boolean)false);
        ChatUser chatUser = this.chatService.getUserByUID(uid);
        NotebookEntry notebookEntry = this.chatService.getEntry(chatUser.getChatSession().getSessionId(), CoreNotebookConstants.NOTEBOOK_TOOL, "lachat11", chatUser.getUserId().intValue());
        ChatUserDTO chatUserDTO = new ChatUserDTO(chatUser);
        chatUserDTO.setNotebookEntry(notebookEntry.getEntry());
        request.setAttribute("chatUserDTO", (Object)chatUserDTO);
        return mapping.findForward("notebook");
    }

    public ActionForward editMessage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        MonitoringForm monitoringForm = (MonitoringForm)form;
        ChatMessage chatMessage = this.chatService.getMessageByUID(monitoringForm.getMessageUID());
        boolean hasChanged = false;
        if (chatMessage.isHidden() != monitoringForm.isMessageHidden()) {
            hasChanged = true;
            this.chatService.auditHideShowMessage(chatMessage, monitoringForm.isMessageHidden());
        }
        if (!chatMessage.getBody().equals(monitoringForm.getMessageBody())) {
            hasChanged = true;
            this.chatService.auditEditMessage(chatMessage, monitoringForm.getMessageBody());
        }
        if (hasChanged) {
            chatMessage.setBody(monitoringForm.getMessageBody());
            chatMessage.setHidden(monitoringForm.isMessageHidden());
            this.chatService.saveOrUpdateChatMessage(chatMessage);
        }
        return this.openChatHistory(mapping, form, request, response);
    }

    private ChatUser getCurrentUser(Long toolSessionId) {
        UserDTO user = (UserDTO)SessionManager.getSession().getAttribute("user");
        ChatUser chatUser = this.chatService.getUserByUserIdAndSessionId(new Long(user.getUserID().intValue()), toolSessionId);
        if (chatUser == null) {
            ChatSession chatSession = this.chatService.getSessionBySessionId(toolSessionId);
            chatUser = this.chatService.createChatUser(user, chatSession);
        }
        return chatUser;
    }
}

