/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.dao.hibernate;

import java.util.List;
import org.lamsfoundation.lams.dao.hibernate.BaseDAO;
import org.lamsfoundation.lams.learningdesign.DataFlowObject;
import org.lamsfoundation.lams.learningdesign.DataTransition;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.dao.IDataFlowDAO;

public class DataFlowDAO
extends BaseDAO
implements IDataFlowDAO {
    private static final String FIND_DATA_FLOW_OBJECTS_BY_TOOL_CONTENT_ID = "SELECT obj FROM " + DataFlowObject.class.getName() + " AS obj, " + DataTransition.class.getName() + " AS transition, " + ToolActivity.class.getName() + " AS activity WHERE activity.toolContentId=? AND activity=transition.toActivity AND transition=obj.dataTransition ORDER BY transition.transitionUIID ASC, obj.orderId ASC";
    private static final String FIND_ASSIGNED_DATA_FLOW_OBJECTS = "SELECT obj FROM " + DataFlowObject.class.getName() + " AS obj, " + DataTransition.class.getName() + " AS transition, " + ToolActivity.class.getName() + " AS activity WHERE activity.toolContentId=:toolContentId AND activity=transition.toActivity AND transition=obj.dataTransition AND obj.toolAssigmentId=:toolAssigmentId";

    @Override
    public List<DataFlowObject> getDataFlowObjectsByToolContentId(Long toolContentId) {
        List result = this.getHibernateTemplate().find(FIND_DATA_FLOW_OBJECTS_BY_TOOL_CONTENT_ID, (Object)toolContentId);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result;
    }

    @Override
    public DataFlowObject getAssignedDataFlowObject(Long toolContentId, Integer assigmentId) {
        List result = this.getHibernateTemplate().findByNamedParam(FIND_ASSIGNED_DATA_FLOW_OBJECTS, new String[]{"toolContentId", "toolAssigmentId"}, new Object[]{toolContentId, assigmentId});
        if (result == null || result.isEmpty() || result.size() > 1) {
            return null;
        }
        return (DataFlowObject)result.get(0);
    }
}

