/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.presence.service;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.presence.dao.IPresenceChatDAO;
import org.lamsfoundation.lams.presence.model.PresenceChatMessage;
import org.lamsfoundation.lams.presence.model.PresenceChatUser;
import org.lamsfoundation.lams.presence.service.IPresenceChatService;

public class PresenceChatService
implements IPresenceChatService {
    private static Logger log = Logger.getLogger(PresenceChatService.class);
    private IPresenceChatDAO presenceChatDAO;

    @Override
    public PresenceChatMessage createPresenceChatMessage(Long lessonId, String from, String to, Date dateSent, String message) {
        PresenceChatMessage presenceChatMessage = new PresenceChatMessage(lessonId, from, to, dateSent, message);
        this.saveOrUpdatePresenceChatMessage(presenceChatMessage);
        return presenceChatMessage;
    }

    @Override
    public void updateUserPresence(Long lessonId, Map<String, Date> presence) {
        for (String nickname : presence.keySet()) {
            PresenceChatUser rosterEntry = new PresenceChatUser(nickname, lessonId, presence.get(nickname));
            this.presenceChatDAO.saveOrUpdate(rosterEntry);
        }
    }

    @Override
    public List<PresenceChatUser> getUsersActiveByLessonId(Long lessonId) {
        Date oldestLastPresence = new Date(System.currentTimeMillis() - 15000L);
        return this.presenceChatDAO.getUsersByLessonIdAndLastPresence(lessonId, oldestLastPresence);
    }

    @Override
    public PresenceChatMessage getMessageById(Long id) {
        return this.presenceChatDAO.getMessageById(id);
    }

    @Override
    public List<PresenceChatMessage> getMessagesByLessonId(Long lessonId) {
        return this.presenceChatDAO.getMessagesByLessonId(lessonId);
    }

    @Override
    public List<PresenceChatMessage> getMessagesByConversation(Long lessonId, String from, String to) {
        return this.presenceChatDAO.getMessagesByConversation(lessonId, from, to);
    }

    @Override
    public List<PresenceChatMessage> getNewMessages(Long lessonId, String from, String to, Long lastMessageUid, Date lastCheck) {
        return this.presenceChatDAO.getNewMessages(lessonId, from, to, lastMessageUid, lastCheck);
    }

    @Override
    public void saveOrUpdatePresenceChatMessage(PresenceChatMessage presenceChatMessage) {
        this.presenceChatDAO.saveOrUpdate(presenceChatMessage);
    }

    public IPresenceChatDAO getPresenceChatMessageDAO() {
        return this.presenceChatDAO;
    }

    public void setPresenceChatDAO(IPresenceChatDAO presenceChatDAO) {
        this.presenceChatDAO = presenceChatDAO;
    }
}

