/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.rating.dao.hibernate;

import java.util.List;
import org.lamsfoundation.lams.dao.hibernate.BaseDAO;
import org.lamsfoundation.lams.rating.dao.IRatingCriteriaDAO;
import org.lamsfoundation.lams.rating.model.Rating;
import org.lamsfoundation.lams.rating.model.RatingCriteria;

public class RatingCriteriaDAO
extends BaseDAO
implements IRatingCriteriaDAO {
    private static final String FIND_BY_TOOL_CONTENT_ID = "from " + RatingCriteria.class.getName() + " as r where r.toolContentId=? order by r.orderId asc";
    private static final String FIND_ENTRY_BY_EXTERNAL_ID_SIG_ALL = "from " + Rating.class.getName() + " where external_id=? and external_id_type=? and external_signature=?" + " order by user_id asc, create_date desc";
    private static final String FIND_ENTRY_BY_EXTERNAL_ID = "from " + Rating.class.getName() + " where external_id=? and external_id_type=? and user_id=?" + " order by create_date desc";
    private static final String FIND_ENTRY_BY_USER_ID = "from " + Rating.class.getName() + " where user_id=?";
    private static final String FIND_ENTRY_BY_EXTERNAL_ID_TYPE = "from " + Rating.class.getName() + " where user_id=? and external_id_type=?" + " order by external_signature desc, create_date desc";

    @Override
    public void saveOrUpdate(RatingCriteria criteria) {
        this.getHibernateTemplate().saveOrUpdate((Object)criteria);
        this.getHibernateTemplate().flush();
    }

    @Override
    public void deleteRatingCriteria(Long ratingCriteriaId) {
        this.deleteById(RatingCriteria.class, ratingCriteriaId);
    }

    @Override
    public List<RatingCriteria> getByToolContentId(Long toolContentId) {
        return this.getHibernateTemplate().find(FIND_BY_TOOL_CONTENT_ID, new Object[]{toolContentId});
    }
}

