/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.rating.dao.hibernate;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import org.lamsfoundation.lams.dao.hibernate.BaseDAO;
import org.lamsfoundation.lams.rating.dao.IRatingDAO;
import org.lamsfoundation.lams.rating.dto.RatingDTO;
import org.lamsfoundation.lams.rating.model.Rating;

public class RatingDAO
extends BaseDAO
implements IRatingDAO {
    private static final String FIND_RATING_BY_CRITERIA_AND_USER_AND_ITEM = "FROM " + Rating.class.getName() + " AS r where r.ratingCriteria.ratingCriteriaId=? AND r.learner.userId=? AND r.itemId=?";
    private static final String FIND_RATING_VALUE = "SELECT r.rating FROM " + Rating.class.getName() + " AS r where r.ratingCriteria.ratingCriteriaId=? AND r.learner.userId=? AND r.itemId=?";
    private static final String FIND_RATING_BY_CRITERIA_AND_USER = "FROM " + Rating.class.getName() + " AS r where r.ratingCriteria.ratingCriteriaId=? AND r.learner.userId=?";
    private static final String FIND_RATING_AVERAGE_BY_ITEM = "SELECT AVG(r.rating), COUNT(*) FROM " + Rating.class.getName() + " AS r where r.ratingCriteria.ratingCriteriaId=? AND r.itemId=?";
    private static final String FIND_RATING_AVERAGE_FOR_USER = "SELECT AVG(r.rating), COUNT(*) FROM " + Rating.class.getName() + " AS r where r.ratingCriteria.ratingCriteriaId=? AND r.itemId=?";

    @Override
    public void saveOrUpdate(Rating rating) {
        this.getHibernateTemplate().saveOrUpdate((Object)rating);
        this.getHibernateTemplate().flush();
    }

    @Override
    public Rating getRating(Long ratingCriteriaId, Integer userId, Long itemId) {
        List list = this.getHibernateTemplate().find(FIND_RATING_BY_CRITERIA_AND_USER_AND_ITEM, new Object[]{ratingCriteriaId, userId, itemId});
        if (list.size() > 0) {
            return (Rating)list.get(0);
        }
        return null;
    }

    @Override
    public Rating getRating(Long ratingCriteriaId, Integer userId) {
        List list = this.getHibernateTemplate().find(FIND_RATING_BY_CRITERIA_AND_USER, new Object[]{ratingCriteriaId, userId});
        if (list.size() > 0) {
            return (Rating)list.get(0);
        }
        return null;
    }

    @Override
    public RatingDTO getRatingAverageDTOByItem(Long ratingCriteriaId, Long itemId) {
        List list = this.getHibernateTemplate().find(FIND_RATING_AVERAGE_BY_ITEM, new Object[]{ratingCriteriaId, itemId});
        Object[] results = (Object[])list.get(0);
        Object averageRatingObj = results[0] == null ? Integer.valueOf(0) : results[0];
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        numberFormat.setMaximumFractionDigits(1);
        String averageRating = numberFormat.format(averageRatingObj);
        String numberOfVotes = results[1] == null ? "0" : String.valueOf(results[1]);
        return new RatingDTO(averageRating, numberOfVotes);
    }

    @Override
    public RatingDTO getRatingAverageDTOByUser(Long ratingCriteriaId, Long itemId, Integer userId) {
        RatingDTO ratingDTO = this.getRatingAverageDTOByItem(ratingCriteriaId, itemId);
        Float userRating = Float.valueOf(0.0f);
        List list = this.getHibernateTemplate().find(FIND_RATING_VALUE, new Object[]{ratingCriteriaId, userId, itemId});
        if (list.size() > 0) {
            userRating = (Float)list.get(0);
        }
        ratingDTO.setUserRating(userRating.toString());
        ratingDTO.setItemId(itemId);
        return ratingDTO;
    }

    @Override
    public Rating get(Long uid) {
        if (uid != null) {
            Object o = this.getHibernateTemplate().get(Rating.class, (Serializable)uid);
            return (Rating)o;
        }
        return null;
    }
}

