/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.rating.model;

import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.rating.model.AuthoredItemRatingCriteria;
import org.lamsfoundation.lams.rating.model.LearnerItemRatingCriteria;
import org.lamsfoundation.lams.rating.model.LessonRatingCriteria;
import org.lamsfoundation.lams.rating.model.ToolActivityRatingCriteria;
import org.lamsfoundation.lams.util.Nullable;

public abstract class RatingCriteria
implements Serializable,
Nullable,
Comparable,
Cloneable {
    private static final Logger log = Logger.getLogger(RatingCriteria.class);
    private static final long serialVersionUID = -2282899640789455260L;
    public static final int TOOL_ACTIVITY_CRITERIA_TYPE = 1;
    public static final int AUTHORED_ITEM_CRITERIA_TYPE = 2;
    public static final int LEARNER_ITEM_CRITERIA_TYPE = 3;
    public static final int LESSON_CRITERIA_TYPE = 4;
    public static final String I18N_TITLE = "rating.criteria.title";
    public static final String I18N_DESCRIPTION = "rating.criteria.description";
    public static final String I18N_HELP_TEXT = "rating.criteria.helptext";
    private Long ratingCriteriaId;
    private String title;
    private Integer orderId;
    private Integer ratingCriteriaTypeId;

    public RatingCriteria(Long ratingCriteriaId, String title, Integer orderId, Date createDateTime, Integer ratingCriteriaTypeId) {
        this.ratingCriteriaId = ratingCriteriaId;
        this.title = title;
        this.orderId = orderId;
        this.ratingCriteriaTypeId = ratingCriteriaTypeId;
    }

    public RatingCriteria() {
    }

    public RatingCriteria(Long ratingCriteriaId, Date createDateTime, RatingCriteria parentRatingCriteria, Integer ratingCriteriaTypeId) {
        this.ratingCriteriaId = ratingCriteriaId;
        this.ratingCriteriaTypeId = ratingCriteriaTypeId;
    }

    public static RatingCriteria getRatingCriteriaInstance(int ratingCriteriaType) {
        RatingCriteria ratingCriteria = null;
        switch (ratingCriteriaType) {
            case 1: {
                ratingCriteria = new ToolActivityRatingCriteria();
                break;
            }
            case 2: {
                ratingCriteria = new AuthoredItemRatingCriteria();
                break;
            }
            case 3: {
                ratingCriteria = new LearnerItemRatingCriteria();
                break;
            }
            default: {
                ratingCriteria = new LessonRatingCriteria();
            }
        }
        ratingCriteria.setRatingCriteriaTypeId(new Integer(ratingCriteriaType));
        return ratingCriteria;
    }

    public Long getRatingCriteriaId() {
        return this.ratingCriteriaId;
    }

    public void setRatingCriteriaId(Long ratingCriteriaId) {
        this.ratingCriteriaId = ratingCriteriaId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getOrderId() {
        return this.orderId;
    }

    public void setOrderId(Integer orderId) {
        this.orderId = orderId;
    }

    public Integer getRatingCriteriaTypeId() {
        return this.ratingCriteriaTypeId;
    }

    public void setRatingCriteriaTypeId(Integer ratingCriteriaTypeId) {
        this.ratingCriteriaTypeId = ratingCriteriaTypeId;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("ratingCriteriaId", (Object)this.ratingCriteriaId).toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RatingCriteria)) {
            return false;
        }
        RatingCriteria castOther = (RatingCriteria)other;
        return new EqualsBuilder().append((Object)this.getOrderId(), (Object)castOther.getOrderId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getOrderId()).toHashCode();
    }

    public boolean isToolActivityRatingCriteria() {
        return this.getRatingCriteriaTypeId() == 1;
    }

    public boolean isAuthoredItemRatingCriteria() {
        return this.getRatingCriteriaTypeId() == 2;
    }

    public boolean isLearnerItemRatingCriteria() {
        return this.getRatingCriteriaTypeId() == 3;
    }

    public boolean isLessonRatingCriteria() {
        return this.getRatingCriteriaTypeId() == 4;
    }

    public Object clone() {
        RatingCriteria criteria = null;
        try {
            criteria = (RatingCriteria)super.clone();
            criteria.setRatingCriteriaId(null);
        }
        catch (CloneNotSupportedException e) {
            log.error((Object)("When clone " + RatingCriteria.class + " failed"));
        }
        return criteria;
    }

    public int compareTo(Object o) {
        if (o != null && o instanceof RatingCriteria) {
            RatingCriteria anotherCriteria = (RatingCriteria)o;
            return this.orderId - anotherCriteria.getOrderId();
        }
        return 1;
    }
}

