/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.rating.service;

import java.util.List;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.rating.dao.IRatingCriteriaDAO;
import org.lamsfoundation.lams.rating.dao.IRatingDAO;
import org.lamsfoundation.lams.rating.dto.RatingDTO;
import org.lamsfoundation.lams.rating.model.Rating;
import org.lamsfoundation.lams.rating.model.RatingCriteria;
import org.lamsfoundation.lams.rating.service.IRatingService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.MessageService;

public class RatingService
implements IRatingService {
    private static Logger log = Logger.getLogger(RatingService.class);
    private IRatingDAO ratingDAO;
    private IRatingCriteriaDAO ratingCriteriaDAO;
    protected IUserManagementService userManagementService;
    protected MessageService messageService;

    @Override
    public Rating getRatingByItemAndUser(Long itemId, Integer userId) {
        return null;
    }

    @Override
    public List<Rating> getRatingsByItem(Long itemId) {
        return null;
    }

    @Override
    public void saveOrUpdateRating(Rating rating) {
        this.ratingDAO.saveOrUpdate(rating);
    }

    @Override
    public RatingDTO rateItem(Long ratingCriteriaId, Integer userId, Long itemId, float ratingFloat) {
        User learner = (User)this.userManagementService.findById(User.class, userId);
        Rating rating = this.ratingDAO.getRating(ratingCriteriaId, userId, itemId);
        if (rating == null) {
            rating = new Rating();
            rating.setLearner(learner);
            rating.setItemId(itemId);
        }
        rating.setRating(ratingFloat);
        this.ratingDAO.saveOrUpdate(rating);
        return this.ratingDAO.getRatingAverageDTOByItem(ratingCriteriaId, itemId);
    }

    @Override
    public RatingDTO getRatingDTOByUser(Long ratingCriteriaId, Long itemId, Integer userId) {
        return this.ratingDAO.getRatingAverageDTOByUser(ratingCriteriaId, itemId, userId);
    }

    @Override
    public List<RatingCriteria> getCriteriasByToolContentId(Long toolContentId) {
        List<RatingCriteria> criterias = this.ratingCriteriaDAO.getByToolContentId(toolContentId);
        return criterias;
    }

    @Override
    public void saveOrUpdateRatingCriteria(RatingCriteria criteria) {
        this.ratingCriteriaDAO.saveOrUpdate(criteria);
    }

    @Override
    public void deleteRatingCriteria(Long ratingCriteriaId) {
        this.ratingCriteriaDAO.deleteRatingCriteria(ratingCriteriaId);
    }

    public void setRatingDAO(IRatingDAO ratingDAO) {
        this.ratingDAO = ratingDAO;
    }

    public void setRatingCriteriaDAO(IRatingCriteriaDAO ratingCriteriaDAO) {
        this.ratingCriteriaDAO = ratingCriteriaDAO;
    }

    public void setUserManagementService(IUserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }
}

