/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.usermanagement.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.dao.IBaseDAO;
import org.lamsfoundation.lams.learningdesign.dao.IGroupDAO;
import org.lamsfoundation.lams.themes.Theme;
import org.lamsfoundation.lams.usermanagement.ForgotPasswordRequest;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationGroup;
import org.lamsfoundation.lams.usermanagement.OrganisationGrouping;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.UserOrganisation;
import org.lamsfoundation.lams.usermanagement.UserOrganisationRole;
import org.lamsfoundation.lams.usermanagement.Workspace;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.usermanagement.WorkspaceWorkspaceFolder;
import org.lamsfoundation.lams.usermanagement.dao.IOrganisationDAO;
import org.lamsfoundation.lams.usermanagement.dao.IRoleDAO;
import org.lamsfoundation.lams.usermanagement.dao.IUserOrganisationDAO;
import org.lamsfoundation.lams.usermanagement.dto.CollapsedOrgDTO;
import org.lamsfoundation.lams.usermanagement.dto.OrganisationDTO;
import org.lamsfoundation.lams.usermanagement.dto.OrganisationDTOFactory;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.dto.UserManageBean;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.usermanagement.util.CollapsedOrgDTOComparator;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.HashUtil;
import org.lamsfoundation.lams.util.LanguageUtil;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.audit.IAuditService;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.lamsfoundation.lams.web.util.HttpSessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class UserManagementService
implements IUserManagementService {
    private Logger log = Logger.getLogger(UserManagementService.class);
    private static final String SEQUENCES_FOLDER_NAME_KEY = "runsequences.folder.name";
    private IBaseDAO baseDAO;
    private IGroupDAO groupDAO;
    private IRoleDAO roleDAO;
    private IOrganisationDAO organisationDAO;
    private IUserOrganisationDAO userOrganisationDAO;
    protected MessageService messageService;
    private static IAuditService auditService;

    private IAuditService getAuditService() {
        if (auditService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)HttpSessionManager.getInstance().getServletContext());
            auditService = (IAuditService)ctx.getBean("auditService");
        }
        return auditService;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public MessageService getMessageService() {
        return this.messageService;
    }

    public void setBaseDAO(IBaseDAO baseDAO) {
        this.baseDAO = baseDAO;
    }

    public void setGroupDAO(IGroupDAO groupDAO) {
        this.groupDAO = groupDAO;
    }

    public void setRoleDAO(IRoleDAO roleDAO) {
        this.roleDAO = roleDAO;
    }

    public void setOrganisationDAO(IOrganisationDAO organisationDAO) {
        this.organisationDAO = organisationDAO;
    }

    public void setUserOrganisationDAO(IUserOrganisationDAO userOrganisationDAO) {
        this.userOrganisationDAO = userOrganisationDAO;
    }

    @Override
    public void save(Object object) {
        try {
            if (object instanceof User) {
                User user = (User)object;
                object = this.saveUser(user);
            }
            this.baseDAO.insertOrUpdate(object);
        }
        catch (Exception e) {
            this.log.debug((Object)e);
        }
    }

    protected User saveUser(User user) {
        if (user != null) {
            Workspace workspace;
            if (user.getUserId() == null) {
                this.baseDAO.insertOrUpdate(user);
                user = this.createWorkspaceForUser(user);
            }
            if ((workspace = user.getWorkspace()) != null && !StringUtils.equals((String)user.getFullName(), (String)workspace.getName())) {
                workspace.setName(user.getFullName());
                this.save(workspace);
                WorkspaceFolder folder = workspace.getDefaultFolder();
                if (folder != null) {
                    folder.setName(workspace.getName());
                    this.save(folder);
                }
            }
            user.setModifiedDate(new Date());
        }
        return user;
    }

    @Override
    public void saveOrganisationGrouping(OrganisationGrouping grouping, Collection<OrganisationGroup> newGroups) {
        if (grouping.getGroupingId() == null) {
            grouping.setGroups(new HashSet<OrganisationGroup>());
            this.baseDAO.insert(grouping);
        }
        if (newGroups != null) {
            HashSet<OrganisationGroup> obsoleteGroups = new HashSet<OrganisationGroup>(grouping.getGroups());
            for (OrganisationGroup newGroup : newGroups) {
                OrganisationGroup existingGroup = null;
                for (OrganisationGroup existingGroupCandidate : grouping.getGroups()) {
                    if (!existingGroupCandidate.equals(newGroup)) continue;
                    existingGroup = existingGroupCandidate;
                    break;
                }
                if (existingGroup == null) {
                    newGroup.setGroupingId(grouping.getGroupingId());
                    grouping.getGroups().add(newGroup);
                    this.baseDAO.insert(newGroup);
                    continue;
                }
                obsoleteGroups.remove(existingGroup);
                existingGroup.setName(newGroup.getName());
                existingGroup.setUsers(newGroup.getUsers());
                this.baseDAO.update(existingGroup);
            }
            for (OrganisationGroup obsoleteGroup : obsoleteGroups) {
                grouping.getGroups().remove(obsoleteGroup);
                this.baseDAO.delete(obsoleteGroup);
            }
        }
    }

    @Override
    public void saveAll(Collection objects) {
        for (Object o : objects) {
            if (!(o instanceof User)) continue;
            this.baseDAO.insertOrUpdate(o);
            User user = this.createWorkspaceForUser((User)o);
        }
        this.baseDAO.insertOrUpdateAll(objects);
    }

    @Override
    public void delete(Object object) {
        this.baseDAO.delete(object);
    }

    @Override
    public void deleteAll(Class clazz) {
        this.baseDAO.deleteAll(clazz);
    }

    @Override
    public void deleteAll(Collection objects) {
        this.baseDAO.deleteAll(objects);
    }

    @Override
    public void deleteById(Class clazz, Serializable id) {
        this.baseDAO.deleteById(clazz, id);
    }

    @Override
    public void deleteByProperty(Class clazz, String name, Object value) {
        this.baseDAO.deleteByProperty(clazz, name, value);
    }

    @Override
    public void deleteByProperties(Class clazz, Map<String, Object> properties) {
        this.baseDAO.deleteByProperties(clazz, properties);
    }

    @Override
    public void deleteAnythingLike(Object object) {
        this.baseDAO.deleteAnythingLike(object);
    }

    @Override
    public Object findById(Class clazz, Serializable id) {
        return this.baseDAO.find(clazz, id);
    }

    @Override
    public List findAll(Class clazz) {
        return this.baseDAO.findAll(clazz);
    }

    @Override
    public List findByProperty(Class clazz, String name, Object value) {
        return this.baseDAO.findByProperty(clazz, name, value);
    }

    @Override
    public List findByProperties(Class clazz, Map<String, Object> properties) {
        return this.baseDAO.findByProperties(clazz, properties);
    }

    @Override
    public List findAnythingLike(Object object) {
        return this.baseDAO.findAnythingLike(object);
    }

    @Override
    public List searchByStringProperties(Class clazz, Map<String, String> properties) {
        return this.baseDAO.searchByStringProperties(clazz, properties);
    }

    @Override
    public OrganisationDTO getOrganisationsForUserByRole(User user, List<String> restrictToRoleNames) {
        ArrayList<OrganisationDTO> list = new ArrayList<OrganisationDTO>();
        for (UserOrganisation userOrganisation : user.getUserOrganisations()) {
            OrganisationDTO dto;
            boolean aRoleFound = this.addRolesToDTO(restrictToRoleNames, userOrganisation, dto = userOrganisation.getOrganisation().getOrganisationDTO());
            if (!aRoleFound) continue;
            list.add(dto);
        }
        return OrganisationDTOFactory.createTree(list);
    }

    @Override
    public OrganisationDTO getOrganisationsForUserByRole(User user, List<String> restrictToRoleNames, Integer courseId, List<Integer> restrictToClassIds) {
        ArrayList<OrganisationDTO> dtolist = new ArrayList<OrganisationDTO>();
        Organisation org = (Organisation)this.baseDAO.find(Organisation.class, courseId);
        dtolist.add(org.getOrganisationDTO());
        this.getChildOrganisations(user, org, restrictToRoleNames, restrictToClassIds, dtolist);
        OrganisationDTO dtoTree = OrganisationDTOFactory.createTree(dtolist);
        Vector<OrganisationDTO> nodes = dtoTree.getNodes();
        return nodes.get(0);
    }

    private void getChildOrganisations(User user, Organisation org, List<String> restrictToRoleNames, List<Integer> restrictToClassIds, List<OrganisationDTO> dtolist) {
        if (org != null) {
            boolean notCheckClassId = restrictToClassIds == null || restrictToClassIds.size() == 0;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("user.userId", user.getUserId());
            map.put("organisation.parentOrganisation.organisationId", org.getOrganisationId());
            List childOrgs = this.baseDAO.findByProperties(UserOrganisation.class, map);
            for (UserOrganisation userOrganisation : childOrgs) {
                OrganisationDTO dto = userOrganisation.getOrganisation().getOrganisationDTO();
                if (!notCheckClassId && !restrictToClassIds.contains(dto.getOrganisationID())) continue;
                boolean aRoleFound = this.addRolesToDTO(restrictToRoleNames, userOrganisation, dto);
                if (aRoleFound) {
                    dtolist.add(dto);
                }
                Organisation childOrganisation = userOrganisation.getOrganisation();
                if (org.getChildOrganisations().size() <= 0) continue;
                this.getChildOrganisations(user, childOrganisation, restrictToRoleNames, restrictToClassIds, dtolist);
            }
        }
    }

    private boolean addRolesToDTO(List<String> restrictToRoleNames, UserOrganisation userOrganisation, OrganisationDTO dto) {
        Iterator iter = userOrganisation.getUserOrganisationRoles().iterator();
        boolean roleFound = false;
        while (iter.hasNext()) {
            UserOrganisationRole userOrganisationRole = (UserOrganisationRole)iter.next();
            String roleName = userOrganisationRole.getRole().getName();
            if (restrictToRoleNames != null && restrictToRoleNames.size() != 0 && !restrictToRoleNames.contains(roleName)) continue;
            dto.addRoleName(roleName);
            roleFound = true;
        }
        return roleFound;
    }

    @Override
    public OrganisationDTO getOrganisationForUserWithRole(User user, Integer organisationId) {
        if (user != null && organisationId != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("user.userId", user.getUserId());
            map.put("organisation.organisationId", organisationId);
            UserOrganisation userOrganisation = (UserOrganisation)this.baseDAO.findByProperties(UserOrganisation.class, map).get(0);
            OrganisationDTO dto = userOrganisation.getOrganisation().getOrganisationDTO();
            this.addRolesToDTO(null, userOrganisation, dto);
            return dto;
        }
        return null;
    }

    @Override
    public List<Role> getRolesForUserByOrganisation(User user, Integer orgId) {
        ArrayList<Role> list = new ArrayList<Role>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("user.userId", user.getUserId());
        map.put("organisation.organisationId", orgId);
        UserOrganisation userOrg = (UserOrganisation)this.baseDAO.findByProperties(UserOrganisation.class, map).get(0);
        if (userOrg == null) {
            return null;
        }
        for (UserOrganisationRole userOrgRole : userOrg.getUserOrganisationRoles()) {
            list.add(userOrgRole.getRole());
        }
        return list;
    }

    @Override
    public List<User> getUsersFromOrganisation(Integer orgId) {
        String query = "select uo.user from UserOrganisation uo where uo.organisation.organisationId=" + orgId + " order by uo.user.login";
        return this.baseDAO.find(query);
    }

    @Override
    public Vector getUsersFromOrganisationByRole(Integer organisationID, String roleName, boolean isFlashCall, boolean getUser) {
        Vector<Object> users = null;
        users = isFlashCall ? new Vector<Object>() : (getUser ? new Vector() : new Vector());
        String query = "SELECT uo.user FROM UserOrganisation uo INNER JOIN uo.userOrganisationRoles r WHERE uo.organisation.organisationId=" + organisationID + " AND r.role.name= '" + roleName + "'";
        List queryResult = this.baseDAO.find(query);
        for (User user : queryResult) {
            if (isFlashCall && !getUser) {
                users.add(user.getUserFlashDTO());
                continue;
            }
            if (getUser) {
                users.add(user);
                continue;
            }
            users.add(user.getUserDTO());
        }
        return users;
    }

    @Override
    public Organisation getRootOrganisation() {
        return (Organisation)this.baseDAO.findByProperty(Organisation.class, "organisationType.organisationTypeId", OrganisationType.ROOT_TYPE).get(0);
    }

    @Override
    public boolean isUserInRole(Integer userId, Integer orgId, String roleName) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("userOrganisation.user.userId", userId);
        properties.put("userOrganisation.organisation.organisationId", orgId);
        properties.put("role.name", roleName);
        return this.baseDAO.findByProperties(UserOrganisationRole.class, properties).size() != 0;
    }

    @Override
    public List getOrganisationsByTypeAndStatus(Integer typeId, Integer stateId) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("organisationType.organisationTypeId", typeId);
        properties.put("organisationState.organisationStateId", stateId);
        return this.baseDAO.findByProperties(Organisation.class, properties);
    }

    @Override
    public List getUserOrganisationRoles(Integer orgId, String login) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("userOrganisation.organisation.organisationId", orgId);
        properties.put("userOrganisation.user.login", login);
        return this.baseDAO.findByProperties(UserOrganisationRole.class, properties);
    }

    @Override
    public List getUserOrganisationsForUserByTypeAndStatus(String login, Integer typeId, Integer stateId) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("user.login", login);
        properties.put("organisation.organisationType.organisationTypeId", typeId);
        properties.put("organisation.organisationState.organisationStateId", stateId);
        return this.baseDAO.findByProperties(UserOrganisation.class, properties);
    }

    @Override
    public List getUserOrganisationsForUserByTypeAndStatusAndParent(String login, Integer typeId, Integer stateId, Integer parentOrgId) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("user.login", login);
        properties.put("organisation.organisationType.organisationTypeId", typeId);
        properties.put("organisation.organisationState.organisationStateId", stateId);
        properties.put("organisation.parentOrganisation.organisationId", parentOrgId);
        return this.baseDAO.findByProperties(UserOrganisation.class, properties);
    }

    @Override
    public User getUserByLogin(String login) {
        List results = this.baseDAO.findByProperty(User.class, "login", login);
        return results.isEmpty() ? null : (User)results.get(0);
    }

    @Override
    public void updatePassword(String login, String password) {
        try {
            User user = this.getUserByLogin(login);
            user.setPassword(HashUtil.sha1(password));
            this.baseDAO.update(user);
        }
        catch (Exception e) {
            this.log.debug((Object)e);
        }
    }

    @Override
    public UserOrganisation getUserOrganisation(Integer userId, Integer orgId) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("user.userId", userId);
        properties.put("organisation.organisationId", orgId);
        List results = this.baseDAO.findByProperties(UserOrganisation.class, properties);
        return results.isEmpty() ? null : (UserOrganisation)results.get(0);
    }

    private User createWorkspaceForUser(User user) {
        Workspace workspace = new Workspace(user.getFullName());
        this.save(workspace);
        WorkspaceFolder folder = new WorkspaceFolder(workspace.getName(), user.getUserId(), new Date(), new Date(), WorkspaceFolder.NORMAL);
        this.save(folder);
        workspace.addFolder(folder);
        workspace.setDefaultFolder(folder);
        user.setWorkspace(workspace);
        return user;
    }

    public Workspace createWorkspaceForOrganisation(String workspaceName, Integer userID, Date createDateTime) {
        WorkspaceFolder workspaceFolder = new WorkspaceFolder(workspaceName, userID, createDateTime, createDateTime, WorkspaceFolder.NORMAL);
        this.save(workspaceFolder);
        String description = this.getRunSequencesFolderName(workspaceName);
        WorkspaceFolder workspaceFolder2 = new WorkspaceFolder(description, userID, createDateTime, createDateTime, WorkspaceFolder.RUN_SEQUENCES);
        workspaceFolder2.setParentWorkspaceFolder(workspaceFolder);
        this.save(workspaceFolder2);
        workspaceFolder.addChild(workspaceFolder2);
        this.save(workspaceFolder);
        Workspace workspace = new Workspace(workspaceName);
        workspace.setDefaultFolder(workspaceFolder);
        workspace.setDefaultRunSequencesFolder(workspaceFolder2);
        workspace.addFolder(workspaceFolder);
        workspace.addFolder(workspaceFolder2);
        this.save(workspace);
        return workspace;
    }

    @Override
    public Organisation saveOrganisation(Organisation organisation, Integer userID) {
        User creator = (User)this.findById(User.class, userID);
        if (organisation.getOrganisationId() == null) {
            Date createDateTime = new Date();
            organisation.setCreateDate(createDateTime);
            organisation.setCreatedBy(creator);
            if (organisation.getOrganisationType().getOrganisationTypeId().equals(OrganisationType.COURSE_TYPE)) {
                Workspace workspace = this.createWorkspaceForOrganisation(organisation.getName(), userID, createDateTime);
                organisation.setWorkspace(workspace);
            }
            this.save(organisation);
            if (organisation.getOrganisationType().getOrganisationTypeId().equals(OrganisationType.CLASS_TYPE)) {
                Organisation pOrg = organisation.getParentOrganisation();
                HashSet<Organisation> children = pOrg.getChildOrganisations();
                if (children == null) {
                    children = new HashSet<Organisation>();
                }
                children.add(organisation);
                pOrg.setChildOrganisations(children);
                Vector managers = this.getUsersFromOrganisationByRole(pOrg.getOrganisationId(), "GROUP MANAGER", false, false);
                for (UserDTO m : managers) {
                    User user = (User)this.findById(User.class, m.getUserID());
                    UserOrganisation uo = new UserOrganisation(user, organisation);
                    this.log.debug((Object)("adding course manager: " + user.getUserId() + " as staff"));
                    UserOrganisationRole uor = new UserOrganisationRole(uo, (Role)this.findById(Role.class, Role.ROLE_MONITOR));
                    HashSet<UserOrganisationRole> uors = new HashSet<UserOrganisationRole>();
                    uors.add(uor);
                    uo.setUserOrganisationRoles(uors);
                    HashSet<UserOrganisation> uos = organisation.getUserOrganisations();
                    if (uos == null) {
                        uos = new HashSet<UserOrganisation>();
                    }
                    uos.add(uo);
                    organisation.setUserOrganisations(uos);
                    this.save(uo);
                }
            }
        } else {
            Workspace workspace = organisation.getWorkspace();
            if (workspace != null) {
                WorkspaceFolder runSeqFolder;
                workspace.setName(organisation.getName());
                WorkspaceFolder defaultFolder = workspace.getDefaultFolder();
                if (defaultFolder != null) {
                    defaultFolder.setName(organisation.getName());
                }
                if ((runSeqFolder = workspace.getDefaultRunSequencesFolder()) != null) {
                    runSeqFolder.setName(this.getRunSequencesFolderName(organisation.getName()));
                }
            }
        }
        return organisation;
    }

    @Override
    public void updateOrganisationandWorkspaceNames(Organisation organisation) {
        Workspace workspace;
        this.baseDAO.update(organisation);
        if (organisation.getOrganisationId() != null && (workspace = organisation.getWorkspace()) != null) {
            workspace.setName(organisation.getName());
            this.baseDAO.update(workspace);
            WorkspaceFolder defaultFolder = workspace.getDefaultFolder();
            if (defaultFolder != null) {
                defaultFolder.setName(organisation.getName());
            }
            this.baseDAO.update(defaultFolder);
            WorkspaceFolder runSeqFolder = workspace.getDefaultRunSequencesFolder();
            if (runSeqFolder != null) {
                runSeqFolder.setName(this.getRunSequencesFolderName(organisation.getName()));
            }
            this.baseDAO.update(runSeqFolder);
        }
    }

    private String getRunSequencesFolderName(String workspaceName) {
        String[] tokenisedLocale = LanguageUtil.getDefaultLangCountry();
        Locale serverLocale = new Locale(tokenisedLocale[0], tokenisedLocale[1]);
        String runSeqName = this.messageService.getMessageSource().getMessage(SEQUENCES_FOLDER_NAME_KEY, new Object[]{workspaceName}, serverLocale);
        if (runSeqName != null && runSeqName.startsWith("???")) {
            this.log.warn((Object)"Problem in the language file - can't find an entry for runsequences.folder.name. Creating folder as \"run sequences\" ");
            runSeqName = "run sequences";
        }
        return runSeqName;
    }

    @Override
    public List<UserManageBean> getUserManageBeans(Integer orgId) {
        String query = "select u.userId,u.login,u.title,u.firstName,u.lastName, r from User u left join u.userOrganisations as uo left join uo.userOrganisationRoles as uor left join uor.role as r where uo.organisation.organisationId=?";
        List list = this.baseDAO.find(query, (Object)orgId);
        HashMap<Integer, UserManageBean> beansMap = new HashMap<Integer, UserManageBean>();
        for (int i = 0; i < list.size(); ++i) {
            Object[] data = (Object[])list.get(i);
            if (beansMap.containsKey(data[0])) {
                ((UserManageBean)beansMap.get(data[0])).getRoles().add((Role)data[5]);
                continue;
            }
            UserManageBean bean = new UserManageBean();
            bean.setUserId((Integer)data[0]);
            bean.setLogin((String)data[1]);
            bean.setTitle((String)data[2]);
            bean.setFirstName((String)data[3]);
            bean.setLastName((String)data[4]);
            bean.getRoles().add((Role)data[5]);
            beansMap.put((Integer)data[0], bean);
        }
        ArrayList<UserManageBean> userManageBeans = new ArrayList<UserManageBean>();
        userManageBeans.addAll(beansMap.values());
        return userManageBeans;
    }

    @Override
    public void removeUser(Integer userId) throws Exception {
        User user = (User)this.findById(User.class, userId);
        if (user != null) {
            if (this.userHasData(user).booleanValue()) {
                throw new Exception("Cannot remove User ID " + userId + ". User has data.");
            }
            Workspace workspace = user.getWorkspace();
            Set wwfs = workspace != null ? workspace.getWorkspaceWorkspaceFolders() : null;
            HashSet<WorkspaceFolder> foldersToDelete = new HashSet<WorkspaceFolder>();
            if (wwfs != null) {
                for (WorkspaceWorkspaceFolder wwf : wwfs) {
                    foldersToDelete.add(wwf.getWorkspaceFolder());
                    this.log.debug((Object)("deleting wkspc_wkspc_folder: " + wwf.getId()));
                    this.delete(wwf);
                }
            }
            for (WorkspaceFolder wf : foldersToDelete) {
                this.log.debug((Object)("deleting wkspc_folder: " + wf.getName()));
                this.delete(wf);
            }
            if (workspace != null) {
                this.log.debug((Object)("deleting workspace: " + workspace.getName()));
                this.delete(workspace);
            }
            this.log.debug((Object)("deleting user " + user.getLogin()));
            this.delete(user);
        } else {
            this.log.error((Object)("Requested delete of a user who does not exist. User ID " + userId));
        }
    }

    @Override
    public Boolean userHasData(User user) {
        if (user.getLearnerProgresses() != null && !user.getLearnerProgresses().isEmpty()) {
            this.log.debug((Object)("user has data, learnerProgresses: " + user.getLearnerProgresses().size()));
            return true;
        }
        if (user.getUserToolSessions() != null && !user.getUserToolSessions().isEmpty()) {
            this.log.debug((Object)("user has data, userToolSessions: " + user.getUserToolSessions().size()));
            return true;
        }
        if (user.getLearningDesigns() != null && !user.getLearningDesigns().isEmpty()) {
            this.log.debug((Object)("user has data, learningDesigns: " + user.getLearningDesigns().size()));
            return true;
        }
        if (user.getLessons() != null && !user.getLessons().isEmpty()) {
            this.log.debug((Object)("user has data, lessons: " + user.getLessons().size()));
            return true;
        }
        int numLessonGroups = this.groupDAO.getCountGroupsForUser(user.getUserId());
        if (numLessonGroups > 0) {
            this.log.debug((Object)("user has data, userGroups: " + numLessonGroups));
            return true;
        }
        return false;
    }

    @Override
    public void disableUser(Integer userId) {
        User user = (User)this.findById(User.class, userId);
        user.setDisabledFlag(true);
        Set uos = user.getUserOrganisations();
        Iterator iter = uos.iterator();
        while (iter.hasNext()) {
            UserOrganisation uo = (UserOrganisation)iter.next();
            this.log.debug((Object)("removing membership of: " + uo.getOrganisation().getName()));
            this.delete(uo);
            iter.remove();
        }
        this.log.debug((Object)("disabling user " + user.getLogin()));
        this.save(user);
    }

    @Override
    public void setRolesForUserOrganisation(User user, Integer organisationId, List<String> rolesList) {
        Organisation org = (Organisation)this.findById(Organisation.class, organisationId);
        this.setRolesForUserOrganisation(user, org, rolesList);
    }

    private void setRolesForUserOrganisation(User user, Organisation org, List<String> rolesList) {
        UserOrganisation uo = this.getUserOrganisation(user.getUserId(), org.getOrganisationId());
        if (uo == null) {
            uo = new UserOrganisation(user, org);
            this.save(uo);
            this.log.debug((Object)("added " + user.getLogin() + " to " + org.getName()));
            HashSet<UserOrganisation> uos = org.getUserOrganisations();
            if (uos == null) {
                uos = new HashSet<UserOrganisation>();
            }
            uos.add(uo);
        }
        if (org.getOrganisationType().getOrganisationTypeId().equals(OrganisationType.CLASS_TYPE) && this.getUserOrganisation(user.getUserId(), org.getParentOrganisation().getOrganisationId()) == null) {
            this.setRolesForUserOrganisation(user, org.getParentOrganisation(), rolesList);
        }
        ArrayList<String> rolesCopy = new ArrayList<String>();
        rolesCopy.addAll(rolesList);
        this.log.debug((Object)("rolesList.size: " + rolesList.size()));
        HashSet<UserOrganisationRole> uors = uo.getUserOrganisationRoles();
        HashSet uorsCopy = new HashSet();
        if (uors != null) {
            uorsCopy.addAll(uors);
            for (String roleId : rolesList) {
                for (UserOrganisationRole uor : uors) {
                    if (!uor.getRole().getRoleId().toString().equals(roleId)) continue;
                    rolesCopy.remove(roleId);
                    uorsCopy.remove(uor);
                }
            }
            this.log.debug((Object)("removing roles: " + uorsCopy));
            uors.removeAll(uorsCopy);
        } else {
            uors = new HashSet<UserOrganisationRole>();
        }
        for (String roleId : rolesCopy) {
            UserOrganisationRole uor;
            Role role = (Role)this.findById(Role.class, Integer.valueOf(Integer.parseInt(roleId)));
            uor = new UserOrganisationRole(uo, role);
            this.save(uor);
            this.log.debug((Object)("setting role: " + role.getName() + " in organisation: " + org.getName()));
            uors.add(uor);
            if (!role.getName().equals("AUTHOR") && !role.getName().equals("SYSADMIN") || user.getWorkspace() != null) continue;
            this.createWorkspaceForUser(user);
        }
        uo.setUserOrganisationRoles(uors);
        this.save(user);
        this.checkGroupManager(user, org);
    }

    private void checkGroupManager(User user, Organisation org) {
        if (org.getOrganisationType().getOrganisationTypeId().equals(OrganisationType.COURSE_TYPE)) {
            if (this.hasRoleInOrganisation(user, Role.ROLE_GROUP_MANAGER, org)) {
                this.setRolesForGroupManager(user, org.getChildOrganisations());
            }
        } else if (org.getOrganisationType().getOrganisationTypeId().equals(OrganisationType.CLASS_TYPE) && this.hasRoleInOrganisation(user, Role.ROLE_GROUP_MANAGER, org.getParentOrganisation())) {
            this.setRolesForGroupManager(user, org.getParentOrganisation().getChildOrganisations());
        }
    }

    private void setRolesForGroupManager(User user, Set childOrgs) {
        for (Object o : childOrgs) {
            Organisation org = (Organisation)o;
            UserOrganisation uo = this.getUserOrganisation(user.getUserId(), org.getOrganisationId());
            if (uo == null) {
                uo = new UserOrganisation(user, org);
                this.save(uo);
                Set uos = org.getUserOrganisations();
                uos.add(uo);
                this.log.debug((Object)("added " + user.getLogin() + " to " + org.getName()));
                uo = this.setRoleForUserOrganisation(uo, (Role)this.findById(Role.class, Role.ROLE_MONITOR));
                uo = this.setRoleForUserOrganisation(uo, (Role)this.findById(Role.class, Role.ROLE_LEARNER));
                this.save(uo);
                return;
            }
            Set uors = uo.getUserOrganisationRoles();
            if (uors == null || uors.isEmpty()) continue;
            boolean isMonitor = false;
            boolean isLearner = false;
            for (UserOrganisationRole uor : uors) {
                if (uor.getRole().getName().equals("MONITOR")) {
                    isMonitor = true;
                } else if (uor.getRole().getName().equals("LEARNER")) {
                    isLearner = true;
                }
                if (!isMonitor || !isLearner) continue;
                break;
            }
            if (!isMonitor) {
                uo = this.setRoleForUserOrganisation(uo, (Role)this.findById(Role.class, Role.ROLE_MONITOR));
            }
            if (!isLearner) {
                uo = this.setRoleForUserOrganisation(uo, (Role)this.findById(Role.class, Role.ROLE_LEARNER));
            }
            this.save(uo);
        }
    }

    private UserOrganisation setRoleForUserOrganisation(UserOrganisation uo, Role role) {
        UserOrganisationRole uor = new UserOrganisationRole(uo, role);
        this.save(uor);
        uo.addUserOrganisationRole(uor);
        this.log.debug((Object)("setting role: " + uor.getRole().getName() + " in organisation: " + uor.getUserOrganisation().getOrganisation().getName()));
        return uo;
    }

    @Override
    public List<Role> filterRoles(List<Role> rolelist, Boolean isSysadmin, OrganisationType orgType) {
        ArrayList<Role> allRoles = new ArrayList<Role>();
        allRoles.addAll(rolelist);
        Role role = new Role();
        if (!orgType.getOrganisationTypeId().equals(OrganisationType.ROOT_TYPE) || !isSysadmin.booleanValue()) {
            role.setRoleId(Role.ROLE_SYSADMIN);
            allRoles.remove(role);
        } else {
            role.setRoleId(Role.ROLE_AUTHOR);
            allRoles.remove(role);
            role.setRoleId(Role.ROLE_LEARNER);
            allRoles.remove(role);
            role.setRoleId(Role.ROLE_MONITOR);
            allRoles.remove(role);
        }
        if (!orgType.getOrganisationTypeId().equals(OrganisationType.COURSE_TYPE)) {
            role.setRoleId(Role.ROLE_GROUP_MANAGER);
            allRoles.remove(role);
            if (!orgType.getOrganisationTypeId().equals(OrganisationType.ROOT_TYPE)) {
                role.setRoleId(Role.ROLE_GROUP_ADMIN);
                allRoles.remove(role);
            }
        }
        return allRoles;
    }

    @Override
    public boolean hasRoleInOrganisation(User user, Integer roleId) {
        return this.hasRoleInOrganisation(user, roleId, this.getRootOrganisation());
    }

    @Override
    public boolean hasRoleInOrganisation(User user, Integer roleId, Organisation organisation) {
        return this.roleDAO.getUserByOrganisationAndRole(user.getUserId(), roleId, organisation) != null;
    }

    @Override
    public void deleteChildUserOrganisations(User user, Organisation org) {
        if (!org.getOrganisationType().getOrganisationTypeId().equals(OrganisationType.COURSE_TYPE)) {
            return;
        }
        Set childOrgs = org.getChildOrganisations();
        for (Organisation childOrg : childOrgs) {
            Set childOrgUos = childOrg.getUserOrganisations();
            UserOrganisation uo = this.getUserOrganisation(user.getUserId(), childOrg.getOrganisationId());
            if (uo == null) continue;
            childOrgUos.remove(uo);
            childOrg.setUserOrganisations(childOrgUos);
            this.save(childOrg);
            Set userUos = user.getUserOrganisations();
            userUos.remove(uo);
            user.setUserOrganisations(userUos);
            this.log.debug((Object)("removed userId=" + user.getUserId() + " from orgId=" + childOrg.getOrganisationId()));
        }
    }

    @Override
    public void deleteUserOrganisation(User user, Organisation org) {
        UserOrganisation uo = this.getUserOrganisation(user.getUserId(), org.getOrganisationId());
        if (uo != null) {
            org.getUserOrganisations().remove(uo);
            this.save(org);
            user.getUserOrganisations().remove(uo);
            this.log.debug((Object)("Removed user " + user.getUserId() + " from organisation " + org.getOrganisationId()));
            if (org.getOrganisationType().equals(OrganisationType.COURSE_TYPE)) {
                this.deleteChildUserOrganisations(user, org);
            }
        }
    }

    private Integer getRequestorId() {
        UserDTO userDTO = (UserDTO)SessionManager.getSession().getAttribute("user");
        return userDTO != null ? userDTO.getUserID() : null;
    }

    @Override
    public boolean isUserGlobalGroupAdmin() {
        Integer rootOrgId = this.getRootOrganisation().getOrganisationId();
        Integer requestorId = this.getRequestorId();
        return requestorId != null ? this.isUserInRole(requestorId, rootOrgId, "GROUP ADMIN") : false;
    }

    @Override
    public boolean isUserSysAdmin() {
        Integer rootOrgId = this.getRootOrganisation().getOrganisationId();
        Integer requestorId = this.getRequestorId();
        return requestorId != null ? this.isUserInRole(requestorId, rootOrgId, "SYSADMIN") : false;
    }

    @Override
    public Integer getCountRoleForSystem(Integer roleId) {
        Integer count = this.roleDAO.getCountRoleForSystem(roleId);
        if (count != null) {
            return count;
        }
        return new Integer(0);
    }

    @Override
    public Integer getCountRoleForOrg(Integer orgId, Integer roleId) {
        Integer count = this.roleDAO.getCountRoleForOrg(roleId, orgId);
        if (count != null) {
            return count;
        }
        return new Integer(0);
    }

    @Override
    public Theme getDefaultFlashTheme() {
        String flashName = Configuration.get(ConfigurationKeys.DEFAULT_FLASH_THEME);
        List list = this.findByProperty(Theme.class, "name", flashName);
        return list != null ? (Theme)list.get(0) : null;
    }

    @Override
    public Theme getDefaultHtmlTheme() {
        String htmlName = Configuration.get(ConfigurationKeys.DEFAULT_HTML_THEME);
        List list = this.findByProperty(Theme.class, "name", htmlName);
        return list != null ? (Theme)list.get(0) : null;
    }

    @Override
    public void auditPasswordChanged(User user, String moduleName) {
        Object[] args = new String[]{user.getLogin() + "(" + user.getUserId() + ")"};
        String message = this.messageService.getMessage("audit.user.password.change", args);
        this.getAuditService().log(moduleName, message);
    }

    @Override
    public void auditUserCreated(User user, String moduleName) {
        Object[] args = new String[]{user.getLogin() + "(" + user.getUserId() + ")", user.getFullName()};
        String message = this.messageService.getMessage("audit.user.create", args);
        this.getAuditService().log(moduleName, message);
    }

    @Override
    public Integer getCountUsers() {
        String query = "select count(u) from User u";
        return this.getFindIntegerResult(query);
    }

    @Override
    public Integer getCountUsers(Integer authenticationMethodId) {
        String query = "select count(u) from User u where u.authenticationMethod.authenticationMethodId=" + authenticationMethodId;
        return this.getFindIntegerResult(query);
    }

    private Integer getFindIntegerResult(String query) {
        List list = this.baseDAO.find(query);
        if (list != null && list.size() > 0) {
            return ((Number)list.get(0)).intValue();
        }
        return null;
    }

    @Override
    public List getActiveCourseIdsByUser(Integer userId, boolean isSysadmin) {
        List list = this.organisationDAO.getActiveCourseIdsByUser(userId, isSysadmin);
        return this.populateCollapsedOrgDTOs(list, isSysadmin);
    }

    @Override
    public List getArchivedCourseIdsByUser(Integer userId, boolean isSysadmin) {
        List list = this.organisationDAO.getArchivedCourseIdsByUser(userId, isSysadmin);
        return this.populateCollapsedOrgDTOs(list, isSysadmin);
    }

    private List populateCollapsedOrgDTOs(List list, boolean isSysadmin) {
        ArrayList<CollapsedOrgDTO> dtoList = new ArrayList<CollapsedOrgDTO>();
        for (Object obj : list) {
            if (isSysadmin) {
                Organisation org = (Organisation)this.findById(Organisation.class, (Integer)obj);
                dtoList.add(new CollapsedOrgDTO((Integer)obj, org.getName(), Boolean.TRUE));
                continue;
            }
            Object[] array = (Object[])obj;
            if (array.length <= 1) continue;
            Organisation org = (Organisation)this.findById(Organisation.class, (Integer)array[0]);
            if (array[1] != null) {
                dtoList.add(new CollapsedOrgDTO((Integer)array[0], org.getName(), (Boolean)array[1]));
                continue;
            }
            dtoList.add(new CollapsedOrgDTO((Integer)array[0], org.getName(), Boolean.FALSE));
        }
        Collections.sort(dtoList, new CollapsedOrgDTOComparator());
        return dtoList;
    }

    @Override
    public List searchUserSingleTerm(String term) {
        term = StringEscapeUtils.escapeSql((String)term);
        String query = "select u from User u where (u.login like '%" + term + "%' or u.firstName like '%" + term + "%' or u.lastName like '%" + term + "%' or u.email like '%" + term + "%')" + " and u.disabledFlag=0 order by u.login";
        List list = this.baseDAO.find(query);
        return list;
    }

    @Override
    public List searchUserSingleTerm(String term, Integer filteredOrgId) {
        term = StringEscapeUtils.escapeSql((String)term);
        String query = "select u from User u where (u.login like '%" + term + "%' or u.firstName like '%" + term + "%' or u.lastName like '%" + term + "%' or u.email like '%" + term + "%')" + " and u.disabledFlag=0 and u.userId not in (select uo.user.userId from UserOrganisation uo" + " where uo.organisation.organisationId=" + filteredOrgId + ") order by u.login";
        List list = this.baseDAO.find(query);
        return list;
    }

    @Override
    public List searchUserSingleTerm(String term, Integer orgId, Integer filteredOrgId) {
        term = StringEscapeUtils.escapeSql((String)term);
        String query = "select uo.user from UserOrganisation uo where (uo.user.login like '%" + term + "%'" + " or uo.user.firstName like '%" + term + "%' or uo.user.lastName like '%" + term + "%'" + " or uo.user.email like '%" + term + "%') and uo.user.disabledFlag=0" + " and uo.organisation.organisationId=" + orgId + " and uo.user.userId not in" + " (select uo.user.userId from UserOrganisation uo where uo.organisation.organisationId=" + filteredOrgId + ") order by uo.user.login";
        List list = this.baseDAO.find(query);
        return list;
    }

    @Override
    public List searchUserSingleTerm(String term, Integer orgId, boolean includeChildOrgs) {
        term = StringEscapeUtils.escapeSql((String)term);
        String whereClause = "";
        if (includeChildOrgs) {
            whereClause = " or uo.organisation.parentOrganisation.organisationId=" + orgId;
        }
        String query = "select u from User u where (u.login like '%" + term + "%' or u.firstName like '%" + term + "%' or u.lastName like '%" + term + "%' or u.email like '%" + term + "%')" + " and u.disabledFlag=0 and u.userId in (select uo.user.userId from UserOrganisation uo" + " where uo.organisation.organisationId=" + orgId + whereClause + ") order by u.login";
        List list = this.baseDAO.find(query);
        return list;
    }

    @Override
    public List getAllUsers() {
        String query = "from User u where u.disabledFlag=0 order by u.login";
        return this.baseDAO.find(query);
    }

    @Override
    public List getAllUsers(Integer filteredOrgId) {
        String query = "from User u where u.disabledFlag=0 and u.userId not in (select uo.user.userId from UserOrganisation uo where uo.organisation.organisationId=" + filteredOrgId + ")" + " order by u.login";
        return this.baseDAO.find(query);
    }

    @Override
    public List getAllUsersWithEmail(String email) {
        String query = "from User u where u.email='" + email + "' order by u.login";
        return this.baseDAO.find(query);
    }

    @Override
    public List getUsersFromOrganisation(Integer orgId, Integer filteredOrgId) {
        String query = "select uo.user from UserOrganisation uo where uo.organisation.organisationId=" + orgId + " and uo.user.userId not in (select uo.user.userId from UserOrganisation uo" + " where uo.organisation.organisationId=" + filteredOrgId + ") order by uo.user.login";
        return this.baseDAO.find(query);
    }

    @Override
    public boolean canEditGroup(Integer userId, Integer orgId) {
        if (this.isUserSysAdmin() || this.isUserGlobalGroupAdmin()) {
            return true;
        }
        Organisation org = (Organisation)this.findById(Organisation.class, orgId);
        if (org != null) {
            Integer groupId = orgId;
            if (org.getOrganisationType().getOrganisationTypeId().equals(OrganisationType.CLASS_TYPE)) {
                groupId = org.getParentOrganisation().getOrganisationId();
            }
            return this.isUserInRole(userId, groupId, "GROUP ADMIN") || this.isUserInRole(userId, groupId, "GROUP MANAGER");
        }
        return false;
    }

    @Override
    public ForgotPasswordRequest getForgotPasswordRequest(String key) {
        List results = this.baseDAO.findByProperty(ForgotPasswordRequest.class, "requestKey", key);
        return results.isEmpty() ? null : (ForgotPasswordRequest)results.get(0);
    }

    @Override
    public int removeUserFromOtherGroups(Integer userId, Integer orgId) {
        List uos = this.userOrganisationDAO.userOrganisationsNotById(userId, orgId);
        this.deleteAll(uos);
        return uos.size();
    }

    @Override
    public User getUserDTOByOpenidURL(String openidURL) {
        List results = this.baseDAO.findByProperty(User.class, "openidURL", openidURL);
        return results.isEmpty() ? null : (User)results.get(0);
    }
}

