/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.Grouper;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.RandomGrouping;
import org.lamsfoundation.lams.usermanagement.User;

public class RandomGrouper
implements Grouper,
Serializable {
    private static final String GROUP_NAME_PREFIX = "Group ";

    public void doGrouping(Grouping randomGrouping, String groupName, User learner) {
        ArrayList<User> learners = new ArrayList<User>();
        learners.add(learner);
        this.doGrouping(randomGrouping, groupName, learners);
    }

    public void doGrouping(Grouping randomGrouping, String groupName, List learners) {
        int numOfGroupsTobeCreated = 0;
        numOfGroupsTobeCreated = randomGrouping.getGroups().size() == 0 ? this.calculateNumOfNewGroups((RandomGrouping)randomGrouping, learners, true) : this.calculateNumOfNewGroups((RandomGrouping)randomGrouping, learners, false);
        this.createGroups((RandomGrouping)randomGrouping, numOfGroupsTobeCreated);
        this.joinGroups(randomGrouping, learners);
    }

    private int calculateNumOfNewGroups(RandomGrouping randomGrouping, List learners, boolean isInitialization) {
        if (randomGrouping.getNumberOfGroups() != null) {
            return this.getNewGroupsByNumberOfGroups(randomGrouping, isInitialization);
        }
        if (randomGrouping.getLearnersPerGroup() != null) {
            return this.getNewGroupsByLearnerPerGroup(randomGrouping, learners);
        }
        throw new RuntimeException("At least one random grouping algorithmneeds to be defined.");
    }

    private void createGroups(RandomGrouping randomGrouping, int numOfGroupsTobeCreated) {
        int size = randomGrouping.getGroups().size();
        for (int i = 0; i < numOfGroupsTobeCreated; ++i) {
            String groupName = GROUP_NAME_PREFIX + new Integer(size + i).toString();
            randomGrouping.getGroups().add(Group.createLearnerGroup(randomGrouping, groupName, new HashSet()));
        }
    }

    private void joinGroups(Grouping randomGrouping, List learners) {
        for (User learner : learners) {
            if (randomGrouping.doesLearnerExist(learner)) continue;
            Group selectedGroup = this.selectGroupToJoin((RandomGrouping)randomGrouping);
            selectedGroup.getUsers().add(learner);
        }
    }

    private Group selectGroupToJoin(RandomGrouping randomGrouping) {
        return randomGrouping.getGroupWithLeastMember();
    }

    private int getNewGroupsByLearnerPerGroup(RandomGrouping randomGrouping, List learners) {
        int newLearners = 0;
        for (User learner : learners) {
            if (randomGrouping.doesLearnerExist(learner)) continue;
            ++newLearners;
        }
        double totalRequiredGroups = Math.ceil((double)(randomGrouping.getLearners().size() + newLearners) / randomGrouping.getLearnersPerGroup().doubleValue());
        int existingGroups = randomGrouping.getGroups().size();
        return (int)totalRequiredGroups - existingGroups;
    }

    private int getNewGroupsByNumberOfGroups(RandomGrouping randomGrouping, boolean isInitialization) {
        if (isInitialization) {
            return randomGrouping.getNumberOfGroups();
        }
        int numberOfNewGroups = randomGrouping.getNumberOfGroups() - randomGrouping.getGroups().size();
        return numberOfNewGroups > 0 ? numberOfNewGroups : 0;
    }
}

