/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.dao.hibernate;

import org.lamsfoundation.lams.dao.hibernate.BaseDAO;
import org.lamsfoundation.lams.learningdesign.ChosenGrouping;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.RandomGrouping;
import org.lamsfoundation.lams.learningdesign.dao.IGroupingDAO;
import org.springframework.dao.DataRetrievalFailureException;

public class GroupingDAO
extends BaseDAO
implements IGroupingDAO {
    private static final String FIND_BY_UI_ID = "from " + Grouping.class.getName() + " g where g.groupingUIID=:UIID";

    public Grouping getGroupingById(Long groupingID) {
        Grouping grouping = (Grouping)super.find(Grouping.class, groupingID);
        return this.getNonCGLibGrouping(grouping);
    }

    public Grouping getGroupingByUIID(Integer groupingUIID) {
        if (groupingUIID != null) {
            Grouping grouping = (Grouping)this.getSession().createQuery(FIND_BY_UI_ID).setInteger("UIID", groupingUIID.intValue()).uniqueResult();
            return this.getNonCGLibGrouping(grouping);
        }
        return null;
    }

    private Grouping getNonCGLibGrouping(Grouping grouping) {
        if (grouping != null) {
            if (grouping.isRandomGrouping()) {
                return (Grouping)super.find(RandomGrouping.class, grouping.getGroupingId());
            }
            if (grouping.isChosenGrouping()) {
                return (Grouping)super.find(ChosenGrouping.class, grouping.getGroupingId());
            }
            throw new DataRetrievalFailureException("Unable to get grouping as the grouping type is unknown or missing. Grouping object is " + grouping);
        }
        return null;
    }
}

