/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.service;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.contentrepository.ItemNotFoundException;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.contentrepository.client.IToolContentHandler;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ChosenGrouping;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.License;
import org.lamsfoundation.lams.learningdesign.OptionsActivity;
import org.lamsfoundation.lams.learningdesign.ParallelActivity;
import org.lamsfoundation.lams.learningdesign.PermissionGateActivity;
import org.lamsfoundation.lams.learningdesign.RandomGrouping;
import org.lamsfoundation.lams.learningdesign.ScheduleGateActivity;
import org.lamsfoundation.lams.learningdesign.SequenceActivity;
import org.lamsfoundation.lams.learningdesign.SynchGateActivity;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.ActivityDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.GroupingDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.LearningDesignDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.LicenseDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.TransitionDAO;
import org.lamsfoundation.lams.learningdesign.dto.AuthoringActivityDTO;
import org.lamsfoundation.lams.learningdesign.dto.GroupingDTO;
import org.lamsfoundation.lams.learningdesign.dto.LearningDesignDTO;
import org.lamsfoundation.lams.learningdesign.dto.TransitionDTO;
import org.lamsfoundation.lams.learningdesign.service.ExportToolContentException;
import org.lamsfoundation.lams.learningdesign.service.IExportToolContentService;
import org.lamsfoundation.lams.learningdesign.service.ILearningDesignService;
import org.lamsfoundation.lams.learningdesign.service.ImportToolContentException;
import org.lamsfoundation.lams.lesson.LessonClass;
import org.lamsfoundation.lams.tool.Tool;
import org.lamsfoundation.lams.tool.ToolContent;
import org.lamsfoundation.lams.tool.ToolContentManager;
import org.lamsfoundation.lams.tool.dao.hibernate.ToolDAO;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dao.IWorkspaceFolderDAO;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.FileUtilException;
import org.lamsfoundation.lams.util.zipfile.ZipFileUtil;
import org.lamsfoundation.lams.util.zipfile.ZipFileUtilException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportToolContentService
implements IExportToolContentService,
ApplicationContextAware {
    public static final String LEARNING_DESIGN_SERVICE_BEAN_NAME = "learningDesignService";
    public static final String EXPORT_TOOLCONTNET_ZIP_PREFIX = "lams_toolcontent_";
    public static final String EXPORT_TOOLCONTNET_FOLDER_SUFFIX = "export_toolcontent";
    public static final String EXPORT_TOOLCONTNET_ZIP_SUFFIX = ".zip";
    public static final String LEARNING_DESIGN_FILE_NAME = "learning_design.xml";
    private static final String TOOL_FILE_NAME = "tool.xml";
    private Logger log = Logger.getLogger(ExportToolContentService.class);
    private ApplicationContext applicationContext;
    private List<FileHandleClassInfo> fileHandleClassList = new ArrayList<FileHandleClassInfo>();
    private ActivityDAO activityDAO;
    private ToolDAO toolDAO;
    private IWorkspaceFolderDAO workspaceFolderDAO;
    private LicenseDAO licenseDAO;
    private GroupingDAO groupingDAO;
    private TransitionDAO transitionDAO;
    private LearningDesignDAO learningDesignDAO;

    @Override
    public String exportLearningDesign(Long learningDesignId) throws ExportToolContentException {
        try {
            String rootDir = FileUtil.createTempDirectory(EXPORT_TOOLCONTNET_FOLDER_SUFFIX);
            String contentDir = FileUtil.getFullPath(rootDir, "content");
            FileUtil.createDirectory(contentDir);
            String targetZipFileName = EXPORT_TOOLCONTNET_ZIP_PREFIX + learningDesignId + EXPORT_TOOLCONTNET_ZIP_SUFFIX;
            String ldFileName = FileUtil.getFullPath(contentDir, LEARNING_DESIGN_FILE_NAME);
            FileWriter ldFile = new FileWriter(new File(ldFileName));
            ILearningDesignService service = this.getLearningDesignService();
            LearningDesignDTO ldDto = service.getLearningDesignDTO(learningDesignId);
            XStream designXml = new XStream();
            designXml.toXML((Object)ldDto, (Writer)ldFile);
            this.log.debug((Object)"Learning design xml export success");
            ArrayList activities = ldDto.getActivities();
            for (AuthoringActivityDTO activity : activities) {
                ToolContentManager contentManager = (ToolContentManager)this.findToolService(this.toolDAO.getToolByID(activity.getToolID()));
                this.log.debug((Object)("Tool export content : " + activity.getTitle() + " by contentID :" + activity.getToolContentID()));
                contentManager.exportToolContent(activity.getToolContentID(), contentDir);
            }
            this.log.debug((Object)("Create export content target zip file. File name is " + targetZipFileName));
            return ZipFileUtil.createZipFile(targetZipFileName, contentDir, rootDir);
        }
        catch (FileUtilException e) {
            this.log.error((Object)("FileUtilExcpetion:" + e.toString()));
            throw new ExportToolContentException(e);
        }
        catch (ZipFileUtilException e) {
            this.log.error((Object)("ZipFileUtilException:" + e.toString()));
            throw new ExportToolContentException(e);
        }
        catch (IOException e) {
            this.log.error((Object)("IOException:" + e.toString()));
            throw new ExportToolContentException(e);
        }
        catch (DataMissingException e) {
            this.log.error((Object)("DataMissingException:" + e.toString()));
            throw new ExportToolContentException(e);
        }
        catch (ToolException e) {
            this.log.error((Object)("ToolException:" + e.toString()));
            throw new ExportToolContentException(e);
        }
    }

    @Override
    public void exportToolContent(Long toolContentId, Object toolContentObj, IToolContentHandler toolContentHandler, String toPath) throws ExportToolContentException {
        try {
            String toolPath = FileUtil.getFullPath(toPath, toolContentId.toString());
            FileUtil.createDirectory(toolPath);
            String toolFileName = FileUtil.getFullPath(toolPath, TOOL_FILE_NAME);
            FileWriter toolFile = new FileWriter(new File(toolFileName));
            XStream toolXml = new XStream();
            Converter c = toolXml.getConverterLookup().defaultConverter();
            FileInvocationHandler handler = new FileInvocationHandler(c);
            handler.setFileHandleClassList(this.fileHandleClassList);
            Converter myc = (Converter)Proxy.newProxyInstance(c.getClass().getClassLoader(), new Class[]{Converter.class}, (InvocationHandler)handler);
            toolXml.registerConverter(myc);
            toolXml.toXML(toolContentObj, (Writer)toolFile);
            List<FileNodeInfo> list = handler.getFileNodes();
            for (FileNodeInfo fileNode : list) {
                this.log.debug((Object)("Tool attachement file is going to save : " + fileNode.getFileUuid()));
                toolContentHandler.saveFile(fileNode.getFileUuid(), toolPath + File.separator + fileNode.getFileUuid());
            }
            list.clear();
        }
        catch (ItemNotFoundException e) {
            throw new ExportToolContentException(e);
        }
        catch (RepositoryCheckedException e) {
            throw new ExportToolContentException(e);
        }
        catch (IOException e) {
            throw new ExportToolContentException(e);
        }
        catch (FileUtilException e) {
            throw new ExportToolContentException(e);
        }
        finally {
            if (this.fileHandleClassList != null) {
                this.fileHandleClassList.clear();
            }
        }
    }

    @Override
    public void registerFileHandleClass(String fileNodeClassName, String fileUuidFieldName, String fileVersionFieldName) {
        this.fileHandleClassList.add(new FileHandleClassInfo(fileNodeClassName, fileUuidFieldName, fileVersionFieldName));
    }

    @Override
    public void importLearningDesign(String learningDesignPath, User importer, Integer workspaceFolderUid) throws ImportToolContentException {
        try {
            FileReader ldFile = new FileReader(new File(FileUtil.getFullPath(learningDesignPath, LEARNING_DESIGN_FILE_NAME)));
            XStream designXml = new XStream();
            LearningDesignDTO ldDto = (LearningDesignDTO)designXml.fromXML((Reader)ldFile);
            this.log.debug((Object)"Learning design xml deserialize to LearingDesignDTO success.");
            HashMap<Long, ToolContent> toolMapper = new HashMap<Long, ToolContent>();
            ArrayList activities = ldDto.getActivities();
            for (AuthoringActivityDTO activity : activities) {
                String toolPath = FileUtil.getFullPath(learningDesignPath, activity.getToolContentID().toString());
                ToolContentManager contentManager = (ToolContentManager)this.findToolService(this.toolDAO.getToolByID(activity.getToolID()));
                this.log.debug((Object)("Tool import content : " + activity.getTitle() + " by contentID :" + activity.getToolContentID()));
                XStream toolXml = new XStream();
                FileReader toolFile = new FileReader(new File(FileUtil.getFullPath(toolPath, TOOL_FILE_NAME)));
                Object toolPOJO = toolXml.fromXML((Reader)toolFile);
                contentManager.importToolContent(toolPOJO);
            }
            this.saveLearningDesign(ldDto, importer, workspaceFolderUid, toolMapper);
        }
        catch (FileNotFoundException e) {
            throw new ImportToolContentException(e);
        }
        catch (ToolException e) {
            throw new ImportToolContentException(e);
        }
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.applicationContext = context;
    }

    private ILearningDesignService getLearningDesignService() {
        return (ILearningDesignService)this.applicationContext.getBean(LEARNING_DESIGN_SERVICE_BEAN_NAME);
    }

    private Object findToolService(Tool tool) throws NoSuchBeanDefinitionException {
        return this.applicationContext.getBean(tool.getServiceName());
    }

    private void saveLearningDesign(LearningDesignDTO dto, User importer, Integer workspaceFolderUid, Map<Long, ToolContent> toolMapper) throws ImportToolContentException {
        ArrayList groupingDtoList = dto.getGroupings();
        HashMap<Long, Grouping> groupingMapper = new HashMap<Long, Grouping>();
        for (GroupingDTO groupingDto : groupingDtoList) {
            Grouping grouping = this.getGrouping(groupingDto);
            groupingMapper.put(grouping.getGroupingId(), grouping);
            grouping.setGroupingId(null);
            this.groupingDAO.insert(grouping);
        }
        ArrayList actDtoList = dto.getActivities();
        LinkedHashSet<Activity> actList = new LinkedHashSet<Activity>();
        HashMap<Long, Activity> activityMapper = new HashMap<Long, Activity>();
        for (AuthoringActivityDTO actDto : actDtoList) {
            Activity act = this.getActivity(actDto, groupingMapper, toolMapper);
            activityMapper.put(act.getActivityId(), act);
            actList.add(act);
            act.setActivityId(null);
            this.activityDAO.insert(act);
        }
        ArrayList transDtoList = dto.getTransitions();
        LinkedHashSet<Transition> transList = new LinkedHashSet<Transition>();
        for (TransitionDTO transDto : transDtoList) {
            Transition trans = this.getTransition(transDto, activityMapper);
            transList.add(trans);
            trans.setTransitionId(null);
            this.transitionDAO.insert(trans);
        }
        LearningDesign ld = this.getLearningDesign(dto, importer, workspaceFolderUid, actList, transList);
        this.learningDesignDAO.insert(ld);
    }

    private LearningDesign getLearningDesign(LearningDesignDTO dto, User importer, Integer workspaceFolderUid, Set<Activity> actList, Set<Transition> transList) throws ImportToolContentException {
        LearningDesign ld = new LearningDesign();
        ld.setLearningDesignId(dto.getLearningDesignID());
        ld.setLearningDesignUIID(dto.getLearningDesignUIID());
        ld.setDescription(dto.getDescription());
        ld.setTitle(dto.getTitle());
        Integer actUid = dto.getFirstActivityUIID();
        if (actUid == null) {
            ld.setFirstActivity(null);
        } else {
            ld.setFirstActivity(this.activityDAO.getActivityByActivityId(new Long(actUid.intValue())));
        }
        ld.setMaxID(dto.getMaxID());
        ld.setValidDesign(dto.getValidDesign());
        ld.setReadOnly(dto.getReadOnly());
        ld.setDateReadOnly(dto.getDateReadOnly());
        ld.setOfflineInstructions(dto.getOfflineInstructions());
        ld.setOnlineInstructions(dto.getOnlineInstructions());
        ld.setHelpText(dto.getHelpText());
        ld.setCopyTypeID(1);
        ld.setCreateDateTime(dto.getCreateDateTime());
        ld.setVersion(dto.getVersion());
        if (workspaceFolderUid != null) {
            ld.setWorkspaceFolder(this.workspaceFolderDAO.getWorkspaceFolderByID(workspaceFolderUid));
        }
        ld.setDuration(dto.getDuration());
        ld.setLicenseText(dto.getLicenseText());
        Long licenseId = dto.getLicenseID();
        if (licenseId != null) {
            License license = this.licenseDAO.getLicenseByID(licenseId);
            if (license == null) {
                throw new ImportToolContentException("Import failed: License [" + dto.getLicenseText() + "] does not exist in target database");
            }
            ld.setLicense(this.licenseDAO.getLicenseByID(licenseId));
            ld.setLicenseText(dto.getLicenseText());
        }
        ld.setLessonOrgID(dto.getLessonOrgID());
        ld.setLessonOrgName(dto.getLessonOrgName());
        ld.setLessonID(dto.getLessonID());
        ld.setLessonName(dto.getLessonName());
        ld.setLessonStartDateTime(dto.getLessonStartDateTime());
        ld.setLastModifiedDateTime(dto.getLastModifiedDateTime());
        ld.setTransitions(transList);
        ld.setActivities(actList);
        ld.setCreateDateTime(new Date());
        ld.setLastModifiedDateTime(new Date());
        ld.setUser(importer);
        return ld;
    }

    private Grouping getGrouping(GroupingDTO groupingDto) {
        Grouping grouping = null;
        if (groupingDto == null) {
            return grouping;
        }
        Integer type = groupingDto.getGroupingTypeID();
        if (Grouping.CHOSEN_GROUPING_TYPE.equals(type)) {
            grouping = new ChosenGrouping();
        } else if (Grouping.RANDOM_GROUPING_TYPE.equals(type)) {
            grouping = new RandomGrouping();
            ((RandomGrouping)grouping).setLearnersPerGroup(groupingDto.getLearnersPerGroup());
            ((RandomGrouping)grouping).setNumberOfGroups(groupingDto.getNumberOfGroups());
        } else if (Grouping.CLASS_GROUPING_TYPE.equals(type)) {
            grouping = new LessonClass();
        }
        grouping.setGroupingId(groupingDto.getGroupingID());
        grouping.setGroupingUIID(groupingDto.getGroupingUIID());
        grouping.setMaxNumberOfGroups(groupingDto.getMaxNumberOfGroups());
        return grouping;
    }

    private Transition getTransition(TransitionDTO transDto, Map<Long, Activity> activityMapper) {
        Transition trans = new Transition();
        trans.setDescription(transDto.getDescription());
        trans.setFromActivity(activityMapper.get(transDto.getFromActivityID()));
        trans.setFromUIID(transDto.getFromUIID());
        trans.setTitle(transDto.getTitle());
        trans.setToActivity(activityMapper.get(transDto.getToActivityID()));
        trans.setToUIID(transDto.getToUIID());
        trans.setTransitionId(transDto.getTransitionID());
        trans.setTransitionUIID(transDto.getTransitionUIID());
        trans.setCreateDateTime(new Date());
        return trans;
    }

    private Activity getActivity(AuthoringActivityDTO actDto, Map<Long, Grouping> groupingList, Map<Long, ToolContent> toolMapper) {
        Grouping newGrouping;
        Activity act = null;
        if (actDto == null) {
            return act;
        }
        int type = actDto.getActivityTypeID();
        switch (type) {
            case 1: {
                act = new ToolActivity();
                ToolContent content = toolMapper.get(actDto.getToolID());
                ((ToolActivity)act).setTool(content.getTool());
                ((ToolActivity)act).setToolContentId(content.getToolContentId());
                ((ToolActivity)act).setToolSessions(null);
                break;
            }
            case 2: {
                act = new GroupingActivity();
                newGrouping = groupingList.get(actDto.getCreateGroupingID());
                ((GroupingActivity)act).setCreateGrouping(newGrouping);
                ((GroupingActivity)act).setCreateGroupingUIID(newGrouping.getGroupingUIID());
                break;
            }
            case 3: {
                act = new SynchGateActivity();
                ((SynchGateActivity)act).setGateActivityLevelId(actDto.getGateActivityLevelID());
                ((SynchGateActivity)act).setGateOpen(false);
                ((SynchGateActivity)act).setWaitingLearners(null);
                break;
            }
            case 4: {
                act = new ScheduleGateActivity();
                ((ScheduleGateActivity)act).setGateActivityLevelId(actDto.getGateActivityLevelID());
                ((ScheduleGateActivity)act).setWaitingLearners(null);
                ((ScheduleGateActivity)act).setGateOpen(false);
                ((ScheduleGateActivity)act).setGateEndDateTime(actDto.getGateEndDateTime());
                ((ScheduleGateActivity)act).setGateStartDateTime(actDto.getGateStartDateTime());
                ((ScheduleGateActivity)act).setGateStartTimeOffset(actDto.getGateStartTimeOffset());
                ((ScheduleGateActivity)act).setGateEndTimeOffset(actDto.getGateEndTimeOffset());
                break;
            }
            case 5: {
                act = new PermissionGateActivity();
                ((PermissionGateActivity)act).setGateActivityLevelId(actDto.getGateActivityLevelID());
                ((PermissionGateActivity)act).setGateOpen(false);
                ((PermissionGateActivity)act).setWaitingLearners(null);
                break;
            }
            case 6: {
                act = new ParallelActivity();
                break;
            }
            case 7: {
                act = new OptionsActivity();
                ((OptionsActivity)act).setMaxNumberOfOptions(actDto.getMaxOptions());
                ((OptionsActivity)act).setMinNumberOfOptions(actDto.getMinOptions());
                ((OptionsActivity)act).setOptionsInstructions(actDto.getOptionsInstructions());
                break;
            }
            case 8: {
                act = new SequenceActivity();
            }
        }
        act.setGroupingSupportType(actDto.getGroupingSupportType());
        act.setActivityCategoryID(actDto.getActivityCategoryID());
        act.setActivityId(actDto.getActivityID());
        act.setActivityTypeId(actDto.getActivityTypeID());
        act.setApplyGrouping(actDto.getApplyGrouping());
        act.setDefineLater(actDto.getDefineLater());
        act.setDescription(actDto.getDescription());
        act.setHelpText(actDto.getHelpText());
        act.setLanguageFile(actDto.getLanguageFile());
        act.setLibraryActivityUiImage(actDto.getLibraryActivityUIImage());
        act.setOrderId(actDto.getOrderID());
        act.setParentUIID(actDto.getParentUIID());
        act.setRunOffline(actDto.getRunOffline());
        act.setTitle(actDto.getTitle());
        act.setXcoord(actDto.getxCoord());
        act.setYcoord(actDto.getyCoord());
        newGrouping = groupingList.get(actDto.getGroupingID());
        act.setGrouping(newGrouping);
        act.setGroupingUIID(newGrouping.getGroupingUIID());
        act.setCreateDateTime(new Date());
        return act;
    }

    public ActivityDAO getActivityDAO() {
        return this.activityDAO;
    }

    public void setActivityDAO(ActivityDAO activityDAO) {
        this.activityDAO = activityDAO;
    }

    public ToolDAO getToolDAO() {
        return this.toolDAO;
    }

    public void setToolDAO(ToolDAO toolDAO) {
        this.toolDAO = toolDAO;
    }

    public IWorkspaceFolderDAO getWorkspaceFolderDAO() {
        return this.workspaceFolderDAO;
    }

    public void setWorkspaceFolderDAO(IWorkspaceFolderDAO workspaceFolderDAO) {
        this.workspaceFolderDAO = workspaceFolderDAO;
    }

    public LicenseDAO getLicenseDAO() {
        return this.licenseDAO;
    }

    public void setLicenseDAO(LicenseDAO licenseDAO) {
        this.licenseDAO = licenseDAO;
    }

    public GroupingDAO getGroupingDAO() {
        return this.groupingDAO;
    }

    public void setGroupingDAO(GroupingDAO groupingDAO) {
        this.groupingDAO = groupingDAO;
    }

    public LearningDesignDAO getLearningDesignDAO() {
        return this.learningDesignDAO;
    }

    public void setLearningDesignDAO(LearningDesignDAO learningDesignDAO) {
        this.learningDesignDAO = learningDesignDAO;
    }

    public TransitionDAO getTransitionDAO() {
        return this.transitionDAO;
    }

    public void setTransitionDAO(TransitionDAO transitionDAO) {
        this.transitionDAO = transitionDAO;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileInvocationHandler
    implements InvocationHandler {
        private Object obj;
        private List<FileNodeInfo> fileNodes;
        private List<FileHandleClassInfo> fileHandleClassList;

        public FileInvocationHandler(Object obj) {
            this.obj = obj;
            this.fileNodes = new ArrayList<FileNodeInfo>();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result;
            try {
                if (StringUtils.equals((String)method.getName(), (String)"marshal")) {
                    for (FileHandleClassInfo info : this.fileHandleClassList) {
                        if (args[0] == null || !info.className.equals(args[0].getClass().getName())) continue;
                        Long uuid = NumberUtils.createLong((String)BeanUtils.getProperty((Object)args[0], (String)info.uuidFieldName));
                        Long version = NumberUtils.createLong((String)BeanUtils.getProperty((Object)args[0], (String)info.versionFieldName));
                        ExportToolContentService.this.log.debug((Object)("XStream get file node [" + uuid + "," + version + "]."));
                        ExportToolContentService exportToolContentService = ExportToolContentService.this;
                        exportToolContentService.getClass();
                        this.fileNodes.add(exportToolContentService.new FileNodeInfo(uuid, version));
                    }
                }
                if (StringUtils.equals((String)method.getName(), (String)"canConvert")) {
                    boolean flag = false;
                    for (FileHandleClassInfo info : this.fileHandleClassList) {
                        if (args[0] == null || !info.className.equals(((Class)args[0]).getName())) continue;
                        ExportToolContentService.this.log.debug((Object)("XStream will handle [" + info.className + "] as file node class."));
                        flag = true;
                        break;
                    }
                    return flag;
                }
                result = method.invoke(this.obj, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
            catch (Exception e) {
                throw new RuntimeException("unexpected invocation exception: " + e.getMessage());
            }
            return result;
        }

        public List<FileNodeInfo> getFileNodes() {
            return this.fileNodes;
        }

        public List<FileHandleClassInfo> getFileHandleClassList() {
            return this.fileHandleClassList;
        }

        public void setFileHandleClassList(List<FileHandleClassInfo> fileHandleClassList) {
            this.fileHandleClassList = fileHandleClassList;
            for (FileHandleClassInfo info : fileHandleClassList) {
                try {
                    info.handlerClass = Class.forName(info.className);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("unexpected invocation exception: " + e.getMessage());
                }
            }
        }
    }

    private class FileNodeInfo {
        private Long fileUuid;
        private Long fileVersionId;

        public FileNodeInfo(Long uuid, Long versionId) {
            this.fileUuid = uuid;
            this.fileVersionId = versionId;
        }

        public Long getFileUuid() {
            return this.fileUuid;
        }

        public void setFileUuid(Long fileUuid) {
            this.fileUuid = fileUuid;
        }

        public Long getFileVersionId() {
            return this.fileVersionId;
        }

        public void setFileVersionId(Long fileVersionId) {
            this.fileVersionId = fileVersionId;
        }
    }

    private class FileHandleClassInfo {
        public Class handlerClass;
        public String className;
        public String uuidFieldName;
        public String versionFieldName;

        public FileHandleClassInfo(String className, String uuidFieldName, String versionFieldName) {
            this.className = className;
            this.uuidFieldName = uuidFieldName;
            this.versionFieldName = versionFieldName;
        }
    }
}

