/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.lesson.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.dao.ILessonDAO;
import org.lamsfoundation.lams.lesson.dto.LessonDTO;
import org.lamsfoundation.lams.lesson.dto.LessonDetailsDTO;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.usermanagement.User;

public class LessonService
implements ILessonService {
    private ILessonDAO lessonDAO;
    private HashMap<Long, HashMap> lessonMaps = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheLessonUser(Lesson lesson, User learner) {
        Lesson lesson2 = lesson;
        synchronized (lesson2) {
            HashMap<Integer, User> lessonUsersMap = this.lessonMaps.get(lesson.getLessonId());
            if (lessonUsersMap == null) {
                lessonUsersMap = new HashMap<Integer, User>();
                this.lessonMaps.put(lesson.getLessonId(), lessonUsersMap);
            }
            if (!lessonUsersMap.containsKey(learner.getUserId())) {
                lessonUsersMap.put(learner.getUserId(), learner);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLessonUserFromCache(Lesson lesson, User learner) {
        Lesson lesson2 = lesson;
        synchronized (lesson2) {
            HashMap lessonUsersMap = this.lessonMaps.get(lesson.getLessonId());
            if (lessonUsersMap != null) {
                lessonUsersMap.remove(learner.getUserId());
            }
            if (lessonUsersMap.size() == 0) {
                this.lessonMaps.remove(lesson.getLessonId());
            }
        }
    }

    public Collection getLoggedInLessonLearners(Long lessonId) {
        HashMap lessonUsersMap = this.lessonMaps.get(lessonId);
        if (lessonUsersMap != null) {
            return lessonUsersMap.values();
        }
        return new ArrayList();
    }

    public List getActiveLessonLearners(Long lessonId) {
        return this.lessonDAO.getActiveLearnerByLesson(lessonId);
    }

    public Integer getCountActiveLessonLearners(Long lessonId) {
        return this.lessonDAO.getCountActiveLearnerByLesson(lessonId);
    }

    public void setLessonDAO(ILessonDAO lessonDAO) {
        this.lessonDAO = lessonDAO;
    }

    public LessonDetailsDTO getLessonDetails(Long lessonId) {
        Lesson lesson = this.lessonDAO.getLesson(lessonId);
        LessonDetailsDTO dto = null;
        if (lesson != null) {
            dto = lesson.getLessonDetails();
            Integer active = this.getCountActiveLessonLearners(lessonId);
            dto.setNumberStartedLearners(active != null ? active : new Integer(0));
        }
        return dto;
    }

    public LessonDTO getLessonData(Long lessonId) {
        Lesson lesson = this.lessonDAO.getLesson(lessonId);
        LessonDTO dto = null;
        if (lesson != null) {
            dto = lesson.getLessonData();
        }
        return dto;
    }
}

