/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.usermanagement.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.cache.ICacheManager;
import org.lamsfoundation.lams.learningdesign.dao.ILearningDesignDAO;
import org.lamsfoundation.lams.lesson.dao.ILessonDAO;
import org.lamsfoundation.lams.usermanagement.AuthenticationMethod;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.UserOrganisation;
import org.lamsfoundation.lams.usermanagement.UserOrganisationRole;
import org.lamsfoundation.lams.usermanagement.Workspace;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.usermanagement.dao.IAuthenticationMethodDAO;
import org.lamsfoundation.lams.usermanagement.dao.IOrganisationDAO;
import org.lamsfoundation.lams.usermanagement.dao.IOrganisationTypeDAO;
import org.lamsfoundation.lams.usermanagement.dao.IRoleDAO;
import org.lamsfoundation.lams.usermanagement.dao.IUserDAO;
import org.lamsfoundation.lams.usermanagement.dao.IUserOrganisationDAO;
import org.lamsfoundation.lams.usermanagement.dao.IUserOrganisationRoleDAO;
import org.lamsfoundation.lams.usermanagement.dao.IWorkspaceDAO;
import org.lamsfoundation.lams.usermanagement.dao.IWorkspaceFolderDAO;
import org.lamsfoundation.lams.usermanagement.dto.OrganisationDTO;
import org.lamsfoundation.lams.usermanagement.dto.OrganisationDTOFactory;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserManagementService
implements IUserManagementService {
    protected Logger log = Logger.getLogger(UserManagementService.class);
    private IUserDAO userDAO;
    private IRoleDAO roleDAO;
    private IOrganisationDAO organisationDAO;
    private IOrganisationTypeDAO organisationTypeDAO;
    private IUserOrganisationDAO userOrganisationDAO;
    private IUserOrganisationRoleDAO userOrganisationRoleDAO;
    private IAuthenticationMethodDAO authenticationMethodDAO;
    protected IWorkspaceDAO workspaceDAO;
    protected IWorkspaceFolderDAO workspaceFolderDAO;
    protected ILearningDesignDAO learningDesignDAO;
    protected ILessonDAO lessonDAO;
    protected ICacheManager cacheManager;
    private String[] userClassParts = null;

    public void setWorkspaceFolderDAO(IWorkspaceFolderDAO workspaceFolderDAO) {
        this.workspaceFolderDAO = workspaceFolderDAO;
    }

    @Override
    public void setUserDAO(IUserDAO userDAO) {
        this.userDAO = userDAO;
    }

    @Override
    public void setRoleDAO(IRoleDAO roleDAO) {
        this.roleDAO = roleDAO;
    }

    @Override
    public void setOrganisationDAO(IOrganisationDAO organisationDAO) {
        this.organisationDAO = organisationDAO;
    }

    @Override
    public void setOrganisationTypeDAO(IOrganisationTypeDAO organisationTypeDAO) {
        this.organisationTypeDAO = organisationTypeDAO;
    }

    @Override
    public void setUserOrganisationDAO(IUserOrganisationDAO userOrganisationDAO) {
        this.userOrganisationDAO = userOrganisationDAO;
    }

    @Override
    public void setUserOrganisationRoleDAO(IUserOrganisationRoleDAO userOrganisationRoleDAO) {
        this.userOrganisationRoleDAO = userOrganisationRoleDAO;
    }

    @Override
    public void setAuthenticationMethodDAO(IAuthenticationMethodDAO authenticationMethodDAO) {
        this.authenticationMethodDAO = authenticationMethodDAO;
    }

    public void setLessonDAO(ILessonDAO lessonDAO) {
        this.lessonDAO = lessonDAO;
    }

    public void setCacheManager(ICacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public User getUserById(Integer userId) {
        User user;
        if (this.userClassParts == null) {
            this.userClassParts = this.cacheManager.getPartsFromClass(User.class);
        }
        if ((user = (User)this.cacheManager.getItem(this.userClassParts, (Object)userId)) == null) {
            user = this.userDAO.getUserById(userId);
            if (user != null) {
                this.cacheManager.addItem(this.userClassParts, (Object)user.getUserId(), (Object)user);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("getUserById retrieved user from database " + user.getUserId()));
                }
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("getUserById retrieved user from cache " + userId));
        }
        return user;
    }

    @Override
    public User getUserByLogin(String login) {
        User user = this.userDAO.getUserByLogin(login);
        if (user != null) {
            if (this.userClassParts == null) {
                this.userClassParts = this.cacheManager.getPartsFromClass(User.class);
            }
            this.cacheManager.addItem(this.userClassParts, (Object)user.getUserId(), (Object)user);
        }
        return user;
    }

    private void clearUserFromCache(User user) {
        this.cacheManager.removeItem(this.userClassParts, user.getUserId());
        this.cacheManager.removeItem(this.userClassParts, user.getLogin());
    }

    @Override
    public Organisation getOrganisationById(Integer organisationId) {
        return this.organisationDAO.getOrganisationById(organisationId);
    }

    @Override
    public OrganisationType getOrganisationTypeByName(String name) {
        return this.organisationTypeDAO.getOrganisationTypeByName(name);
    }

    @Override
    public Role getRoleByName(String roleName) {
        return this.roleDAO.getRoleByName(roleName);
    }

    @Override
    public UserOrganisationRole getUserOrganisationRole(Integer userID, Integer organisationId, String roleName) {
        User user = this.getUserById(userID);
        if (user == null) {
            return null;
        }
        UserOrganisation userOrganisation = this.userOrganisationDAO.getUserOrganisation(user.getUserId(), organisationId);
        if (userOrganisation == null) {
            return null;
        }
        Role role = this.roleDAO.getRoleByName(roleName);
        if (role == null) {
            return null;
        }
        return this.userOrganisationRoleDAO.getUserOrganisationRole(userOrganisation.getUserOrganisationId(), role.getRoleId());
    }

    @Override
    public UserOrganisation getUserOrganisation(Integer userId, Integer organisationId) {
        return this.userOrganisationDAO.getUserOrganisation(userId, organisationId);
    }

    @Override
    public List getAllAuthenticationMethods() {
        return this.authenticationMethodDAO.getAllAuthenticationMethods();
    }

    @Override
    public AuthenticationMethod getAuthenticationMethodForUser(String login) {
        return this.authenticationMethodDAO.getAuthenticationMethodByUser(this.getUserByLogin(login));
    }

    @Override
    public AuthenticationMethod getAuthenticationMethodForUser(User user) {
        return this.authenticationMethodDAO.getAuthenticationMethodByUser(user);
    }

    @Override
    public AuthenticationMethod getAuthenticationMethodByName(String name) {
        return this.authenticationMethodDAO.getAuthenticationMethodByName(name);
    }

    @Override
    public List getUserOrganisationsForUser(User user) {
        return this.userOrganisationDAO.getUserOrganisationsByUser(user);
    }

    @Override
    public OrganisationDTO getOrganisationsForUserByRole(User user, List<String> restrictToRoleNames) {
        ArrayList<OrganisationDTO> list = new ArrayList<OrganisationDTO>();
        for (UserOrganisation userOrganisation : this.userOrganisationDAO.getUserOrganisationsByUser(user)) {
            OrganisationDTO dto;
            boolean aRoleFound = this.addRolesToDTO(restrictToRoleNames, userOrganisation, dto = userOrganisation.getOrganisation().getOrganisationDTO());
            if (!aRoleFound) continue;
            list.add(dto);
        }
        return OrganisationDTOFactory.createTree(list);
    }

    @Override
    public OrganisationDTO getOrganisationsForUserByRole(User user, List<String> restrictToRoleNames, Integer courseId, List<Integer> restrictToClassIds) {
        ArrayList<OrganisationDTO> dtolist = new ArrayList<OrganisationDTO>();
        Organisation org = this.organisationDAO.getOrganisationById(courseId);
        dtolist.add(org.getOrganisationDTO());
        this.getChildOrganisations(user, org, restrictToRoleNames, restrictToClassIds, dtolist);
        OrganisationDTO dtoTree = OrganisationDTOFactory.createTree(dtolist);
        Vector<OrganisationDTO> nodes = dtoTree.getNodes();
        return nodes.get(0);
    }

    private void getChildOrganisations(User user, Organisation org, List<String> restrictToRoleNames, List<Integer> restrictToClassIds, List<OrganisationDTO> dtolist) {
        if (org != null) {
            boolean notCheckClassId = restrictToClassIds == null || restrictToClassIds.size() == 0;
            List childOrgs = this.userOrganisationDAO.getChildUserOrganisationsByUser(user, org);
            for (UserOrganisation userOrganisation : childOrgs) {
                OrganisationDTO dto = userOrganisation.getOrganisation().getOrganisationDTO();
                if (!notCheckClassId && !restrictToClassIds.contains(dto.getOrganisationID())) continue;
                boolean aRoleFound = this.addRolesToDTO(restrictToRoleNames, userOrganisation, dto);
                if (aRoleFound) {
                    dtolist.add(dto);
                }
                Organisation childOrganisation = userOrganisation.getOrganisation();
                if (org.getChildOrganisations().size() <= 0) continue;
                this.getChildOrganisations(user, childOrganisation, restrictToRoleNames, restrictToClassIds, dtolist);
            }
        }
    }

    private boolean addRolesToDTO(List<String> restrictToRoleNames, UserOrganisation userOrganisation, OrganisationDTO dto) {
        Iterator iter = userOrganisation.getUserOrganisationRoles().iterator();
        boolean roleFound = false;
        while (iter.hasNext()) {
            UserOrganisationRole userOrganisationRole = (UserOrganisationRole)iter.next();
            String roleName = userOrganisationRole.getRole().getName();
            if (restrictToRoleNames != null && restrictToRoleNames.size() != 0 && !restrictToRoleNames.contains(roleName)) continue;
            dto.addRoleName(roleName);
            roleFound = true;
        }
        return roleFound;
    }

    @Override
    public OrganisationDTO getOrganisationForUserWithRole(User user, Integer organisationId) {
        if (user != null && organisationId != null) {
            UserOrganisation userOrganisation = this.getUserOrganisation(user.getUserId(), organisationId);
            OrganisationDTO dto = userOrganisation.getOrganisation().getOrganisationDTO();
            this.addRolesToDTO(null, userOrganisation, dto);
            return dto;
        }
        return null;
    }

    @Override
    public List getChildOrganisations(Organisation parentOrg) {
        return this.organisationDAO.getChildOrganisations(parentOrg);
    }

    @Override
    public List<Role> getRolesForUserByOrganisation(User user, Integer orgId) {
        ArrayList<Role> list = new ArrayList<Role>();
        UserOrganisation userOrg = this.userOrganisationDAO.getUserOrganisation(user.getUserId(), orgId);
        if (userOrg == null) {
            return null;
        }
        for (UserOrganisationRole userOrgRole : this.userOrganisationRoleDAO.getUserOrganisationRoles(userOrg.getUserOrganisationId())) {
            list.add(userOrgRole.getRole());
        }
        return list;
    }

    @Override
    public List<User> getUsersFromOrganisation(Integer orgId) {
        ArrayList<User> list = new ArrayList<User>();
        for (UserOrganisation userOrganisation : this.userOrganisationDAO.getUserOrganisationsByOrganisationId(orgId)) {
            list.add(userOrganisation.getUser());
        }
        return list;
    }

    @Override
    public void createUser(User user) {
        this.userDAO.saveUser(user);
    }

    @Override
    public void updateUser(User user) {
        this.userDAO.updateUser(user);
        this.clearUserFromCache(user);
    }

    @Override
    public void saveOrUpdateUser(User user) {
        this.userDAO.saveOrUpdateUser(user);
        this.clearUserFromCache(user);
    }

    @Override
    public void updatePassword(String login, String newPassword) {
        this.userDAO.updatePassword(login, newPassword);
    }

    @Override
    public void removeUserOrganisation(UserOrganisation userOrganisation) {
        this.userOrganisationDAO.deleteUserOrganisation(userOrganisation);
    }

    @Override
    public void saveOrUpdateOrganisation(Organisation organisation) {
        this.organisationDAO.saveOrUpdateOrganisation(organisation);
    }

    @Override
    public void saveOrUpdateUserOrganisation(UserOrganisation userOrganisation) {
        this.userOrganisationDAO.saveOrUpdateUserOrganisation(userOrganisation);
    }

    @Override
    public void saveOrUpdateUserOrganisationRole(UserOrganisationRole userOrganisationRole) {
        this.userOrganisationRoleDAO.saveOrUpdateUserOrganisationRole(userOrganisationRole);
    }

    public void setUserManagementWorkspaceDAO(IWorkspaceDAO workspaceDAO) {
        this.workspaceDAO = workspaceDAO;
    }

    @Override
    public Integer saveOrganisation(Organisation organisation, Integer userID) {
        Workspace workspace = this.createWorkspace(organisation.getName());
        WorkspaceFolder workspaceFolder = this.createWorkspaceFolder(workspace, userID, WorkspaceFolder.NORMAL);
        workspace.setRootFolder(workspaceFolder);
        this.workspaceDAO.update(workspace);
        organisation.setWorkspace(workspace);
        this.organisationDAO.saveOrganisation(organisation);
        return organisation.getOrganisationId();
    }

    @Override
    public Workspace createWorkspace(String name) {
        Workspace workspace = new Workspace(name);
        this.workspaceDAO.insert(workspace);
        return workspace;
    }

    @Override
    public WorkspaceFolder createWorkspaceFolder(Workspace workspace, Integer userID, Integer workspaceFolderType) {
        WorkspaceFolder workspaceFolder = new WorkspaceFolder(workspace.getName(), workspace.getWorkspaceId(), userID, new Date(), new Date(), workspaceFolderType);
        this.workspaceFolderDAO.insert(workspaceFolder);
        return workspaceFolder;
    }

    @Override
    public Integer saveUser(User user, Integer roleID) {
        this.userDAO.saveUser(user);
        this.createUserOrganisation(user, roleID);
        Workspace workspace = this.createWorkspace(user.getLogin());
        WorkspaceFolder workspaceFolder = this.createWorkspaceFolder(workspace, user.getUserId(), WorkspaceFolder.NORMAL);
        this.createWorkspaceFolder(workspace, user.getUserId(), WorkspaceFolder.RUN_SEQUENCES);
        workspace.setRootFolder(workspaceFolder);
        this.workspaceDAO.update(workspace);
        user.setWorkspace(workspace);
        this.userDAO.updateUser(user);
        return user.getUserId();
    }

    private Integer createUserOrganisation(User user, Integer roleID) {
        UserOrganisation userOrganisation = new UserOrganisation();
        userOrganisation.setUser(user);
        this.userOrganisationDAO.saveUserOrganisation(userOrganisation);
        userOrganisation.addUserOrganisationRole(this.createUserOrganisationRole(userOrganisation, roleID));
        this.userOrganisationDAO.saveOrUpdateUserOrganisation(userOrganisation);
        return userOrganisation.getUserOrganisationId();
    }

    private UserOrganisationRole createUserOrganisationRole(UserOrganisation userOrganisation, Integer roleID) {
        UserOrganisationRole userOrganisationRole = new UserOrganisationRole();
        userOrganisationRole.setUserOrganisation(userOrganisation);
        userOrganisationRole.setRole(this.roleDAO.getRoleById(roleID));
        this.userOrganisationRoleDAO.saveUserOrganisationRole(userOrganisationRole);
        return userOrganisationRole;
    }

    public void setLearningDesignDAO(ILearningDesignDAO learningDesignDAO) {
        this.learningDesignDAO = learningDesignDAO;
    }

    @Override
    public Vector<UserDTO> getUsersFromOrganisationByRole(Integer organisationID, String roleName) {
        Vector<UserDTO> users = new Vector<UserDTO>();
        Organisation organisation = this.organisationDAO.getOrganisationById(organisationID);
        if (organisation != null) {
            for (UserOrganisation userOrganisation : organisation.getUserOrganisations()) {
                for (UserOrganisationRole userOrganisationRole : userOrganisation.getUserOrganisationRoles()) {
                    if (!userOrganisationRole.getRole().getName().equals(roleName)) continue;
                    users.add(userOrganisation.getUser().getUserDTO());
                }
            }
        }
        return users;
    }

    @Override
    public List getMonitorLessonsFromOrganisation(Integer userID, Integer organisationID) {
        return this.lessonDAO.getLessonsForMonitoring(userID, organisationID);
    }

    @Override
    public List getLearnerLessonsFromOrganisation(Integer userID, Integer organisationID) {
        return this.lessonDAO.getActiveLessonsForLearner(userID, organisationID);
    }
}

