/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.integration.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.integration.ExtCourseClassMap;
import org.lamsfoundation.lams.integration.ExtServerLessonMap;
import org.lamsfoundation.lams.integration.ExtServerOrgMap;
import org.lamsfoundation.lams.integration.ExtServerToolAdapterMap;
import org.lamsfoundation.lams.integration.ExtUserUseridMap;
import org.lamsfoundation.lams.integration.UserInfoFetchException;
import org.lamsfoundation.lams.integration.UserInfoValidationException;
import org.lamsfoundation.lams.integration.security.RandomPasswordGenerator;
import org.lamsfoundation.lams.integration.service.IIntegrationService;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.usermanagement.AuthenticationMethod;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationState;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.UserOrganisation;
import org.lamsfoundation.lams.usermanagement.UserOrganisationRole;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.CSVUtil;
import org.lamsfoundation.lams.util.HashUtil;
import org.lamsfoundation.lams.util.LanguageUtil;
import org.lamsfoundation.lams.util.ValidationUtil;

public class IntegrationService
implements IIntegrationService {
    private static Logger log = Logger.getLogger(IntegrationService.class);
    private IUserManagementService service;

    public IUserManagementService getService() {
        return this.service;
    }

    public void setService(IUserManagementService service) {
        this.service = service;
    }

    @Override
    public ExtServerOrgMap getExtServerOrgMap(String serverId) {
        List list = this.service.findByProperty(ExtServerOrgMap.class, "serverid", serverId);
        if (list == null || list.size() == 0) {
            return null;
        }
        return (ExtServerOrgMap)list.get(0);
    }

    @Override
    public ExtCourseClassMap getExtCourseClassMap(ExtServerOrgMap serverMap, ExtUserUseridMap userMap, String extCourseId, String countryIsoCode, String langIsoCode, String prettyCourseName, String method, Boolean prefix) throws UserInfoValidationException {
        String courseName = "";
        courseName = prettyCourseName != null ? prettyCourseName : extCourseId;
        if (StringUtils.equals((String)method, (String)"author") || StringUtils.equals((String)method, (String)"monitor")) {
            return this.getExtCourseClassMap(serverMap, userMap, extCourseId, courseName, countryIsoCode, langIsoCode, this.service.getRootOrganisation().getOrganisationId().toString(), true, prefix);
        }
        return this.getExtCourseClassMap(serverMap, userMap, extCourseId, courseName, countryIsoCode, langIsoCode, this.service.getRootOrganisation().getOrganisationId().toString(), false, prefix);
    }

    @Override
    public ExtCourseClassMap getExtCourseClassMap(ExtServerOrgMap serverMap, ExtUserUseridMap userMap, String extCourseId, String countryIsoCode, String langIsoCode, String prettyCourseName, String method) throws UserInfoValidationException {
        return this.getExtCourseClassMap(serverMap, userMap, extCourseId, countryIsoCode, langIsoCode, prettyCourseName, method, true);
    }

    @Override
    public ExtCourseClassMap getExtCourseClassMap(ExtServerOrgMap serverMap, ExtUserUseridMap userMap, String extCourseId, String extCourseName, String countryIsoCode, String langIsoCode, String parentOrgId, Boolean isTeacher, Boolean prefix) throws UserInfoValidationException {
        ExtCourseClassMap map;
        Organisation org;
        User user = userMap.getUser();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("courseid", extCourseId);
        properties.put("extServerOrgMap.sid", serverMap.getSid());
        List mapList = this.service.findByProperties(ExtCourseClassMap.class, properties);
        if (mapList == null || mapList.size() == 0) {
            org = this.createOrganisation(serverMap, user, extCourseId, extCourseName, countryIsoCode, langIsoCode, parentOrgId, prefix);
            map = new ExtCourseClassMap();
            map.setCourseid(extCourseId);
            map.setExtServerOrgMap(serverMap);
            map.setOrganisation(org);
            this.service.save(map);
        } else {
            String requestedCourseName;
            map = (ExtCourseClassMap)mapList.get(0);
            org = map.getOrganisation();
            String string = requestedCourseName = prefix != false ? this.buildName(serverMap.getPrefix(), extCourseName) : extCourseName;
            if (extCourseName != null && !org.getName().equals(requestedCourseName)) {
                if (!ValidationUtil.isOrgNameValid(requestedCourseName)) {
                    throw new UserInfoValidationException("Can't create organisation due to validation error: organisation name cannot contain any of these characters < > ^ * @ % $. External server:" + serverMap.getServerid() + ", orgId:" + extCourseId + ", orgName:" + requestedCourseName);
                }
                org.setName(requestedCourseName);
                this.service.updateOrganisationandWorkspaceNames(org);
            }
        }
        this.updateUserRoles(user, org, isTeacher);
        return map;
    }

    private void updateUserRoles(User user, Organisation org, Boolean isTeacher) {
        UserOrganisation uo = this.service.getUserOrganisation(user.getUserId(), org.getOrganisationId());
        if (uo == null) {
            uo = new UserOrganisation(user, org);
            this.service.save(uo);
            user.addUserOrganisation(uo);
            this.service.save(user);
        }
        Integer[] roles = isTeacher != false ? new Integer[]{Role.ROLE_AUTHOR, Role.ROLE_MONITOR, Role.ROLE_LEARNER} : new Integer[]{Role.ROLE_LEARNER};
        for (Integer roleId : roles) {
            if (this.service.hasRoleInOrganisation(user, roleId, org)) continue;
            UserOrganisationRole uor = new UserOrganisationRole(uo, (Role)this.service.findById(Role.class, roleId));
            this.service.save(uor);
            uo.addUserOrganisationRole(uor);
            this.service.save(uo);
        }
    }

    @Override
    public ExtUserUseridMap getExtUserUseridMap(ExtServerOrgMap serverMap, String extUsername, boolean prefix) throws UserInfoFetchException, UserInfoValidationException {
        ExtUserUseridMap extUserUseridMap = this.getExistingExtUserUseridMap(serverMap, extUsername);
        if (extUserUseridMap == null) {
            String[] userData = this.getUserDataFromExtServer(serverMap, extUsername);
            String password = HashUtil.sha1(RandomPasswordGenerator.nextPassword(10));
            return this.createExtUserUseridMap(serverMap, extUsername, password, userData, prefix);
        }
        return extUserUseridMap;
    }

    @Override
    public ExtUserUseridMap getExtUserUseridMap(ExtServerOrgMap serverMap, String extUsername) throws UserInfoFetchException, UserInfoValidationException {
        return this.getExtUserUseridMap(serverMap, extUsername, true);
    }

    @Override
    public ExtUserUseridMap getExistingExtUserUseridMap(ExtServerOrgMap serverMap, String extUsername) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("extServerOrgMap.sid", serverMap.getSid());
        properties.put("extUsername", extUsername);
        List list = this.service.findByProperties(ExtUserUseridMap.class, properties);
        if (list == null || list.size() == 0) {
            return null;
        }
        return (ExtUserUseridMap)list.get(0);
    }

    @Override
    public ExtUserUseridMap getImplicitExtUserUseridMap(ExtServerOrgMap serverMap, String extUsername, String password, String firstName, String lastName, String email) throws UserInfoValidationException {
        ExtUserUseridMap extUserUseridMap = this.getExistingExtUserUseridMap(serverMap, extUsername);
        if (extUserUseridMap == null) {
            String[] defaultLangCountry = LanguageUtil.getDefaultLangCountry();
            String[] userData = new String[]{"", firstName, lastName, "", "", "", "", "", "", "", "", email, defaultLangCountry[1], defaultLangCountry[0]};
            return this.createExtUserUseridMap(serverMap, extUsername, password, userData, false);
        }
        return extUserUseridMap;
    }

    @Override
    public ExtUserUseridMap getImplicitExtUserUseridMap(ExtServerOrgMap serverMap, String extUsername, String firstName, String lastName, String language, String country, String email, boolean prefix, boolean isUpdateUserDetails) throws UserInfoValidationException {
        ExtUserUseridMap extUserUseridMap = this.getExistingExtUserUseridMap(serverMap, extUsername);
        if (extUserUseridMap == null) {
            String[] userData = new String[]{"", firstName, lastName, "", "", "", "", "", "", "", "", email, country, language};
            String password = HashUtil.sha1(RandomPasswordGenerator.nextPassword(10));
            return this.createExtUserUseridMap(serverMap, extUsername, password, userData, prefix);
        }
        if (isUpdateUserDetails) {
            User user = extUserUseridMap.getUser();
            if (StringUtils.isNotBlank((String)firstName) && !ValidationUtil.isFirstLastNameValid(firstName)) {
                throw new UserInfoValidationException("Can't update user details due to validation error: First name contains invalid characters. External server:" + serverMap.getServerid() + ", Username:" + user.getLogin() + ", firstName:" + firstName + ", lastName:" + lastName);
            }
            if (StringUtils.isNotBlank((String)lastName) && !ValidationUtil.isFirstLastNameValid(lastName)) {
                throw new UserInfoValidationException("Can't update user details due to validation error: Last name contains invalid characters. External server:" + serverMap.getServerid() + ", Username:" + user.getLogin() + ", firstName:" + firstName + ", lastName:" + lastName);
            }
            if (StringUtils.isNotBlank((String)email) && !ValidationUtil.isEmailValid(email)) {
                throw new UserInfoValidationException("Can't update user details due to validation error: Email format is invalid. External server:" + serverMap.getServerid() + ", Username:" + user.getLogin() + ", firstName:" + firstName + ", lastName:" + lastName);
            }
            user.setFirstName(firstName);
            user.setLastName(lastName);
            user.setEmail(email);
            user.setModifiedDate(new Date());
            user.setLocale(LanguageUtil.getSupportedLocale(language, country));
            this.service.save(user);
            return extUserUseridMap;
        }
        return extUserUseridMap;
    }

    private Organisation createOrganisation(ExtServerOrgMap serverMap, User user, String extCourseId, String extCourseName, String countryIsoCode, String langIsoCode, String parentOrgId, Boolean prefix) throws UserInfoValidationException {
        String orgName;
        Organisation org = new Organisation();
        String string = orgName = prefix != false ? this.buildName(serverMap.getPrefix(), extCourseName) : extCourseName;
        if (StringUtils.isNotBlank((String)orgName) && !ValidationUtil.isOrgNameValid(orgName)) {
            throw new UserInfoValidationException("Can't create organisation due to validation error: organisation name cannot contain any of these characters < > ^ * @ % $. External server:" + serverMap.getServerid() + ", orgId:" + extCourseId + ", orgName:" + orgName);
        }
        org.setName(orgName);
        org.setDescription(extCourseId);
        org.setOrganisationState((OrganisationState)this.service.findById(OrganisationState.class, OrganisationState.ACTIVE));
        org.setLocale(LanguageUtil.getSupportedLocale(langIsoCode, countryIsoCode));
        Organisation parent = (Organisation)this.service.findById(Organisation.class, Integer.valueOf(parentOrgId));
        if (parent != null) {
            org.setParentOrganisation(parent);
            if (!parent.getOrganisationId().equals(this.service.getRootOrganisation().getOrganisationId())) {
                org.setOrganisationType((OrganisationType)this.service.findById(OrganisationType.class, OrganisationType.CLASS_TYPE));
            } else {
                org.setOrganisationType((OrganisationType)this.service.findById(OrganisationType.class, OrganisationType.COURSE_TYPE));
            }
        } else {
            org.setParentOrganisation(this.service.getRootOrganisation());
            org.setOrganisationType((OrganisationType)this.service.findById(OrganisationType.class, OrganisationType.COURSE_TYPE));
        }
        return this.service.saveOrganisation(org, user.getUserId());
    }

    private ExtUserUseridMap createExtUserUseridMap(ExtServerOrgMap serverMap, String extUsername, String password, String[] userData, boolean prefix) throws UserInfoValidationException {
        String login = prefix ? this.buildName(serverMap.getPrefix(), extUsername) : extUsername;
        String firstName = userData[1];
        String lastName = userData[2];
        String email = userData[11];
        if (StringUtils.isBlank((String)login)) {
            throw new UserInfoValidationException("Can't create user due to validation error: Username cannot be blank. External server:" + serverMap.getServerid() + ", firstName:" + firstName + ", lastName:" + lastName);
        }
        if (!ValidationUtil.isUserNameValid(login)) {
            throw new UserInfoValidationException("Can't create user due to validation error: Username can only contain alphanumeric characters and no spaces. External server:" + serverMap.getServerid() + ", Username:" + login);
        }
        if (StringUtils.isNotBlank((String)firstName) && !ValidationUtil.isFirstLastNameValid(firstName)) {
            throw new UserInfoValidationException("Can't create user due to validation error: First name contains invalid characters. External server:" + serverMap.getServerid() + ", Username:" + login + ", firstName:" + firstName + ", lastName:" + lastName);
        }
        if (StringUtils.isNotBlank((String)lastName) && !ValidationUtil.isFirstLastNameValid(lastName)) {
            throw new UserInfoValidationException("Can't create user due to validation error: Last name contains invalid characters. External server:" + serverMap.getServerid() + ", Username:" + login + ", firstName:" + firstName + ", lastName:" + lastName);
        }
        if (StringUtils.isNotBlank((String)email) && !ValidationUtil.isEmailValid(email)) {
            throw new UserInfoValidationException("Can't create user due to validation error: Email format is invalid. External server:" + serverMap.getServerid() + ", Username:" + login + ", firstName:" + firstName + ", lastName:" + lastName);
        }
        User user = new User();
        user.setLogin(login);
        user.setPassword(password);
        user.setTitle(userData[0]);
        user.setFirstName(userData[1]);
        user.setLastName(userData[2]);
        user.setAddressLine1(userData[3]);
        user.setCity(userData[4]);
        user.setState(userData[5]);
        user.setPostcode(userData[6]);
        user.setCountry(userData[7]);
        user.setDayPhone(userData[8]);
        user.setMobilePhone(userData[9]);
        user.setFax(userData[10]);
        user.setEmail(userData[11]);
        user.setAuthenticationMethod((AuthenticationMethod)this.service.findById(AuthenticationMethod.class, AuthenticationMethod.DB));
        user.setCreateDate(new Date());
        user.setDisabledFlag(false);
        user.setLocale(LanguageUtil.getSupportedLocale(userData[13], userData[12]));
        user.setFlashTheme(this.service.getDefaultFlashTheme());
        user.setHtmlTheme(this.service.getDefaultHtmlTheme());
        this.service.save(user);
        ExtUserUseridMap map = new ExtUserUseridMap();
        map.setExtServerOrgMap(serverMap);
        map.setExtUsername(extUsername);
        map.setUser(user);
        this.service.save(map);
        return map;
    }

    private String[] getUserDataFromExtServer(ExtServerOrgMap serverMap, String extUsername) throws UserInfoFetchException {
        try {
            String userDataCallbackUrl = serverMap.getUserinfoUrl();
            String timestamp = Long.toString(new Date().getTime());
            String hash = this.hash(serverMap, extUsername, timestamp);
            String encodedExtUsername = URLEncoder.encode(extUsername, "UTF8");
            userDataCallbackUrl = userDataCallbackUrl.replaceAll("%username%", encodedExtUsername).replaceAll("%timestamp%", timestamp).replaceAll("%hash%", hash);
            log.debug((Object)userDataCallbackUrl);
            URL url = new URL(userDataCallbackUrl);
            URLConnection conn = url.openConnection();
            if (!(conn instanceof HttpURLConnection)) {
                throw new UserInfoFetchException("Fail to fetch user data from external server:" + serverMap.getServerid() + "- Invalid connection type");
            }
            HttpURLConnection httpConn = (HttpURLConnection)conn;
            if (httpConn.getResponseCode() != 200) {
                throw new UserInfoFetchException("Fail to fetch user data from external server:" + serverMap.getServerid() + " - Unexpected return HTTP Status:" + httpConn.getResponseCode());
            }
            InputStream is = url.openConnection().getInputStream();
            BufferedReader isReader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String str = isReader.readLine();
            if (str == null) {
                throw new UserInfoFetchException("Fail to fetch user data from external server:" + serverMap.getServerid() + " - No data returned from external server");
            }
            return CSVUtil.parse(str);
        }
        catch (MalformedURLException e) {
            log.error((Object)e);
            throw new UserInfoFetchException(e);
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new UserInfoFetchException(e);
        }
        catch (ParseException e) {
            log.error((Object)e);
            throw new UserInfoFetchException(e);
        }
    }

    @Override
    public String hash(ExtServerOrgMap serverMap, String extUsername, String timestamp) {
        String serverId = serverMap.getServerid();
        String serverKey = serverMap.getServerkey();
        String plaintext = timestamp.trim().toLowerCase() + extUsername.trim().toLowerCase() + serverId.trim().toLowerCase() + serverKey.trim().toLowerCase();
        return HashUtil.sha1(plaintext);
    }

    private String buildName(String prefix, String name) {
        return prefix + '_' + name;
    }

    @Override
    public List getAllExtServerOrgMaps() {
        return this.service.findAll(ExtServerOrgMap.class);
    }

    @Override
    public List<ExtServerToolAdapterMap> getMappedServers(String toolSig) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("tool.toolSignature", toolSig);
        return this.service.findByProperties(ExtServerToolAdapterMap.class, properties);
    }

    @Override
    public ExtServerToolAdapterMap getMappedServer(String serverId, String toolSig) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("tool.toolSignature", toolSig);
        properties.put("extServer.serverid", serverId);
        List ret = this.service.findByProperties(ExtServerToolAdapterMap.class, properties);
        if (ret != null && ret.size() > 0) {
            return (ExtServerToolAdapterMap)ret.get(0);
        }
        return null;
    }

    @Override
    public void saveExtServerToolAdapterMap(ExtServerToolAdapterMap map) {
        this.service.save(map);
    }

    @Override
    public void deleteExtServerToolAdapterMap(ExtServerToolAdapterMap map) {
        this.service.delete(map);
    }

    @Override
    public void saveExtServerOrgMap(ExtServerOrgMap map) {
        this.service.save(map);
    }

    @Override
    public ExtServerOrgMap getExtServerOrgMap(Integer sid) {
        return (ExtServerOrgMap)this.service.findById(ExtServerOrgMap.class, sid);
    }

    public void createExtServerLessonMap(Long lessonId, ExtServerOrgMap extServer) {
        ExtServerLessonMap map = new ExtServerLessonMap();
        map.setLessonId(lessonId);
        map.setExtServer(extServer);
        this.service.save(map);
    }

    @Override
    public String getLessonFinishCallbackUrl(User user, Lesson lesson) throws UnsupportedEncodingException {
        ExtServerOrgMap serverMap;
        ExtUserUseridMap extUserUseridMap;
        Long lessonId;
        ExtServerLessonMap extServerLesson;
        String lessonFinishCallbackUrl = null;
        if (lesson != null && (extServerLesson = this.getExtServerLessonMap(lessonId = lesson.getLessonId())) != null && StringUtils.isNotBlank((String)extServerLesson.getExtServer().getLessonFinishUrl()) && (extUserUseridMap = this.getExistingExtUserUseridMap(serverMap = extServerLesson.getExtServer(), user)) != null) {
            String extUsername = extUserUseridMap.getExtUsername();
            lessonFinishCallbackUrl = serverMap.getLessonFinishUrl();
            String timestamp = Long.toString(new Date().getTime());
            String hash = this.hash(serverMap, extUsername, timestamp);
            String encodedExtUsername = URLEncoder.encode(extUsername, "UTF8");
            lessonFinishCallbackUrl = lessonFinishCallbackUrl.replaceAll("%username%", encodedExtUsername).replaceAll("%lessonid%", lessonId.toString()).replaceAll("%timestamp%", timestamp).replaceAll("%hash%", hash);
            log.debug((Object)lessonFinishCallbackUrl);
        }
        return lessonFinishCallbackUrl;
    }

    private ExtServerLessonMap getExtServerLessonMap(Long lessonId) {
        List list = this.service.findByProperty(ExtServerLessonMap.class, "lessonId", lessonId);
        if (list == null || list.size() == 0) {
            return null;
        }
        return (ExtServerLessonMap)list.get(0);
    }

    private ExtUserUseridMap getExistingExtUserUseridMap(ExtServerOrgMap serverMap, User user) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("extServerOrgMap.sid", serverMap.getSid());
        properties.put("user.userId", user.getUserId());
        List list = this.service.findByProperties(ExtUserUseridMap.class, properties);
        if (list == null || list.size() == 0) {
            return null;
        }
        return (ExtUserUseridMap)list.get(0);
    }
}

