/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.planner.dto;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.lamsfoundation.lams.planner.PedagogicalPlannerSequenceNode;
import org.lamsfoundation.lams.planner.dao.PedagogicalPlannerDAO;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.web.session.SessionManager;

public class PedagogicalPlannerSequenceNodeDTO {
    private Long uid;
    private List<String[]> titlePath;
    private String title;
    private String briefDescription;
    private String fullDescription;
    private String learningDesignTitle;
    private Boolean locked;
    private List<PedagogicalPlannerSequenceNodeDTO> subnodes;
    private Long parentUid;
    private Long learningDesignId;
    private Boolean isOwner = false;
    private Boolean isEditor = false;
    private Boolean permitViewTemplate;
    private Boolean permitPreview;
    private Boolean permitEditCopy;
    private Boolean permitEditOriginal;
    private Boolean permitReplaceTemplate;
    private Boolean permitRemoveNode;
    private Boolean edit = false;
    private Boolean createSubnode = false;
    private Boolean importNode = false;
    private List<PedagogicalPlannerSequenceNodeDTO> recentlyModifiedNodes;
    private Boolean displayAddRemoveEditorsLink = true;
    private static PedagogicalPlannerDAO pedagogicalPlannerDAO;
    private static final String FULL_DESCRIPTION_NOT_EMPTY = "FULL";

    public PedagogicalPlannerSequenceNodeDTO() {
    }

    public PedagogicalPlannerSequenceNodeDTO(PedagogicalPlannerSequenceNode node, Set<PedagogicalPlannerSequenceNode> subnodes, boolean isSysAdmin, PedagogicalPlannerDAO dao) {
        if (pedagogicalPlannerDAO == null) {
            pedagogicalPlannerDAO = dao;
        }
        this.uid = node.getUid();
        this.title = node.getTitle();
        this.briefDescription = node.getBriefDescription();
        this.fullDescription = node.getFullDescription();
        this.learningDesignTitle = node.getLearningDesignTitle();
        this.locked = node.getLocked();
        if (node.getParent() != null) {
            this.parentUid = node.getParent().getUid();
        }
        HttpSession s = SessionManager.getSession();
        UserDTO user = (UserDTO)s.getAttribute("user");
        PedagogicalPlannerSequenceNodeDTO.setPermissions(this, isSysAdmin, user, node);
        this.subnodes = new LinkedList<PedagogicalPlannerSequenceNodeDTO>();
        if (subnodes != null) {
            for (PedagogicalPlannerSequenceNode subnode : subnodes) {
                PedagogicalPlannerSequenceNodeDTO subnodeDTO = new PedagogicalPlannerSequenceNodeDTO();
                subnodeDTO.setTitle(subnode.getTitle());
                subnodeDTO.setBriefDescription(subnode.getBriefDescription());
                if (!StringUtils.isEmpty((String)subnode.getFullDescription())) {
                    subnodeDTO.setFullDescription(FULL_DESCRIPTION_NOT_EMPTY);
                }
                subnodeDTO.setLocked(subnode.getLocked());
                subnodeDTO.setLearningDesignTitle(subnode.getLearningDesignTitle());
                subnodeDTO.setUid(subnode.getUid());
                PedagogicalPlannerSequenceNodeDTO.setPermissions(subnodeDTO, isSysAdmin, user, subnode);
                if (user != null) {
                    subnodeDTO.setDisplayAddRemoveEditorsLink(subnodeDTO.isEditor);
                }
                this.subnodes.add(subnodeDTO);
            }
        }
    }

    private static void setPermissions(PedagogicalPlannerSequenceNodeDTO dto, boolean isSysAdmin, UserDTO user, PedagogicalPlannerSequenceNode node) {
        dto.isOwner = isSysAdmin || user != null && node.getUser() != null && user.getUserID().equals(node.getUser().getUserId());
        dto.isEditor = dto.isOwner != false || user != null && pedagogicalPlannerDAO.isEditor(user.getUserID(), node.getUid(), Role.ROLE_SYSADMIN) != false;
        Integer nodePermissions = node.getPermissions();
        dto.permitViewTemplate = dto.isOwner != false || nodePermissions == null || (dto.isEditor != false ? (nodePermissions & 1) != 0 : (nodePermissions & 0x10) != 0);
        dto.permitPreview = dto.isOwner != false || nodePermissions == null || dto.isEditor != false || (nodePermissions & 0x40) != 0;
        dto.permitEditCopy = dto.isOwner != false || nodePermissions == null || dto.isEditor != false || (nodePermissions & 0x20) != 0;
        dto.permitEditOriginal = dto.isOwner != false || dto.isEditor != false && (nodePermissions == null || (nodePermissions & 2) != 0);
        dto.permitReplaceTemplate = dto.isOwner != false || dto.isEditor != false && (nodePermissions == null || (nodePermissions & 4) != 0);
        dto.permitRemoveNode = dto.isOwner != false || dto.isEditor != false && (nodePermissions == null || (nodePermissions & 8) != 0);
    }

    public List<String[]> getTitlePath() {
        return this.titlePath;
    }

    public void setTitlePath(List<String[]> titlePath) {
        this.titlePath = titlePath;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getBriefDescription() {
        return this.briefDescription;
    }

    public void setBriefDescription(String briefDescription) {
        this.briefDescription = briefDescription;
    }

    public String getFullDescription() {
        return this.fullDescription;
    }

    public void setFullDescription(String fullDescription) {
        this.fullDescription = fullDescription;
    }

    public String getLearningDesignTitle() {
        return this.learningDesignTitle;
    }

    public void setLearningDesignTitle(String fileName) {
        this.learningDesignTitle = fileName;
    }

    public List<PedagogicalPlannerSequenceNodeDTO> getSubnodes() {
        return this.subnodes;
    }

    public void setSubnodes(List<PedagogicalPlannerSequenceNodeDTO> subnodes) {
        this.subnodes = subnodes;
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public Boolean getLocked() {
        return this.locked;
    }

    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    public Long getParentUid() {
        return this.parentUid;
    }

    public void setParentUid(Long parentUid) {
        this.parentUid = parentUid;
    }

    public Boolean getEdit() {
        return this.edit;
    }

    public void setEdit(Boolean edit) {
        this.edit = edit;
    }

    public Boolean getCreateSubnode() {
        return this.createSubnode;
    }

    public void setCreateSubnode(Boolean createSubnode) {
        this.createSubnode = createSubnode;
    }

    public Boolean getIsEditor() {
        return this.isEditor;
    }

    public void setIsEditor(Boolean hasRole) {
        this.isEditor = hasRole;
    }

    public Boolean getImportNode() {
        return this.importNode;
    }

    public void setImportNode(Boolean importNode) {
        this.importNode = importNode;
    }

    public Long getLearningDesignId() {
        return this.learningDesignId;
    }

    public void setLearningDesignId(Long learningDesignId) {
        this.learningDesignId = learningDesignId;
    }

    public List<PedagogicalPlannerSequenceNodeDTO> getRecentlyModifiedNodes() {
        return this.recentlyModifiedNodes;
    }

    public void setRecentlyModifiedNodes(List<PedagogicalPlannerSequenceNodeDTO> recentlyModifiedNodes) {
        this.recentlyModifiedNodes = recentlyModifiedNodes;
    }

    public Boolean getDisplayAddRemoveEditorsLink() {
        return this.displayAddRemoveEditorsLink;
    }

    public void setDisplayAddRemoveEditorsLink(Boolean displayAddRemoveEditorsLink) {
        this.displayAddRemoveEditorsLink = displayAddRemoveEditorsLink;
    }

    public Boolean getPermitEditCopy() {
        return this.permitEditCopy;
    }

    public void setPermitEditCopy(Boolean editCopyPermitted) {
        this.permitEditCopy = editCopyPermitted;
    }

    public Boolean getPermitEditOriginal() {
        return this.permitEditOriginal;
    }

    public void setPermitEditOriginal(Boolean editOriginalPermitted) {
        this.permitEditOriginal = editOriginalPermitted;
    }

    public Boolean getIsOwner() {
        return this.isOwner;
    }

    public void setIsOwner(Boolean isOwner) {
        this.isOwner = isOwner;
    }

    public Boolean getPermitViewTemplate() {
        return this.permitViewTemplate;
    }

    public void setPermitViewTemplate(Boolean permitViewTemplate) {
        this.permitViewTemplate = permitViewTemplate;
    }

    public Boolean getPermitPreview() {
        return this.permitPreview;
    }

    public void setPermitPreview(Boolean permitPreview) {
        this.permitPreview = permitPreview;
    }

    public Boolean getPermitReplaceTemplate() {
        return this.permitReplaceTemplate;
    }

    public void setPermitReplaceTemplate(Boolean permitChangeTemplate) {
        this.permitReplaceTemplate = permitChangeTemplate;
    }

    public Boolean getPermitRemoveNode() {
        return this.permitRemoveNode;
    }

    public void setPermitRemoveNode(Boolean permitRemoveTemplate) {
        this.permitRemoveNode = permitRemoveTemplate;
    }
}

