/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.owasp.csrfguard.CsrfGuard;

public class CsrfGuardServletContextListener
implements ServletContextListener {
    private static final String CONFIG_PARAM = "Owasp.CsrfGuard.Config";
    private static final String CONFIG_PRINT_PARAM = "Owasp.CsrfGuard.Config.Print";
    private static String servletContext = null;
    private static String configFileName = null;

    public static String getServletContext() {
        return servletContext;
    }

    public static String getConfigFileName() {
        return configFileName;
    }

    public void contextInitialized(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        servletContext = context.getContextPath();
        if (StringUtils.equals((CharSequence)servletContext, (CharSequence)"/")) {
            servletContext = "";
        }
        if ((configFileName = context.getInitParameter(CONFIG_PARAM)) == null) {
            configFileName = "Owasp.CsrfGuard.properties";
        }
        try (InputStream configFileInputStream = this.getResourceStream(configFileName, context, false);){
            if (Objects.isNull(configFileInputStream)) {
                try (InputStream metaInfInputStream = this.getResourceStream("META-INF/csrfguard.properties", context, false);){
                    if (Objects.isNull(metaInfInputStream)) {
                        throw new RuntimeException("Can't find default OWASP CSRFGuard properties file: " + configFileName);
                    }
                    this.loadProperties(metaInfInputStream);
                }
            }
            this.loadProperties(configFileInputStream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        CsrfGuardServletContextListener.printConfigIfConfigured(context, "Printing properties before JavaScript servlet, note, the JavaScript properties might not be initialized yet: ");
    }

    private void loadProperties(InputStream resourceStream) throws IOException {
        Properties properties = new Properties();
        properties.load(resourceStream);
        CsrfGuard.load(properties);
    }

    public static void printConfigIfConfigured(ServletContext context, String prefix) {
        CsrfGuard csrfGuard = CsrfGuard.getInstance();
        if (csrfGuard.isEnabled()) {
            boolean shouldPrintConfig;
            String contextPrintConfig = context.getInitParameter(CONFIG_PRINT_PARAM);
            boolean bl = shouldPrintConfig = StringUtils.isBlank((CharSequence)contextPrintConfig) ? csrfGuard.isPrintConfig() : Boolean.parseBoolean(contextPrintConfig);
            if (shouldPrintConfig) {
                context.log(prefix + String.valueOf(csrfGuard));
            }
        } else {
            context.log("OWASP CSRFGuard is disabled.");
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
    }

    private InputStream getResourceStream(String resourceName, ServletContext context, boolean failIfNotFound) throws IOException {
        File file;
        File file2;
        String fileName;
        InputStream inputStream = context.getResourceAsStream(resourceName);
        if (inputStream == null) {
            inputStream = this.getClass().getClassLoader().getResourceAsStream(resourceName);
        }
        if (inputStream == null && (fileName = context.getRealPath(resourceName)) != null && (file2 = new File(fileName)).exists()) {
            inputStream = new FileInputStream(fileName);
        }
        if (inputStream == null && (file = new File(resourceName)).exists()) {
            inputStream = new FileInputStream(resourceName);
        }
        if (inputStream == null && failIfNotFound) {
            throw new IOException(String.format("unable to locate resource - %s", resourceName));
        }
        return inputStream;
    }
}

