/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard.config.overlay;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.owasp.csrfguard.config.overlay.ExpirableCache;

public class ConfigPropertiesCascadeCommonUtils {
    private static ExpirableCache<Class, Method[]> declaredMethodsCache = null;
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static String fileCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static URL computeUrl(String resourceName, boolean canBeNull) {
        ClassLoader cl = ConfigPropertiesCascadeCommonUtils.classLoader();
        URL url = null;
        try {
            String newResourceName = resourceName.startsWith("/") ? resourceName.substring(1) : resourceName;
            url = cl.getResource(newResourceName);
        }
        catch (NullPointerException npe) {
            String error = "computeUrl() Could not find resource file: " + resourceName;
            throw new RuntimeException(error, npe);
        }
        if (!canBeNull && url == null) {
            throw new RuntimeException("Cant find resource: " + resourceName);
        }
        return url;
    }

    public static ClassLoader classLoader() {
        return ConfigPropertiesCascadeCommonUtils.class.getClassLoader();
    }

    public static String prefixOrSuffix(String startString, String separator, boolean isPrefix) {
        String prefixOrSuffix = null;
        if (startString == null) {
            return startString;
        }
        int separatorIndex = startString.indexOf(separator);
        if (separatorIndex == -1) {
            return startString;
        }
        int separatorLength = separator.length();
        prefixOrSuffix = isPrefix ? startString.substring(0, separatorIndex) : startString.substring(separatorIndex + separatorLength, startString.length());
        return prefixOrSuffix;
    }

    public static <T> T newInstance(Class<T> theClass) {
        try {
            return theClass.newInstance();
        }
        catch (Throwable e) {
            if (theClass != null && Modifier.isAbstract(theClass.getModifiers())) {
                throw new RuntimeException("Problem with class: " + String.valueOf(theClass) + ", maybe because it is abstract!", e);
            }
            throw new RuntimeException("Problem with class: " + String.valueOf(theClass), e);
        }
    }

    public static <T> T newInstance(Class<T> theClass, boolean allowPrivateConstructor) {
        if (!allowPrivateConstructor) {
            return ConfigPropertiesCascadeCommonUtils.newInstance(theClass);
        }
        try {
            Constructor<?>[] constructorArray;
            for (Constructor<?> constructor : constructorArray = theClass.getDeclaredConstructors()) {
                if (constructor.getGenericParameterTypes().length != 0) continue;
                if (allowPrivateConstructor) {
                    constructor.setAccessible(true);
                }
                return (T)constructor.newInstance(new Object[0]);
            }
            throw new RuntimeException("Why cant we find a constructor for class: " + String.valueOf(theClass));
        }
        catch (Throwable e) {
            if (theClass != null && Modifier.isAbstract(theClass.getModifiers())) {
                throw new RuntimeException("Problem with class: " + String.valueOf(theClass) + ", maybe because it is abstract!", e);
            }
            throw new RuntimeException("Problem with class: " + String.valueOf(theClass), e);
        }
    }

    @Deprecated
    public static String MapToString(Map map) {
        return ConfigPropertiesCascadeCommonUtils.mapToString(map);
    }

    public static String mapToString(Map map) {
        if (map == null) {
            return "null";
        }
        if (map.size() == 0) {
            return "empty";
        }
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Object object : map.keySet()) {
            if (!first) {
                result.append(", ");
            }
            first = false;
            result.append(object).append(": ").append(map.get(object));
        }
        return result.toString();
    }

    public static String[] splitTrim(String input, String separator) {
        return ConfigPropertiesCascadeCommonUtils.splitTrim(input, separator, true);
    }

    public static List<String> splitTrimToList(String input, String separator) {
        if (ConfigPropertiesCascadeCommonUtils.isBlank(input)) {
            return null;
        }
        String[] array = ConfigPropertiesCascadeCommonUtils.splitTrim(input, separator);
        return ConfigPropertiesCascadeCommonUtils.toList(array);
    }

    public static String[] splitTrim(String input, String separator, boolean treatAdjacentSeparatorsAsOne) {
        if (ConfigPropertiesCascadeCommonUtils.isBlank(input)) {
            return null;
        }
        String[] items = treatAdjacentSeparatorsAsOne ? ConfigPropertiesCascadeCommonUtils.split(input, separator) : ConfigPropertiesCascadeCommonUtils.splitPreserveAllTokens(input, separator);
        for (int i = 0; items != null && i < items.length; ++i) {
            items[i] = ConfigPropertiesCascadeCommonUtils.trim(items[i]);
        }
        return items;
    }

    public static <T> List<T> toList(T ... objects) {
        if (objects == null) {
            return null;
        }
        if (objects.length == 1 && objects[0] instanceof List) {
            return (List)objects[0];
        }
        ArrayList<T> result = new ArrayList<T>();
        for (T object : objects) {
            result.add(object);
        }
        return result;
    }

    private static ExpirableCache<Class, Method[]> declaredMethodsCache() {
        if (declaredMethodsCache == null) {
            declaredMethodsCache = new ExpirableCache(1440);
        }
        return declaredMethodsCache;
    }

    public static String className(Object object) {
        return object == null ? null : object.getClass().getName();
    }

    private static Method[] retrieveDeclaredMethods(Class theClass) {
        Method[] methods = ConfigPropertiesCascadeCommonUtils.declaredMethodsCache().get(theClass);
        if (methods == null) {
            methods = theClass.getDeclaredMethods();
            ConfigPropertiesCascadeCommonUtils.declaredMethodsCache().put(theClass, methods);
        }
        return methods;
    }

    public static int intValue(Object input) {
        if (input instanceof String) {
            String string = (String)input;
            return Integer.parseInt(string);
        }
        if (input instanceof Number) {
            return ((Number)input).intValue();
        }
        throw new RuntimeException("Cannot convert to int: " + ConfigPropertiesCascadeCommonUtils.className(input));
    }

    public static void closeQuietly(InputStream input) {
        if (input == null) {
            return;
        }
        try {
            input.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String toString(InputStream input, String encoding) throws IOException {
        StringWriter sw = new StringWriter();
        ConfigPropertiesCascadeCommonUtils.copy(input, sw, encoding);
        return sw.toString();
    }

    public static void copy(InputStream input, Writer output, String encoding) throws IOException {
        InputStreamReader in = new InputStreamReader(input, encoding);
        ConfigPropertiesCascadeCommonUtils.copy(in, output);
    }

    public static int copy(Reader input, Writer output) throws IOException {
        char[] buffer = new char[4096];
        int count = 0;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += n;
        }
        return count;
    }

    public static <E extends Enum<?>> E enumValueOfIgnoreCase(Class<E> theEnumClass, String string, boolean exceptionOnNotFound) throws RuntimeException {
        if (!exceptionOnNotFound && ConfigPropertiesCascadeCommonUtils.isBlank(string)) {
            return null;
        }
        for (Enum e : (Enum[])theEnumClass.getEnumConstants()) {
            if (!ConfigPropertiesCascadeCommonUtils.equalsIgnoreCase(string, e.name())) continue;
            return (E)e;
        }
        StringBuilder error = new StringBuilder("Cant find " + theEnumClass.getSimpleName() + " from string: '").append(string);
        error.append("', expecting one of: ");
        for (Enum e : (Enum[])theEnumClass.getEnumConstants()) {
            error.append(e.name()).append(", ");
        }
        throw new RuntimeException(error.toString());
    }

    public static boolean equals(String first, String second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        return first.equals(second);
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equalsIgnoreCase(str2);
    }

    public static String[] split(String str, String separatorChars) {
        return ConfigPropertiesCascadeCommonUtils.splitWorker(str, separatorChars, -1, false);
    }

    public static String[] splitPreserveAllTokens(String str, String separatorChars) {
        return ConfigPropertiesCascadeCommonUtils.splitWorker(str, separatorChars, -1, true);
    }

    private static String[] splitWorker(String str, String separatorChars, int max, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int sizePlus1 = 1;
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        if (separatorChars == null) {
            while (i < len) {
                if (Character.isWhitespace(str.charAt(i))) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        } else if (separatorChars.length() == 1) {
            char sep = separatorChars.charAt(0);
            while (i < len) {
                if (str.charAt(i) == sep) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        } else {
            while (i < len) {
                if (separatorChars.indexOf(str.charAt(i)) >= 0) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        }
        if (match || preserveAllTokens && lastMatch) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String defaultString(String str) {
        return str == null ? "" : str;
    }

    public static File jarFile(Class sampleClass) {
        try {
            CodeSource codeSource = sampleClass.getProtectionDomain().getCodeSource();
            if (codeSource != null && codeSource.getLocation() != null) {
                String fileName = URLDecoder.decode(codeSource.getLocation().getFile(), "UTF-8");
                return new File(fileName);
            }
            Object resourcePath = sampleClass.getName();
            URL url = ConfigPropertiesCascadeCommonUtils.computeUrl((String)(resourcePath = ((String)resourcePath).replace('.', '/') + ".class"), true);
            String urlPath = url.toString();
            if (urlPath.startsWith("jar:")) {
                urlPath = urlPath.substring(4);
            }
            if (urlPath.startsWith("file:")) {
                urlPath = urlPath.substring(5);
            }
            urlPath = ConfigPropertiesCascadeCommonUtils.prefixOrSuffix(urlPath, "!", true);
            urlPath = URLDecoder.decode(urlPath, "UTF-8");
            File file = new File(urlPath);
            if (urlPath.endsWith(".jar") && file.exists() && file.isFile()) {
                return file;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String stripLastSlashIfExists(String input) {
        if (input == null || input.length() == 0) {
            return null;
        }
        char lastChar = input.charAt(input.length() - 1);
        if (lastChar == '\\' || lastChar == '/') {
            return input.substring(0, input.length() - 1);
        }
        return input;
    }
}

