/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard.util;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.owasp.csrfguard.CsrfGuard;
import org.owasp.csrfguard.config.overlay.ConfigPropertiesCascadeCommonUtils;
import org.owasp.csrfguard.token.transferobject.TokenTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CsrfGuardUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CsrfGuardUtils.class.getName());

    private CsrfGuardUtils() {
    }

    public static String httpProtocolAndDomain(String url, boolean includeProtocol) {
        if (includeProtocol) {
            return CsrfGuardUtils.httpProtocolAndDomain(url);
        }
        return CsrfGuardUtils.httpProtocolAndDomain(url.replaceFirst("^(http[s]?)://", ""));
    }

    public static <T> Class<T> forName(String origClassName) {
        try {
            return Class.forName(origClassName);
        }
        catch (Throwable t) {
            throw new RuntimeException("Problem loading class: " + origClassName, t);
        }
    }

    public static String readResourceFileContent(String resourceName) {
        String string;
        block9: {
            InputStream inputStream = CsrfGuardUtils.class.getClassLoader().getResourceAsStream(resourceName);
            try {
                if (inputStream == null) {
                    throw new IllegalStateException("Could not find resource " + resourceName);
                }
                string = CsrfGuardUtils.readInputStreamContent(inputStream);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            inputStream.close();
        }
        return string;
    }

    public static String readFileContent(String fileNameWithAbsolutePath) {
        String string;
        FileInputStream inputStream = new FileInputStream(fileNameWithAbsolutePath);
        try {
            string = CsrfGuardUtils.readInputStreamContent(inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        ((InputStream)inputStream).close();
        return string;
    }

    public static <T> T newInstance(Class<T> theClass) {
        return ConfigPropertiesCascadeCommonUtils.newInstance(theClass);
    }

    public static void addResponseTokenHeader(CsrfGuard csrfGuard, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, TokenTO tokenTO) {
        if (csrfGuard.isAjaxEnabled() && CsrfGuardUtils.isAjaxRequest(httpServletRequest) && !tokenTO.isEmpty()) {
            httpServletResponse.setHeader(csrfGuard.getTokenName(), tokenTO.toString());
        }
    }

    public static boolean isAjaxRequest(HttpServletRequest request) {
        Enumeration headers = request.getHeaders("X-Requested-With");
        return Objects.nonNull(headers) && Collections.list(headers).stream().flatMap(headerValue -> Arrays.stream(headerValue.split(","))).map(String::trim).anyMatch("XMLHttpRequest"::equals);
    }

    public static String normalizeResourceURI(HttpServletRequest httpServletRequest) {
        return CsrfGuardUtils.normalizeResourceURI(httpServletRequest.getRequestURI());
    }

    public static String normalizeResourceURI(String resourceURI) {
        Object normalizedResourceURI = resourceURI.startsWith("/") ? resourceURI : "/" + resourceURI;
        normalizedResourceURI = ((String)normalizedResourceURI).replaceAll("/{2,}", "/");
        return normalizedResourceURI;
    }

    public static String readInputStreamContent(InputStream inputStream) {
        try {
            return IOUtils.toString((InputStream)inputStream, (Charset)Charset.defaultCharset());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static boolean isPermittedUserAgent(HttpServletRequest request, HttpServletResponse response, CsrfGuard csrfGuard) throws IOException {
        boolean result;
        CharSequence[] bannedUserAgentProperties = csrfGuard.getBannedUserAgentProperties().toArray(new String[0]);
        String userAgent = request.getHeader("User-Agent");
        if (bannedUserAgentProperties.length > 0 && StringUtils.containsAnyIgnoreCase((CharSequence)userAgent, (CharSequence[])bannedUserAgentProperties)) {
            LOGGER.warn("HTTP request with forbidden User-Agent: '{}'", (Object)userAgent);
            response.sendError(403, "Forbidden HTTP Client!");
            result = false;
        } else {
            result = true;
        }
        return result;
    }

    private static String httpProtocolAndDomain(String url) {
        int firstSlashAfterProtocol = url.indexOf(47, 8);
        return firstSlashAfterProtocol < 0 ? url : url.substring(0, firstSlashAfterProtocol);
    }
}

