/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime;

import java.lang.reflect.Array;

public class IntStack {
    public static final int DEFAULT_SIZE = 8;
    protected int m_countLimit;
    protected int m_countPresent;
    protected int m_maximumGrowth;
    protected int[] m_baseArray;

    public IntStack(int n, int n2) {
        this.m_countLimit = n;
        this.m_maximumGrowth = n2;
        this.m_baseArray = new int[n];
    }

    public IntStack(int n) {
        this(n, Integer.MAX_VALUE);
    }

    public IntStack() {
        this(8);
    }

    public IntStack(IntStack intStack) {
        this(intStack.m_countLimit, intStack.m_maximumGrowth);
        System.arraycopy(intStack.m_baseArray, 0, this.m_baseArray, 0, intStack.m_countPresent);
        this.m_countPresent = intStack.m_countPresent;
    }

    public IntStack(int[] nArray) {
        this(nArray.length);
        System.arraycopy(nArray, 0, this.m_baseArray, 0, nArray.length);
        this.m_countPresent = nArray.length;
    }

    private void resizeCopy(Object object, Object object2) {
        System.arraycopy(object, 0, object2, 0, Array.getLength(object));
    }

    private void growArray(int n) {
        int n2 = Math.max(n, this.m_countLimit + Math.min(this.m_countLimit, this.m_maximumGrowth));
        int[] nArray = new int[n2];
        this.resizeCopy(this.m_baseArray, nArray);
        this.m_countLimit = n2;
        this.m_baseArray = nArray;
    }

    public final void ensureCapacity(int n) {
        if (n > this.m_countLimit) {
            this.growArray(n);
        }
    }

    public void push(int n) {
        int n2 = this.getAddIndex();
        this.m_baseArray[n2] = n;
    }

    public int pop() {
        if (this.m_countPresent > 0) {
            return this.m_baseArray[--this.m_countPresent];
        }
        throw new ArrayIndexOutOfBoundsException("Attempt to pop empty stack");
    }

    public int pop(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Count must be greater than 0");
        }
        if (this.m_countPresent >= n) {
            this.m_countPresent -= n;
            return this.m_baseArray[this.m_countPresent];
        }
        throw new ArrayIndexOutOfBoundsException("Attempt to pop past end of stack");
    }

    public int peek(int n) {
        if (this.m_countPresent > n) {
            return this.m_baseArray[this.m_countPresent - n - 1];
        }
        throw new ArrayIndexOutOfBoundsException("Attempt to peek past end of stack");
    }

    public int peek() {
        return this.peek(0);
    }

    public int[] toArray() {
        int[] nArray = new int[this.m_countPresent];
        System.arraycopy(this.m_baseArray, 0, nArray, 0, this.m_countPresent);
        return nArray;
    }

    public Object clone() {
        return new IntStack(this);
    }

    private int getAddIndex() {
        int n = this.m_countPresent++;
        if (this.m_countPresent > this.m_countLimit) {
            this.growArray(this.m_countPresent);
        }
        return n;
    }

    public int size() {
        return this.m_countPresent;
    }

    public boolean isEmpty() {
        return this.m_countPresent == 0;
    }

    public void clear() {
        this.m_countPresent = 0;
    }
}

