/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.lang.reflect.Array;

public class StringArray {
    public static final int DEFAULT_SIZE = 8;
    private int m_countLimit;
    private int m_countPresent;
    private int m_maximumGrowth;
    private String[] m_baseArray;

    public StringArray(int n, int n2) {
        String[] stringArray = new String[n];
        this.m_countLimit = n;
        this.m_maximumGrowth = n2;
        this.m_baseArray = stringArray;
    }

    public StringArray(int n) {
        this(n, Integer.MAX_VALUE);
    }

    public StringArray() {
        this(8);
    }

    public StringArray(StringArray stringArray) {
        this(stringArray.m_countLimit, stringArray.m_maximumGrowth);
        System.arraycopy(stringArray.m_baseArray, 0, this.m_baseArray, 0, stringArray.m_countPresent);
        this.m_countPresent = stringArray.m_countPresent;
    }

    private void resizeCopy(Object object, Object object2) {
        System.arraycopy(object, 0, object2, 0, Array.getLength(object));
    }

    private void discardValues(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            this.m_baseArray[i] = null;
        }
    }

    private void growArray(int n) {
        int n2 = Math.max(n, this.m_countLimit + Math.min(this.m_countLimit, this.m_maximumGrowth));
        String[] stringArray = new String[n2];
        this.resizeCopy(this.m_baseArray, stringArray);
        this.m_countLimit = n2;
        this.m_baseArray = stringArray;
    }

    public final void ensureCapacity(int n) {
        if (n > this.m_countLimit) {
            this.growArray(n);
        }
    }

    public void add(String string) {
        int n = this.getAddIndex();
        this.m_baseArray[n] = string;
    }

    public void remove(int n) {
        int n2 = this.m_countPresent - n;
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("Attempt to remove too many values from array");
        }
        this.discardValues(n2, this.m_countPresent);
        this.m_countPresent = n2;
    }

    public String get(int n) {
        if (this.m_countPresent > n) {
            return this.m_baseArray[n];
        }
        throw new ArrayIndexOutOfBoundsException("Attempt to access past end of array");
    }

    public String[] toArray() {
        String[] stringArray = new String[this.m_countPresent];
        System.arraycopy(this.m_baseArray, 0, stringArray, 0, this.m_countPresent);
        return stringArray;
    }

    public Object clone() {
        return new StringArray(this);
    }

    private int getAddIndex() {
        int n = this.m_countPresent++;
        if (this.m_countPresent > this.m_countLimit) {
            this.growArray(this.m_countPresent);
        }
        return n;
    }

    public int size() {
        return this.m_countPresent;
    }

    public boolean isEmpty() {
        return this.m_countPresent == 0;
    }

    public void clear() {
        this.discardValues(0, this.m_countPresent);
        this.m_countPresent = 0;
    }
}

