/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.IOException;
import org.jibx.runtime.IXMLWriter;
import org.jibx.runtime.impl.StreamWriterBase;

public class UTF8StreamWriter
extends StreamWriterBase {
    private byte[] m_converts;

    public UTF8StreamWriter(String[] stringArray) {
        super("UTF-8", stringArray);
        this.defineNamespace(0, "");
        this.defineNamespace(1, "xml");
    }

    public UTF8StreamWriter(UTF8StreamWriter uTF8StreamWriter, String[] stringArray) {
        super(uTF8StreamWriter, stringArray);
        this.defineNamespace(0, "");
        this.defineNamespace(1, "xml");
    }

    protected void writeMarkup(String string) throws IOException {
        int n = string.length();
        this.makeSpace(n * 3);
        int n2 = this.m_fillOffset;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c > '\u007f') {
                if (c > '\u07ff') {
                    this.m_buffer[n2++] = (byte)(224 + (c >> 12));
                    this.m_buffer[n2++] = (byte)(128 + (c >> 6 & 0x3F));
                    this.m_buffer[n2++] = (byte)(128 + (c & 0x3F));
                    continue;
                }
                this.m_buffer[n2++] = (byte)(192 + (c >> 6));
                this.m_buffer[n2++] = (byte)(128 + (c & 0x3F));
                continue;
            }
            this.m_buffer[n2++] = (byte)c;
        }
        this.m_fillOffset = n2;
    }

    protected void writeMarkup(char c) throws IOException {
        this.makeSpace(3);
        if (c > '\u007f') {
            if (c > '\u07ff') {
                this.m_buffer[this.m_fillOffset++] = (byte)(224 + (c >> 12));
                this.m_buffer[this.m_fillOffset++] = (byte)(128 + (c >> 6 & 0x3F));
                this.m_buffer[this.m_fillOffset++] = (byte)(128 + (c & 0x3F));
            } else {
                this.m_buffer[this.m_fillOffset++] = (byte)(192 + (c >> 6));
                this.m_buffer[this.m_fillOffset++] = (byte)(128 + (c & 0x3F));
            }
        } else {
            this.m_buffer[this.m_fillOffset++] = (byte)c;
        }
    }

    protected void defineNamespace(int n, String string) {
        byte[] byArray;
        int n2;
        int n3 = string.length() * 3;
        if (this.m_converts == null) {
            this.m_converts = new byte[n3];
        } else if (n3 > this.m_converts.length) {
            this.m_converts = new byte[n3];
        }
        int n4 = 0;
        for (int i = 0; i < string.length(); ++i) {
            n2 = string.charAt(i);
            if (n2 > 127) {
                if (n2 > 2047) {
                    this.m_converts[n4++] = (byte)(224 + (n2 >> 12));
                    this.m_converts[n4++] = (byte)(128 + (n2 >> 6 & 0x3F));
                    this.m_converts[n4++] = (byte)(128 + (n2 & 0x3F));
                    continue;
                }
                this.m_converts[n4++] = (byte)(192 + (n2 >> 6));
                this.m_converts[n4++] = (byte)(128 + (n2 & 0x3F));
                continue;
            }
            this.m_converts[n4++] = (byte)n2;
        }
        if (n4 > 0) {
            byArray = new byte[n4 + 1];
            System.arraycopy(this.m_converts, 0, byArray, 0, n4);
            byArray[n4] = 58;
        } else {
            byArray = new byte[]{};
        }
        if (n < this.m_prefixBytes.length) {
            this.m_prefixBytes[n] = byArray;
        } else if (this.m_extensionBytes != null) {
            n -= this.m_prefixBytes.length;
            for (n2 = 0; n2 < this.m_extensionBytes.length; ++n2) {
                int n5 = this.m_extensionBytes[n2].length;
                if (n < n5) {
                    this.m_extensionBytes[n2][n] = byArray;
                    continue;
                }
                n -= n5;
            }
        } else {
            throw new IllegalArgumentException("Index out of range");
        }
    }

    protected void writeAttributeText(String string) throws IOException {
        int n = string.length();
        this.makeSpace(n * 6);
        int n2 = this.m_fillOffset;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                n2 = this.writeEntity(QUOT_ENTITY, n2);
                continue;
            }
            if (c == '&') {
                n2 = this.writeEntity(AMP_ENTITY, n2);
                continue;
            }
            if (c == '<') {
                n2 = this.writeEntity(LT_ENTITY, n2);
                continue;
            }
            if (c == '>' && i > 2 && string.charAt(i - 1) == ']' && string.charAt(i - 2) == ']') {
                this.m_buffer[n2++] = 93;
                this.m_buffer[n2++] = 93;
                n2 = this.writeEntity(GT_ENTITY, n2);
                continue;
            }
            if (c < ' ') {
                if (c != '\t' && c != '\n' && c != '\r') {
                    throw new IOException("Illegal character code 0x" + Integer.toHexString(c) + " in attribute value text");
                }
                this.m_buffer[n2++] = (byte)c;
                continue;
            }
            if (c > '\u007f') {
                if (c > '\u07ff') {
                    if (c > '\ud7ff' && (c < '\ue000' || c == '\ufffe' || c == '\uffff' || c > '\u10ffff')) {
                        throw new IOException("Illegal character code 0x" + Integer.toHexString(c) + " in attribute value text");
                    }
                    this.m_buffer[n2++] = (byte)(224 + (c >> 12));
                    this.m_buffer[n2++] = (byte)(128 + (c >> 6 & 0x3F));
                    this.m_buffer[n2++] = (byte)(128 + (c & 0x3F));
                    continue;
                }
                this.m_buffer[n2++] = (byte)(192 + (c >> 6));
                this.m_buffer[n2++] = (byte)(128 + (c & 0x3F));
                continue;
            }
            this.m_buffer[n2++] = (byte)c;
        }
        this.m_fillOffset = n2;
    }

    public void writeTextContent(String string) throws IOException {
        this.flagTextContent();
        int n = string.length();
        this.makeSpace(n * 5);
        int n2 = this.m_fillOffset;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '&') {
                n2 = this.writeEntity(AMP_ENTITY, n2);
                continue;
            }
            if (c == '<') {
                n2 = this.writeEntity(LT_ENTITY, n2);
                continue;
            }
            if (c == '>' && i > 2 && string.charAt(i - 1) == ']' && string.charAt(i - 2) == ']') {
                this.m_buffer[n2++] = 93;
                this.m_buffer[n2++] = 93;
                n2 = this.writeEntity(GT_ENTITY, n2);
                continue;
            }
            if (c < ' ') {
                if (c != '\t' && c != '\n' && c != '\r') {
                    throw new IOException("Illegal character code 0x" + Integer.toHexString(c) + " in content text");
                }
                this.m_buffer[n2++] = (byte)c;
                continue;
            }
            if (c > '\u007f') {
                if (c > '\u07ff') {
                    if (c > '\ud7ff' && (c < '\ue000' || c == '\ufffe' || c == '\uffff' || c > '\u10ffff')) {
                        throw new IOException("Illegal character code 0x" + Integer.toHexString(c) + " in content text");
                    }
                    this.m_buffer[n2++] = (byte)(224 + (c >> 12));
                    this.m_buffer[n2++] = (byte)(128 + (c >> 6 & 0x3F));
                    this.m_buffer[n2++] = (byte)(128 + (c & 0x3F));
                    continue;
                }
                this.m_buffer[n2++] = (byte)(192 + (c >> 6));
                this.m_buffer[n2++] = (byte)(128 + (c & 0x3F));
                continue;
            }
            this.m_buffer[n2++] = (byte)c;
        }
        this.m_fillOffset = n2;
    }

    public void writeCData(String string) throws IOException {
        this.flagTextContent();
        int n = string.length();
        this.makeSpace(n * 3 + 12);
        int n2 = this.m_fillOffset;
        n2 = this.writeEntity(LT_CDATASTART, n2);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '>' && i > 2 && string.charAt(i - 1) == ']' && string.charAt(i - 2) == ']') {
                throw new IOException("Sequence \"]]>\" is not allowed within CDATA section text");
            }
            if (c < ' ') {
                if (c != '\t' && c != '\n' && c != '\r') {
                    throw new IOException("Illegal character code 0x" + Integer.toHexString(c) + " in content text");
                }
                this.m_buffer[n2++] = (byte)c;
                continue;
            }
            if (c > '\u007f') {
                if (c > '\u07ff') {
                    if (c > '\ud7ff' && (c < '\ue000' || c == '\ufffe' || c == '\uffff' || c > '\u10ffff')) {
                        throw new IOException("Illegal character code 0x" + Integer.toHexString(c) + " in CDATA section text");
                    }
                    this.m_buffer[n2++] = (byte)(224 + (c >> 12));
                    this.m_buffer[n2++] = (byte)(128 + (c >> 6 & 0x3F));
                    this.m_buffer[n2++] = (byte)(128 + (c & 0x3F));
                    continue;
                }
                this.m_buffer[n2++] = (byte)(192 + (c >> 6));
                this.m_buffer[n2++] = (byte)(128 + (c & 0x3F));
                continue;
            }
            this.m_buffer[n2++] = (byte)c;
        }
        this.m_fillOffset = this.writeEntity(LT_CDATAEND, n2);
    }

    public IXMLWriter createChildWriter(String[] stringArray) {
        return new UTF8StreamWriter(this, stringArray);
    }
}

