/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshaller;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.IXMLReader;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.Utility;
import org.jibx.runtime.impl.BackFillHolder;
import org.jibx.runtime.impl.BackFillReference;
import org.jibx.runtime.impl.ITrackSourceImpl;
import org.jibx.runtime.impl.IXMLReaderFactory;

public class UnmarshallingContext
implements IUnmarshallingContext {
    private static final int INITIAL_STACK_SIZE = 20;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final IXMLReaderFactory s_readerFactory;
    private IBindingFactory m_factory;
    private IXMLReader m_reader;
    protected String[] m_unmarshallerClasses;
    protected IUnmarshaller[] m_unmarshallers;
    protected String[] m_namespaces;
    protected String[] m_names;
    protected int m_globalCount;
    protected HashMap[] m_idMaps;
    protected String[] m_idClasses;
    protected int m_stackDepth;
    protected Object[] m_objectStack;
    protected HashMap m_unmarshalMap;
    protected Integer[] m_indexes;
    protected String m_idref;
    protected Object m_userContext;
    static /* synthetic */ Class class$org$jibx$runtime$impl$UnmarshallingContext;
    static /* synthetic */ Class class$org$jibx$runtime$impl$IXMLReaderFactory;

    private static IXMLReaderFactory createReaderFactory(String string) {
        Class<?> clazz = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            try {
                clazz = classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            try {
                classLoader = (class$org$jibx$runtime$impl$UnmarshallingContext == null ? (class$org$jibx$runtime$impl$UnmarshallingContext = UnmarshallingContext.class$("org.jibx.runtime.impl.UnmarshallingContext")) : class$org$jibx$runtime$impl$UnmarshallingContext).getClassLoader();
                clazz = classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException("Unable to specified parser factory class " + string);
            }
        }
        if (!(class$org$jibx$runtime$impl$IXMLReaderFactory == null ? (class$org$jibx$runtime$impl$IXMLReaderFactory = UnmarshallingContext.class$("org.jibx.runtime.impl.IXMLReaderFactory")) : class$org$jibx$runtime$impl$IXMLReaderFactory).isAssignableFrom(clazz)) {
            throw new RuntimeException("Specified parser factory class " + string + " does not implement IXMLReaderFactory interface");
        }
        try {
            Method method = clazz.getMethod("getInstance", null);
            return (IXMLReaderFactory)method.invoke(null, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException("Specified parser factory class " + string + " does not define static getInstance() method");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Error on parser factory class " + string + " getInstance() method call: " + illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException("Error on parser factory class " + string + " getInstance() method call: " + invocationTargetException.getMessage());
        }
    }

    public UnmarshallingContext(int n, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, IBindingFactory iBindingFactory) {
        this.m_globalCount = stringArray2.length;
        this.m_unmarshallerClasses = new String[n];
        System.arraycopy(stringArray, 0, this.m_unmarshallerClasses, 0, stringArray.length);
        this.m_unmarshallers = new IUnmarshaller[n];
        this.m_namespaces = new String[n];
        System.arraycopy(stringArray2, 0, this.m_namespaces, 0, stringArray2.length);
        this.m_names = new String[n];
        System.arraycopy(stringArray3, 0, this.m_names, 0, stringArray3.length);
        this.m_idClasses = stringArray4;
        int n2 = stringArray4 == null ? 1 : stringArray4.length;
        this.m_idMaps = new HashMap[n2];
        this.m_objectStack = new Object[20];
        this.m_factory = iBindingFactory;
    }

    public UnmarshallingContext() {
        this(0, EMPTY_STRING_ARRAY, EMPTY_STRING_ARRAY, EMPTY_STRING_ARRAY, EMPTY_STRING_ARRAY, null);
    }

    public static String buildNameString(String string, String string2) {
        if (string == null || "".equals(string)) {
            return "\"" + string2 + "\"";
        }
        return "\"{" + string + "}" + string2 + "\"";
    }

    public String currentNameString() {
        return UnmarshallingContext.buildNameString(this.m_reader.getNamespace(), this.m_reader.getName());
    }

    public String buildPositionString() {
        return this.m_reader.buildPositionString();
    }

    public void throwStartTagNameError(String string, String string2) throws JiBXException {
        throw new JiBXException("Expected " + UnmarshallingContext.buildNameString(string, string2) + " start tag, found " + this.currentNameString() + " start tag " + this.buildPositionString());
    }

    public void throwEndTagNameError(String string, String string2) throws JiBXException {
        throw new JiBXException("Expected " + UnmarshallingContext.buildNameString(string, string2) + " end tag, found " + this.currentNameString() + " end tag " + this.buildPositionString());
    }

    private void advance() throws JiBXException {
        this.m_reader.nextToken();
    }

    private boolean verifyNamespace(String string) {
        if (string == null || "".equals(string)) {
            return this.m_reader.getNamespace().length() == 0;
        }
        return string.equals(this.m_reader.getNamespace());
    }

    private String getAttributeValue(String string, String string2) {
        return this.m_reader.getAttributeValue(string, string2);
    }

    public void setDocument(InputStream inputStream, String string, String string2, boolean bl) throws JiBXException {
        this.m_reader = this.m_reader == null ? s_readerFactory.createReader(inputStream, string, string2, bl) : s_readerFactory.recycleReader(this.m_reader, inputStream, string, string2);
        this.reset();
    }

    public void setDocument(InputStream inputStream, String string) throws JiBXException {
        this.setDocument(inputStream, null, string, true);
    }

    public void setDocument(Reader reader, String string, boolean bl) throws JiBXException {
        this.m_reader = this.m_reader == null ? s_readerFactory.createReader(reader, string, bl) : s_readerFactory.recycleReader(this.m_reader, reader, string);
        this.reset();
    }

    public void setDocument(Reader reader) throws JiBXException {
        this.setDocument(reader, null, true);
    }

    public void setDocument(InputStream inputStream, String string, String string2) throws JiBXException {
        this.setDocument(inputStream, string, string2, true);
    }

    public void setDocument(Reader reader, String string) throws JiBXException {
        this.setDocument(reader, string, true);
    }

    public void setDocument(IXMLReader iXMLReader) {
        this.m_reader = iXMLReader;
    }

    public void setFromContext(UnmarshallingContext unmarshallingContext) {
        this.m_factory = unmarshallingContext.m_factory;
        this.m_reader = unmarshallingContext.m_reader;
    }

    public void reset() {
        int n;
        for (n = 0; n < this.m_idMaps.length; ++n) {
            this.m_idMaps[n] = null;
        }
        for (n = this.m_globalCount; n < this.m_unmarshallers.length; ++n) {
            this.m_namespaces[n] = null;
            this.m_names[n] = null;
            this.m_unmarshallers[n] = null;
        }
        this.m_unmarshalMap = null;
        this.m_idref = null;
        for (n = 0; n < this.m_objectStack.length; ++n) {
            this.m_objectStack[n] = null;
        }
        this.m_stackDepth = 0;
        this.m_userContext = null;
    }

    public String toStart() throws JiBXException {
        if (this.m_reader.getEventType() == 2) {
            return this.m_reader.getName();
        }
        while (true) {
            this.m_reader.next();
            switch (this.m_reader.getEventType()) {
                case 2: {
                    return this.m_reader.getName();
                }
                case 3: {
                    throw new JiBXException("Expected start tag, found end tag " + this.currentNameString() + " " + this.buildPositionString());
                }
                case 1: {
                    throw new JiBXException("Expected start tag, found end of document " + this.buildPositionString());
                }
            }
        }
    }

    public String toEnd() throws JiBXException {
        if (this.m_reader.getEventType() == 3) {
            return this.m_reader.getName();
        }
        while (true) {
            this.m_reader.next();
            switch (this.m_reader.getEventType()) {
                case 2: {
                    throw new JiBXException("Expected end tag, found start tag " + this.currentNameString() + " " + this.buildPositionString());
                }
                case 3: {
                    return this.m_reader.getName();
                }
                case 1: {
                    throw new JiBXException("Expected end tag, found end of document " + this.buildPositionString());
                }
            }
        }
    }

    public int toTag() throws JiBXException {
        int n = this.m_reader.getEventType();
        while (n != 2 && n != 3) {
            n = this.m_reader.next();
        }
        return this.m_reader.getEventType();
    }

    public boolean isAt(String string, String string2) throws JiBXException {
        int n = this.m_reader.getEventType();
        while (n != 2 && n != 3) {
            n = this.m_reader.next();
        }
        return this.m_reader.getEventType() == 2 && this.m_reader.getName().equals(string2) && this.verifyNamespace(string);
    }

    public boolean hasAttribute(String string, String string2) throws JiBXException {
        if (this.m_reader.getEventType() == 2) {
            return this.getAttributeValue(string, string2) != null;
        }
        throw new JiBXException("Error parsing document " + this.buildPositionString());
    }

    public boolean hasAnyAttribute(String[] stringArray, String[] stringArray2) throws JiBXException {
        if (this.m_reader.getEventType() == 2) {
            for (int i = 0; i < stringArray2.length; ++i) {
                if (this.getAttributeValue(stringArray[i], stringArray2[i]) == null) continue;
                return true;
            }
            return false;
        }
        throw new JiBXException("Error parsing document " + this.buildPositionString());
    }

    public void checkAllowedAttributes(String[] stringArray, String[] stringArray2) throws JiBXException {
        if (this.m_reader.getEventType() == 2) {
            int n = this.m_reader.getAttributeCount();
            block0: for (int i = 0; i < n; ++i) {
                String string = this.m_reader.getAttributeName(i);
                String string2 = this.m_reader.getAttributeNamespace(i);
                int n2 = 0;
                int n3 = stringArray2.length - 1;
                while (n2 <= n3) {
                    String string3;
                    int n4 = n2 + n3 >> 1;
                    int n5 = string.compareTo(stringArray2[n4]);
                    if (n5 == 0 && (n5 = (string3 = stringArray[n4]) == null ? string2.compareTo("") : string2.compareTo(string3)) == 0) continue block0;
                    if (n5 < 0) {
                        n3 = n4 - 1;
                        continue;
                    }
                    if (n5 <= 0) continue;
                    n2 = n4 + 1;
                }
                this.throwStartTagException("Illegal attribute " + UnmarshallingContext.buildNameString(string2, string));
            }
        } else {
            throw new JiBXException("Error parsing document " + this.buildPositionString());
        }
    }

    private void matchStart(String string, String string2) throws JiBXException {
        if (this.toTag() == 2) {
            if (!this.m_reader.getName().equals(string2) || !this.verifyNamespace(string)) {
                this.throwStartTagNameError(string, string2);
            }
        } else {
            throw new JiBXException("Expected " + UnmarshallingContext.buildNameString(string, string2) + " start tag, found " + this.currentNameString() + " end tag " + this.buildPositionString());
        }
    }

    public void parseToStartTag(String string, String string2) throws JiBXException {
        this.matchStart(string, string2);
    }

    public void parsePastStartTag(String string, String string2) throws JiBXException {
        this.matchStart(string, string2);
        this.advance();
    }

    public boolean parseIfStartTag(String string, String string2) throws JiBXException {
        if (this.isAt(string, string2)) {
            this.advance();
            return true;
        }
        return false;
    }

    public void parsePastCurrentEndTag(String string, String string2) throws JiBXException {
        int n = this.toTag();
        if (n == 3) {
            if (this.m_reader.getName().equals(string2) && this.verifyNamespace(string)) {
                this.advance();
            } else {
                this.throwEndTagNameError(string, string2);
            }
        } else {
            throw new JiBXException("Expected " + UnmarshallingContext.buildNameString(string, string2) + " end tag, found " + this.currentNameString() + " start tag " + this.buildPositionString());
        }
    }

    public void parsePastEndTag(String string, String string2) throws JiBXException {
        int n = this.m_reader.getEventType();
        if (n == 2) {
            this.advance();
        }
        this.parsePastCurrentEndTag(string, string2);
    }

    public boolean isEnd() throws JiBXException {
        int n = this.m_reader.getEventType();
        while (n != 2 && n != 3) {
            n = this.m_reader.next();
        }
        return this.m_reader.getEventType() == 3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String accumulateText() throws JiBXException {
        String string = null;
        StringBuffer stringBuffer = null;
        block5: while (true) {
            switch (this.m_reader.getEventType()) {
                case 6: {
                    if (this.m_reader.getText() == null) {
                        throw new JiBXException("Unexpanded entity reference in text at " + this.buildPositionString());
                    }
                }
                case 4: 
                case 5: {
                    if (string == null) {
                        string = this.m_reader.getText();
                        break;
                    }
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(string);
                    }
                    stringBuffer.append(this.m_reader.getText());
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break block5;
                }
            }
            this.m_reader.nextToken();
        }
        if (stringBuffer != null) return stringBuffer.toString();
        if (string == null) {
            return "";
        }
        String string2 = string;
        return string2;
    }

    public String parseContentText() throws JiBXException {
        return this.accumulateText();
    }

    public String parseContentText(String string, String string2) throws JiBXException {
        String string3 = this.accumulateText();
        switch (this.m_reader.getEventType()) {
            case 3: {
                if (this.m_reader.getName().equals(string2) && this.verifyNamespace(string)) {
                    this.m_reader.nextToken();
                    return string3;
                }
                this.throwEndTagNameError(string, string2);
            }
            case 2: {
                throw new JiBXException("Expected " + UnmarshallingContext.buildNameString(string, string2) + " end tag, " + "found " + this.currentNameString() + " start tag " + this.buildPositionString());
            }
            case 1: {
                throw new JiBXException("Expected " + UnmarshallingContext.buildNameString(string, string2) + " end tag, " + "found end of document " + this.buildPositionString());
            }
        }
        return null;
    }

    public int parseContentInt(String string, String string2) throws JiBXException {
        String string3 = this.parseContentText(string, string2);
        try {
            return Utility.parseInt(string3);
        }
        catch (JiBXException jiBXException) {
            throw new JiBXException(jiBXException.getMessage() + ' ' + this.buildPositionString(), jiBXException.getRootCause());
        }
    }

    public String parseElementText(String string, String string2) throws JiBXException {
        this.parsePastStartTag(string, string2);
        return this.parseContentText(string, string2);
    }

    public String parseElementText(String string, String string2, String string3) throws JiBXException {
        if (this.parseIfStartTag(string, string2)) {
            return this.parseContentText(string, string2);
        }
        return string3;
    }

    public String attributeText(String string, String string2) throws JiBXException {
        String string3 = this.getAttributeValue(string, string2);
        if (string3 == null) {
            throw new JiBXException("Missing required attribute " + UnmarshallingContext.buildNameString(string, string2) + " " + this.buildPositionString());
        }
        return string3;
    }

    public String attributeText(String string, String string2, String string3) {
        String string4 = this.getAttributeValue(string, string2);
        if (string4 == null) {
            return string3;
        }
        return string4;
    }

    public Object findID(String string, int n) throws JiBXException {
        HashMap hashMap = this.m_idMaps[n];
        if (hashMap != null) {
            Object v = hashMap.get(string);
            if (v == null || v instanceof BackFillHolder) {
                return null;
            }
            if (this.m_idClasses == null || this.m_idClasses[n].equals(v.getClass().getName())) {
                return v;
            }
            this.throwStartTagException("IDREF element content mapped to wrong type");
        }
        return null;
    }

    public Object findDefinedID(String string, int n) throws JiBXException {
        Object object = this.findID(string, n);
        if (object == null) {
            this.throwStartTagException("ID " + string + " not defined");
        }
        return object;
    }

    public Object parseElementForwardIDREF(String string, String string2, int n) throws JiBXException {
        this.parsePastStartTag(string, string2);
        this.m_idref = this.parseContentText(string, string2);
        return this.findID(this.m_idref, n);
    }

    public Object attributeForwardIDREF(String string, String string2, int n) throws JiBXException {
        this.m_idref = this.attributeText(string, string2);
        return this.findID(this.m_idref, n);
    }

    public Object parseElementExistingIDREF(String string, String string2, int n) throws JiBXException {
        this.parsePastStartTag(string, string2);
        this.m_idref = this.parseContentText(string, string2);
        return this.findDefinedID(this.m_idref, n);
    }

    public Object attributeExistingIDREF(String string, String string2, int n) throws JiBXException {
        this.m_idref = this.attributeText(string, string2);
        return this.findDefinedID(this.m_idref, n);
    }

    public int attributeInt(String string, String string2) throws JiBXException {
        String string3 = this.attributeText(string, string2);
        try {
            return Utility.parseInt(string3);
        }
        catch (JiBXException jiBXException) {
            throw new JiBXException(jiBXException.getMessage() + ' ' + this.buildPositionString(), jiBXException.getRootCause());
        }
    }

    public int attributeInt(String string, String string2, int n) throws JiBXException {
        String string3 = this.getAttributeValue(string, string2);
        if (string3 == null) {
            return n;
        }
        try {
            return Utility.parseInt(string3);
        }
        catch (JiBXException jiBXException) {
            throw new JiBXException(jiBXException.getMessage() + ' ' + this.buildPositionString(), jiBXException.getRootCause());
        }
    }

    public int parseElementInt(String string, String string2) throws JiBXException {
        this.parsePastStartTag(string, string2);
        return this.parseContentInt(string, string2);
    }

    public int parseElementInt(String string, String string2, int n) throws JiBXException {
        if (this.parseIfStartTag(string, string2)) {
            return this.parseContentInt(string, string2);
        }
        return n;
    }

    public int convertEnum(String string, String[] stringArray, int[] nArray) throws JiBXException {
        if (string == null) {
            this.throwStartTagException("Missing required enumeration value");
        }
        try {
            return Utility.enumValue(string, stringArray, nArray);
        }
        catch (JiBXException jiBXException) {
            throw new JiBXException(jiBXException.getMessage() + ' ' + this.buildPositionString());
        }
    }

    public int convertEnum(String string, String[] stringArray, int[] nArray, int n) throws JiBXException {
        if (string == null) {
            return n;
        }
        try {
            return Utility.enumValue(string, stringArray, nArray);
        }
        catch (JiBXException jiBXException) {
            throw new JiBXException(jiBXException.getMessage() + ' ' + this.buildPositionString());
        }
    }

    public int attributeEnumeration(String string, String string2, String[] stringArray, int[] nArray) throws JiBXException {
        return this.convertEnum(this.getAttributeValue(string, string2), stringArray, nArray);
    }

    public int attributeEnumeration(String string, String string2, String[] stringArray, int[] nArray, int n) throws JiBXException {
        return this.convertEnum(this.getAttributeValue(string, string2), stringArray, nArray, n);
    }

    public int parseContentEnumeration(String string, String string2, String[] stringArray, int[] nArray) throws JiBXException {
        return this.convertEnum(this.parseContentText(string, string2), stringArray, nArray);
    }

    public int parseElementEnumeration(String string, String string2, String[] stringArray, int[] nArray, int n) throws JiBXException {
        if (this.parseIfStartTag(string, string2)) {
            String string3 = this.parseContentText(string, string2);
            return this.convertEnum(string3, stringArray, nArray, n);
        }
        return n;
    }

    public byte convertByte(String string) throws JiBXException {
        try {
            return Utility.parseByte(string);
        }
        catch (JiBXException jiBXException) {
            throw new JiBXException(jiBXException.getMessage() + ' ' + this.buildPositionString(), jiBXException.getRootCause());
        }
    }

    public byte attributeByte(String string, String string2) throws JiBXException {
        return this.convertByte(this.attributeText(string, string2));
    }

    public byte attributeByte(String string, String string2, byte by) throws JiBXException {
        String string3 = this.getAttributeValue(string, string2);
        if (string3 == null) {
            return by;
        }
        return this.convertByte(string3);
    }

    public byte parseContentByte(String string, String string2) throws JiBXException {
        return this.convertByte(this.parseContentText(string, string2));
    }

    public byte parseElementByte(String string, String string2) throws JiBXException {
        this.parsePastStartTag(string, string2);
        return this.parseContentByte(string, string2);
    }

    public byte parseElementByte(String string, String string2, byte by) throws JiBXException {
        if (this.parseIfStartTag(string, string2)) {
            return this.convertByte(this.parseContentText(string, string2));
        }
        return by;
    }

    public short convertShort(String string) throws JiBXException {
        try {
            return Utility.parseShort(string);
        }
        catch (JiBXException jiBXException) {
            throw new JiBXException(jiBXException.getMessage() + ' ' + this.buildPositionString(), jiBXException.getRootCause());
        }
    }

    public short attributeShort(String string, String string2) throws JiBXException {
        return this.convertShort(this.attributeText(string, string2));
    }

    public short attributeShort(String string, String string2, short s) throws JiBXException {
        String string3 = this.getAttributeValue(string, string2);
        if (string3 == null) {
            return s;
        }
        return this.convertShort(string3);
    }

    public short parseContentShort(String string, String string2) throws JiBXException {
        return this.convertShort(this.parseContentText(string, string2));
    }

    public short parseElementShort(String string, String string2) throws JiBXException {
        this.parsePastStartTag(string, string2);
        return this.parseContentShort(string, string2);
    }

    public short parseElementShort(String string, String string2, short s) throws JiBXException {
        if (this.parseIfStartTag(string, string2)) {
            return this.convertShort(this.parseContentText(string, string2));
        }
        return s;
    }

    public char convertChar(String string) throws JiBXException {
        try {
            return Utility.parseChar(string);
        }
        catch (JiBXException jiBXException) {
            throw new JiBXException(jiBXException.getMessage() + ' ' + this.buildPositionString(), jiBXException.getRootCause());
        }
    }

    public char attributeChar(String string, String string2) throws JiBXException {
        return this.convertChar(this.attributeText(string, string2));
    }

    public char attributeChar(String string, String string2, char c) throws JiBXException {
        String string3 = this.getAttributeValue(string, string2);
        if (string3 == null) {
            return c;
        }
        return this.convertChar(string3);
    }

    public char parseContentChar(String string, String string2) throws JiBXException {
        return this.convertChar(this.parseContentText(string, string2));
    }

    public char parseElementChar(String string, String string2) throws JiBXException {
        this.parsePastStartTag(string, string2);
        return this.parseContentChar(string, string2);
    }

    public char parseElementChar(String string, String string2, char c) throws JiBXException {
        if (this.parseIfStartTag(string, string2)) {
            return this.convertChar(this.parseContentText(string, string2));
        }
        return c;
    }

    public long convertLong(String string) throws JiBXException {
        try {
            return Utility.parseLong(string);
        }
        catch (JiBXException jiBXException) {
            throw new JiBXException(jiBXException.getMessage() + ' ' + this.buildPositionString(), jiBXException.getRootCause());
        }
    }

    public long attributeLong(String string, String string2) throws JiBXException {
        return this.convertLong(this.attributeText(string, string2));
    }

    public long attributeLong(String string, String string2, long l) throws JiBXException {
        String string3 = this.getAttributeValue(string, string2);
        if (string3 == null) {
            return l;
        }
        return this.convertLong(string3);
    }

    public long parseElementLong(String string, String string2) throws JiBXException {
        this.parsePastStartTag(string, string2);
        return this.convertLong(this.parseContentText(string, string2));
    }

    public long parseElementLong(String string, String string2, long l) throws JiBXException {
        if (this.parseIfStartTag(string, string2)) {
            return this.convertLong(this.parseContentText(string, string2));
        }
        return l;
    }

    public boolean convertBoolean(String string) throws JiBXException {
        if ("true".equals(string) || "1".equals(string)) {
            return true;
        }
        if ("false".equals(string) || "0".equals(string)) {
            return false;
        }
        throw new JiBXException("Invalid boolean value " + this.buildPositionString());
    }

    public boolean attributeBoolean(String string, String string2) throws JiBXException {
        return this.convertBoolean(this.attributeText(string, string2));
    }

    public boolean attributeBoolean(String string, String string2, boolean bl) throws JiBXException {
        String string3 = this.getAttributeValue(string, string2);
        if (string3 == null) {
            return bl;
        }
        return this.convertBoolean(string3);
    }

    public boolean parseElementBoolean(String string, String string2) throws JiBXException {
        this.parsePastStartTag(string, string2);
        return this.convertBoolean(this.parseContentText(string, string2));
    }

    public boolean parseElementBoolean(String string, String string2, boolean bl) throws JiBXException {
        if (this.parseIfStartTag(string, string2)) {
            return this.convertBoolean(this.parseContentText(string, string2));
        }
        return bl;
    }

    public float convertFloat(String string) throws JiBXException {
        try {
            return Utility.parseFloat(string);
        }
        catch (JiBXException jiBXException) {
            throw new JiBXException(jiBXException.getMessage() + ' ' + this.buildPositionString(), jiBXException.getRootCause());
        }
    }

    public float attributeFloat(String string, String string2) throws JiBXException {
        return this.convertFloat(this.attributeText(string, string2));
    }

    public float attributeFloat(String string, String string2, float f) throws JiBXException {
        String string3 = this.getAttributeValue(string, string2);
        if (string3 == null) {
            return f;
        }
        return this.convertFloat(string3);
    }

    public float parseElementFloat(String string, String string2) throws JiBXException {
        this.parsePastStartTag(string, string2);
        return this.convertFloat(this.parseContentText(string, string2));
    }

    public float parseElementFloat(String string, String string2, float f) throws JiBXException {
        if (this.parseIfStartTag(string, string2)) {
            return this.convertFloat(this.parseContentText(string, string2));
        }
        return f;
    }

    public double convertDouble(String string) throws JiBXException {
        try {
            return Utility.parseDouble(string);
        }
        catch (JiBXException jiBXException) {
            throw new JiBXException(jiBXException.getMessage() + ' ' + this.buildPositionString(), jiBXException.getRootCause());
        }
    }

    public double attributeDouble(String string, String string2) throws JiBXException {
        return this.convertDouble(this.attributeText(string, string2));
    }

    public double attributeDouble(String string, String string2, double d) throws JiBXException {
        String string3 = this.getAttributeValue(string, string2);
        if (string3 == null) {
            return d;
        }
        return this.convertDouble(string3);
    }

    public double parseElementDouble(String string, String string2) throws JiBXException {
        this.parsePastStartTag(string, string2);
        return this.convertDouble(this.parseContentText(string, string2));
    }

    public double parseElementDouble(String string, String string2, double d) throws JiBXException {
        if (this.parseIfStartTag(string, string2)) {
            return this.convertDouble(this.parseContentText(string, string2));
        }
        return d;
    }

    public Date convertDate(String string) throws JiBXException {
        try {
            return new Date(Utility.parseDateTime(string));
        }
        catch (JiBXException jiBXException) {
            throw new JiBXException(jiBXException.getMessage() + ' ' + this.buildPositionString(), jiBXException.getRootCause());
        }
    }

    public Date attributeDate(String string, String string2) throws JiBXException {
        return this.convertDate(this.attributeText(string, string2));
    }

    public Date attributeDate(String string, String string2, Date date) throws JiBXException {
        String string3 = this.getAttributeValue(string, string2);
        if (string3 == null) {
            return date;
        }
        return this.convertDate(string3);
    }

    public Date parseElementDate(String string, String string2) throws JiBXException {
        this.parsePastStartTag(string, string2);
        return this.convertDate(this.parseContentText(string, string2));
    }

    public Date parseElementDate(String string, String string2, Date date) throws JiBXException {
        if (this.parseIfStartTag(string, string2)) {
            return this.convertDate(this.parseContentText(string, string2));
        }
        return date;
    }

    public void registerBackFill(String string, int n, BackFillReference backFillReference) throws JiBXException {
        Object v;
        HashMap<String, BackFillHolder> hashMap = this.m_idMaps[n];
        if (hashMap == null) {
            this.m_idMaps[n] = hashMap = new HashMap<String, BackFillHolder>();
        }
        if ((v = hashMap.get(string)) == null) {
            String string2 = this.m_idClasses == null ? null : this.m_idClasses[n];
            BackFillHolder backFillHolder = new BackFillHolder(string2);
            hashMap.put(string, backFillHolder);
            backFillHolder.addBackFill(backFillReference);
        } else if (v instanceof BackFillHolder) {
            ((BackFillHolder)v).addBackFill(backFillReference);
        } else {
            throw new JiBXException("Internal operation error (back fill error) " + this.buildPositionString());
        }
    }

    public void registerBackFill(int n, BackFillReference backFillReference) throws JiBXException {
        this.registerBackFill(this.m_idref, n, backFillReference);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void defineID(String string, int n, Object object) throws JiBXException {
        Object object2;
        HashMap<String, Object> hashMap = this.m_idMaps[n];
        if (hashMap == null) {
            this.m_idMaps[n] = hashMap = new HashMap<String, Object>();
        }
        if ((object2 = hashMap.put(string, object)) instanceof BackFillHolder) {
            BackFillHolder backFillHolder = (BackFillHolder)object2;
            String string2 = backFillHolder.getExpectedClass();
            if (string2 != null && !string2.equals(object.getClass().getName())) throw new JiBXException("ID object has wrong type " + this.buildPositionString());
            backFillHolder.defineValue(object);
            return;
        } else {
            if (object2 == null) return;
            throw new JiBXException("Duplicate ID definition " + this.buildPositionString());
        }
    }

    protected void mapUnmarshalling(int n) {
        Object v = this.m_unmarshalMap.get(this.m_names[n]);
        if (v instanceof Integer) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(v);
            arrayList.add(this.m_indexes[n]);
            this.m_unmarshalMap.put(this.m_names[n], arrayList);
        } else if (v instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)v;
            arrayList.add(this.m_indexes[n]);
        } else {
            this.m_unmarshalMap.put(this.m_names[n], this.m_indexes[n]);
        }
    }

    public void addUnmarshalling(int n, String string, String string2, String string3) {
        this.m_namespaces[n] = string;
        this.m_names[n] = string2;
        this.m_unmarshallerClasses[n] = string3;
        if (this.m_unmarshalMap != null && string2 != null) {
            this.mapUnmarshalling(n);
        }
    }

    public void removeUnmarshalling(int n) {
        if (this.m_unmarshalMap != null && this.m_names[n] != null) {
            Object v = this.m_unmarshalMap.get(this.m_names[n]);
            if (v instanceof Integer) {
                this.m_unmarshalMap.remove(this.m_names[n]);
            } else if (v instanceof ArrayList) {
                ArrayList arrayList = (ArrayList)v;
                arrayList.remove(arrayList.indexOf(this.m_indexes[n]));
            }
        }
        this.m_namespaces[n] = null;
        this.m_names[n] = null;
        this.m_unmarshallers[n] = null;
        this.m_unmarshallerClasses[n] = null;
    }

    public IUnmarshaller getUnmarshaller(int n) throws JiBXException {
        if (this.m_unmarshallers[n] == null) {
            String string = this.m_unmarshallerClasses[n];
            if (string == null) {
                throw new JiBXException("No unmarshaller defined for class at index " + n);
            }
            try {
                Object object;
                Class<?> clazz = null;
                ClassLoader classLoader = null;
                if (this.m_factory != null) {
                    classLoader = this.m_factory.getClass().getClassLoader();
                    try {
                        clazz = classLoader.loadClass(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (clazz == null) {
                    ClassLoader classLoader2;
                    object = Thread.currentThread().getContextClassLoader();
                    if (object != null) {
                        try {
                            clazz = ((ClassLoader)object).loadClass(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    if (clazz == null && (classLoader2 = (class$org$jibx$runtime$impl$UnmarshallingContext == null ? (class$org$jibx$runtime$impl$UnmarshallingContext = UnmarshallingContext.class$("org.jibx.runtime.impl.UnmarshallingContext")) : class$org$jibx$runtime$impl$UnmarshallingContext).getClassLoader()) != classLoader && classLoader2 != object) {
                        try {
                            clazz = classLoader2.loadClass(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                }
                if (clazz == null) {
                    throw new JiBXException("Unable to load unmarshaller class " + string);
                }
                this.m_unmarshallers[n] = object = (IUnmarshaller)clazz.newInstance();
            }
            catch (JiBXException jiBXException) {
                throw jiBXException;
            }
            catch (Exception exception) {
                throw new JiBXException("Unable to create unmarshaller of class " + string + ":", exception);
            }
        }
        return this.m_unmarshallers[n];
    }

    public IUnmarshaller getUnmarshaller(String string, String string2) throws JiBXException {
        Object v;
        if (this.m_unmarshalMap == null) {
            this.m_unmarshalMap = new HashMap();
            this.m_indexes = new Integer[this.m_names.length];
            for (int i = 0; i < this.m_names.length; ++i) {
                this.m_indexes[i] = new Integer(i);
                if (this.m_names[i] == null) continue;
                this.mapUnmarshalling(i);
            }
        }
        if ((v = this.m_unmarshalMap.get(string2)) instanceof Integer) {
            int n = (Integer)v;
            String string3 = this.m_namespaces[n];
            if (string == string3 || string == null && string3.length() == 0 || string3 == null && string.length() == 0 || string != null && string.equals(string3)) {
                return this.getUnmarshaller(n);
            }
        } else if (v instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)v;
            for (int i = 0; i < arrayList.size(); ++i) {
                int n = (Integer)arrayList.get(i);
                String string4 = this.m_namespaces[n];
                if (!(string == string4 || string == null && string4.length() == 0 || string4 == null && string.length() == 0) && (string == null || !string.equals(string4))) continue;
                return this.getUnmarshaller(n);
            }
        }
        return null;
    }

    public Object unmarshalOptionalElement() throws JiBXException {
        IUnmarshaller iUnmarshaller;
        int n = this.toTag();
        if (n == 2 && (iUnmarshaller = this.getUnmarshaller(this.m_reader.getNamespace(), this.m_reader.getName())) != null) {
            return iUnmarshaller.unmarshal(null, this);
        }
        return null;
    }

    public Object unmarshalElement(Class clazz) throws JiBXException {
        String string = this.toStart();
        IUnmarshaller iUnmarshaller = this.getUnmarshaller(this.m_reader.getNamespace(), string);
        if (iUnmarshaller == null) {
            throw new JiBXException("No unmarshaller for element " + this.currentNameString() + " " + this.buildPositionString());
        }
        Object object = iUnmarshaller.unmarshal(null, this);
        if (!clazz.isInstance(object)) {
            throw new JiBXException("Element " + string + " not compatible with expected type " + clazz.getName() + " " + this.buildPositionString());
        }
        return object;
    }

    public Object unmarshalElement() throws JiBXException {
        String string = this.toStart();
        IUnmarshaller iUnmarshaller = this.getUnmarshaller(this.m_reader.getNamespace(), string);
        if (iUnmarshaller == null) {
            throw new JiBXException("No unmarshaller for element " + this.currentNameString() + " " + this.buildPositionString());
        }
        return iUnmarshaller.unmarshal(null, this);
    }

    public void parsePastElement(String string, String string2) throws JiBXException {
        this.parsePastStartTag(string, string2);
        int n = 0;
        while (true) {
            switch (this.m_reader.getEventType()) {
                case 3: {
                    if (n == 0) {
                        if (this.m_reader.getName().equals(string2) && this.verifyNamespace(string)) {
                            this.m_reader.nextToken();
                            return;
                        }
                        this.throwEndTagNameError(string, string2);
                        break;
                    }
                    --n;
                    break;
                }
                case 2: {
                    ++n;
                    break;
                }
            }
            this.m_reader.nextToken();
        }
    }

    public String getElementName() throws JiBXException {
        int n = this.m_reader.getEventType();
        if (n == 2 || n == 3) {
            return this.m_reader.getName();
        }
        return null;
    }

    public String getElementNamespace() throws JiBXException {
        int n = this.m_reader.getEventType();
        if (n == 2 || n == 3) {
            return this.m_reader.getNamespace();
        }
        return null;
    }

    public void throwStartTagException(String string) throws JiBXException {
        throw new JiBXException(string + " at tag " + this.currentNameString() + this.buildPositionString());
    }

    public void throwStartTagException(String string, Exception exception) throws JiBXException {
        throw new JiBXException(string + " at tag " + this.currentNameString() + this.buildPositionString(), exception);
    }

    public void throwException(String string) throws JiBXException {
        throw new JiBXException(string + " " + this.buildPositionString());
    }

    public void throwException(String string, Exception exception) throws JiBXException {
        throw new JiBXException(string + " " + this.buildPositionString(), exception);
    }

    public Object unmarshalDocument(InputStream inputStream, String string) throws JiBXException {
        this.setDocument(inputStream, string);
        return this.unmarshalElement();
    }

    public Object unmarshalDocument(Reader reader) throws JiBXException {
        this.setDocument(reader);
        return this.unmarshalElement();
    }

    public Object unmarshalDocument(InputStream inputStream, String string, String string2) throws JiBXException {
        this.setDocument(inputStream, string, string2);
        return this.unmarshalElement();
    }

    public Object unmarshalDocument(Reader reader, String string) throws JiBXException {
        this.setDocument(reader, string);
        return this.unmarshalElement();
    }

    public IBindingFactory getFactory() {
        return this.m_factory;
    }

    public String getDocumentName() {
        return this.m_reader.getDocumentName();
    }

    public String getInputEncoding() {
        return this.m_reader.getInputEncoding();
    }

    public void setUserContext(Object object) {
        this.m_userContext = object;
    }

    public Object getUserContext() {
        return this.m_userContext;
    }

    public void pushObject(Object object) {
        int n = this.m_stackDepth;
        if (n >= this.m_objectStack.length) {
            Object[] objectArray = new Object[n * 2];
            System.arraycopy(this.m_objectStack, 0, objectArray, 0, n);
            this.m_objectStack = objectArray;
        }
        this.m_objectStack[n] = object;
        ++this.m_stackDepth;
    }

    public void pushTrackedObject(Object object) {
        this.pushObject(object);
        if (object instanceof ITrackSourceImpl) {
            ((ITrackSourceImpl)object).jibx_setSource(this.m_reader.getDocumentName(), this.m_reader.getLineNumber(), this.m_reader.getColumnNumber());
        }
    }

    public void popObject() throws JiBXException {
        if (this.m_stackDepth > 0) {
            --this.m_stackDepth;
        } else {
            throw new JiBXException("No object on stack");
        }
    }

    public int getStackDepth() {
        return this.m_stackDepth;
    }

    public Object getStackObject(int n) {
        if (n >= 0 && n < this.m_stackDepth) {
            return this.m_objectStack[this.m_stackDepth - n - 1];
        }
        throw new ArrayIndexOutOfBoundsException("Depth " + n + " is out of range");
    }

    public Object getStackTop() {
        if (this.m_stackDepth > 0) {
            return this.m_objectStack[this.m_stackDepth - 1];
        }
        return null;
    }

    public int getActiveNamespaceCount() {
        try {
            return this.m_reader.getNamespaceCount(this.m_reader.getNestingDepth());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalStateException("Internal error: " + illegalArgumentException.getMessage());
        }
    }

    public String getActiveNamespaceUri(int n) {
        return this.m_reader.getNamespaceUri(n);
    }

    public String getActiveNamespacePrefix(int n) {
        return this.m_reader.getNamespacePrefix(n);
    }

    public void skipElement() throws JiBXException {
        if (!this.isEnd()) {
            this.next();
            int n = 1;
            while (n > 0) {
                n = this.isEnd() ? --n : ++n;
                this.next();
            }
        }
    }

    public int next() throws JiBXException {
        return this.m_reader.next();
    }

    public int nextToken() throws JiBXException {
        return this.m_reader.nextToken();
    }

    public int currentEvent() throws JiBXException {
        return this.m_reader.getEventType();
    }

    public String getName() {
        return this.m_reader.getName();
    }

    public String getNamespace() {
        return this.m_reader.getNamespace();
    }

    public String getPrefix() {
        return this.m_reader.getPrefix();
    }

    public int getAttributeCount() {
        return this.m_reader.getAttributeCount();
    }

    public String getAttributeName(int n) {
        return this.m_reader.getAttributeName(n);
    }

    public String getAttributeNamespace(int n) {
        return this.m_reader.getAttributeNamespace(n);
    }

    public String getAttributePrefix(int n) {
        return this.m_reader.getAttributePrefix(n);
    }

    public String getAttributeValue(int n) {
        return this.m_reader.getAttributeValue(n);
    }

    public int getNamespaceCount() {
        try {
            int n = this.m_reader.getNestingDepth();
            return this.m_reader.getNamespaceCount(n) - this.m_reader.getNamespaceCount(n - 1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalStateException("Internal error: " + illegalArgumentException.getMessage());
        }
    }

    public String getNamespaceUri(int n) {
        int n2 = this.m_reader.getNamespaceCount(this.m_reader.getNestingDepth() - 1);
        return this.m_reader.getNamespaceUri(n2 + n);
    }

    public String getNamespacePrefix(int n) {
        int n2 = this.m_reader.getNamespaceCount(this.m_reader.getNestingDepth() - 1);
        return this.m_reader.getNamespacePrefix(n2 + n);
    }

    public String getNamespaceUri(String string) {
        return this.m_reader.getNamespace(string);
    }

    public String getText() {
        return this.m_reader.getText();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string = System.getProperty("org.jibx.runtime.impl.parser");
        if (string == null) {
            IXMLReaderFactory iXMLReaderFactory = null;
            try {
                iXMLReaderFactory = UnmarshallingContext.createReaderFactory("org.jibx.runtime.impl.XMLPullReaderFactory");
            }
            catch (Throwable throwable) {
                iXMLReaderFactory = UnmarshallingContext.createReaderFactory("org.jibx.runtime.impl.StAXReaderFactory");
            }
            s_readerFactory = iXMLReaderFactory;
        } else {
            s_readerFactory = UnmarshallingContext.createReaderFactory(string);
        }
    }
}

