/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.comments.util;

import java.util.Comparator;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.comments.Comment;

public class TopicComparator
implements Comparator<Comment> {
    private static final Logger log = Logger.getLogger(TopicComparator.class);

    @Override
    public int compare(Comment msg1, Comment msg2) {
        int level2;
        int level1 = msg1.getCommentLevel();
        int lessLevel = level1 > (level2 = msg2.getCommentLevel()) ? level2 : level1;
        for (int compareLevel = 0; compareLevel <= lessLevel; ++compareLevel) {
            Comment parent1 = msg1;
            Comment parent2 = msg2;
            level2 = msg2.getCommentLevel();
            for (level1 = msg1.getCommentLevel(); level1 > compareLevel; level1 = (short)(level1 - 1)) {
                if (parent1 == null) {
                    log.error((Object)("Comment " + parent1 + " level " + (short)level1 + " has null parent"));
                    return 0;
                }
                parent1 = parent1.getParent();
            }
            while (level2 > compareLevel) {
                if (parent2 == null) {
                    log.error((Object)("Comment " + parent2 + " level " + (short)level2 + " has null parent"));
                    return 0;
                }
                parent2 = parent2.getParent();
                level2 = (short)(level2 - 1);
            }
            if (parent1 != parent2) {
                return this.compareUids(compareLevel, parent1, parent2);
            }
            if (compareLevel != lessLevel) continue;
            if (msg1.getCommentLevel() != msg2.getCommentLevel()) {
                return msg1.getCommentLevel() - msg2.getCommentLevel();
            }
            return this.compareUids(compareLevel, msg1, parent2);
        }
        return msg1.getUpdated().before(msg2.getUpdated()) ? -1 : 1;
    }

    protected int compareUids(int compareLevel, Comment c1, Comment c2) {
        if (compareLevel <= 2) {
            return c1.getUid() < c2.getUid() ? 1 : -1;
        }
        return c1.getUid() > c2.getUid() ? 1 : -1;
    }
}

