/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.integration.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import oauth.signpost.exception.OAuthException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.imsglobal.pox.IMSPOXRequest;
import org.lamsfoundation.lams.gradebook.GradebookUserLesson;
import org.lamsfoundation.lams.gradebook.service.IGradebookService;
import org.lamsfoundation.lams.integration.ExtCourseClassMap;
import org.lamsfoundation.lams.integration.ExtServer;
import org.lamsfoundation.lams.integration.ExtServerLessonMap;
import org.lamsfoundation.lams.integration.ExtServerToolAdapterMap;
import org.lamsfoundation.lams.integration.ExtUserUseridMap;
import org.lamsfoundation.lams.integration.UserInfoFetchException;
import org.lamsfoundation.lams.integration.UserInfoValidationException;
import org.lamsfoundation.lams.integration.dto.ExtGroupDTO;
import org.lamsfoundation.lams.integration.security.RandomPasswordGenerator;
import org.lamsfoundation.lams.integration.service.IIntegrationService;
import org.lamsfoundation.lams.integration.util.GroupInfoFetchException;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.timezone.service.ITimezoneService;
import org.lamsfoundation.lams.tool.service.ILamsCoreToolService;
import org.lamsfoundation.lams.usermanagement.AuthenticationMethod;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationState;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.UserOrganisation;
import org.lamsfoundation.lams.usermanagement.UserOrganisationRole;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.CSVUtil;
import org.lamsfoundation.lams.util.HashUtil;
import org.lamsfoundation.lams.util.JsonUtil;
import org.lamsfoundation.lams.util.LanguageUtil;
import org.lamsfoundation.lams.util.ValidationUtil;
import org.lamsfoundation.lams.util.WebUtil;

public class IntegrationService
implements IIntegrationService {
    private static Logger log = Logger.getLogger(IntegrationService.class);
    private IGradebookService gradebookService;
    private IUserManagementService service;
    private ILessonService lessonService;
    private ILamsCoreToolService toolService;
    private ITimezoneService timezoneService;

    @Override
    public ExtServer getExtServer(String serverId) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("serverid", serverId);
        List list = this.service.findByProperties(ExtServer.class, properties);
        if (list == null || list.size() == 0) {
            return null;
        }
        return (ExtServer)list.get(0);
    }

    @Override
    public ExtCourseClassMap getExtCourseClassMap(Integer sid, String extCourseId) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("courseid", extCourseId);
        properties.put("extServer.sid", sid);
        List list = this.service.findByProperties(ExtCourseClassMap.class, properties);
        if (list == null || list.size() == 0) {
            return null;
        }
        return (ExtCourseClassMap)list.get(0);
    }

    @Override
    public ExtCourseClassMap getExtCourseClassMap(ExtServer extServer, ExtUserUseridMap userMap, String extCourseId, String prettyCourseName, String method, Boolean prefix) throws UserInfoValidationException {
        String courseName = "";
        courseName = prettyCourseName != null ? prettyCourseName : extCourseId;
        Boolean isTeacher = StringUtils.equals((String)method, (String)"author") || StringUtils.equals((String)method, (String)"monitor");
        return this.getExtCourseClassMap(extServer, userMap, extCourseId, courseName, this.service.getRootOrganisation().getOrganisationId().toString(), isTeacher, prefix);
    }

    @Override
    public ExtCourseClassMap getExtCourseClassMap(ExtServer extServer, ExtUserUseridMap userMap, String extCourseId, String prettyCourseName, String method) throws UserInfoValidationException {
        return this.getExtCourseClassMap(extServer, userMap, extCourseId, prettyCourseName, method, true);
    }

    @Override
    public ExtCourseClassMap getExtCourseClassMap(ExtServer extServer, ExtUserUseridMap userMap, String extCourseId, String extCourseName, String parentOrgId, Boolean isTeacher, Boolean prefix) throws UserInfoValidationException {
        Organisation org;
        User user = userMap.getUser();
        ExtCourseClassMap extCourseClassMap = this.getExtCourseClassMap(extServer.getSid(), extCourseId);
        if (extCourseClassMap == null) {
            extCourseClassMap = this.createExtCourseClassMap(extServer, user.getUserId(), extCourseId, extCourseName, parentOrgId, prefix);
            org = extCourseClassMap.getOrganisation();
        } else {
            String requestedCourseName;
            org = extCourseClassMap.getOrganisation();
            String string = requestedCourseName = prefix != false ? this.buildName(extServer.getPrefix(), extCourseName) : extCourseName;
            if (extCourseName != null && !org.getName().equals(requestedCourseName)) {
                if (!ValidationUtil.isOrgNameValid(requestedCourseName)) {
                    throw new UserInfoValidationException("Can't create organisation due to validation error: organisation name cannot contain any of these characters < > ^ * @ % $. External server:" + extServer.getServerid() + ", orgId:" + extCourseId + ", orgName:" + requestedCourseName);
                }
                org.setName(requestedCourseName);
                this.service.updateOrganisationAndWorkspaceFolderNames(org);
            }
        }
        this.updateUserRoles(user, org, isTeacher);
        return extCourseClassMap;
    }

    @Override
    public ExtCourseClassMap createExtCourseClassMap(ExtServer extServer, Integer userId, String extCourseId, String extCourseName, String parentOrgId, Boolean prefix) throws UserInfoValidationException {
        User user = (User)this.service.findById(User.class, userId);
        Organisation org = this.createOrganisation(extServer, user, extCourseId, extCourseName, parentOrgId, prefix);
        ExtCourseClassMap extCourseClassMap = new ExtCourseClassMap();
        extCourseClassMap.setCourseid(extCourseId);
        extCourseClassMap.setExtServer(extServer);
        extCourseClassMap.setOrganisation(org);
        this.service.save(extCourseClassMap);
        return extCourseClassMap;
    }

    private void updateUserRoles(User user, Organisation org, Boolean isTeacher) {
        UserOrganisation uo = this.service.getUserOrganisation(user.getUserId(), org.getOrganisationId());
        if (uo == null) {
            uo = new UserOrganisation(user, org);
            this.service.save(uo);
            user.addUserOrganisation(uo);
            this.service.saveUser(user);
        }
        Integer[] roles = isTeacher != false ? new Integer[]{Role.ROLE_AUTHOR, Role.ROLE_MONITOR, Role.ROLE_LEARNER} : new Integer[]{Role.ROLE_LEARNER};
        for (Integer roleId : roles) {
            if (this.service.hasRoleInOrganisation(user, roleId, org)) continue;
            UserOrganisationRole uor = new UserOrganisationRole(uo, (Role)this.service.findById(Role.class, roleId));
            this.service.save(uor);
            uo.addUserOrganisationRole(uor);
            this.service.save(uo);
        }
    }

    @Override
    public List<ExtUserUseridMap> getExtUserUseridMapByExtServer(ExtServer extServer) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("extServer.sid", extServer.getSid());
        List list = this.service.findByProperties(ExtUserUseridMap.class, properties);
        return list;
    }

    @Override
    public ExtUserUseridMap getExtUserUseridMap(ExtServer extServer, String extUsername, boolean prefix) throws UserInfoFetchException, UserInfoValidationException {
        ExtUserUseridMap extUserUseridMap = this.getExistingExtUserUseridMap(extServer, extUsername);
        if (extUserUseridMap == null) {
            String[] userData = this.getUserDataFromExtServer(extServer, extUsername);
            String salt = HashUtil.salt();
            String password = HashUtil.sha256(RandomPasswordGenerator.nextPassword(10), salt);
            return this.createExtUserUseridMap(extServer, extUsername, password, salt, userData, prefix);
        }
        return extUserUseridMap;
    }

    @Override
    public ExtUserUseridMap getExtUserUseridMap(ExtServer extServer, String extUsername) throws UserInfoFetchException, UserInfoValidationException {
        return this.getExtUserUseridMap(extServer, extUsername, true);
    }

    @Override
    public ExtUserUseridMap getExistingExtUserUseridMap(ExtServer extServer, String extUsername) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("extServer.sid", extServer.getSid());
        properties.put("extUsername", extUsername);
        List list = this.service.findByProperties(ExtUserUseridMap.class, properties);
        if (list == null || list.size() == 0) {
            return null;
        }
        return (ExtUserUseridMap)list.get(0);
    }

    @Override
    public ExtUserUseridMap getImplicitExtUserUseridMap(ExtServer extServer, String extUsername, String password, String salt, String firstName, String lastName, String email) throws UserInfoValidationException {
        ExtUserUseridMap extUserUseridMap = this.getExistingExtUserUseridMap(extServer, extUsername);
        if (extUserUseridMap == null) {
            String defaultLocale = LanguageUtil.getDefaultLocale().getLocaleName();
            String defaultCountry = LanguageUtil.getDefaultCountry();
            String[] userData = new String[]{"", firstName, lastName, "", "", "", "", defaultCountry, "", "", "", email, defaultLocale};
            return this.createExtUserUseridMap(extServer, extUsername, password, salt, userData, false);
        }
        return extUserUseridMap;
    }

    @Override
    public ExtUserUseridMap getImplicitExtUserUseridMap(ExtServer extServer, String extUsername, String firstName, String lastName, String locale, String country, String email, boolean prefix, boolean isUpdateUserDetails) throws UserInfoValidationException {
        ExtUserUseridMap extUserUseridMap = this.getExistingExtUserUseridMap(extServer, extUsername);
        if (extUserUseridMap == null) {
            String[] userData = new String[]{"", firstName, lastName, "", "", "", "", country, "", "", "", email, locale};
            String salt = HashUtil.salt();
            String password = HashUtil.sha256(RandomPasswordGenerator.nextPassword(10), salt);
            return this.createExtUserUseridMap(extServer, extUsername, password, salt, userData, prefix);
        }
        if (isUpdateUserDetails) {
            User user = extUserUseridMap.getUser();
            if (StringUtils.isNotBlank((String)firstName) && !ValidationUtil.isFirstLastNameValid(firstName)) {
                throw new UserInfoValidationException("Can't update user details due to validation error: First name contains invalid characters. External server:" + extServer.getServerid() + ", Username:" + user.getLogin() + ", firstName:" + firstName + ", lastName:" + lastName);
            }
            if (StringUtils.isNotBlank((String)lastName) && !ValidationUtil.isFirstLastNameValid(lastName)) {
                throw new UserInfoValidationException("Can't update user details due to validation error: Last name contains invalid characters. External server:" + extServer.getServerid() + ", Username:" + user.getLogin() + ", firstName:" + firstName + ", lastName:" + lastName);
            }
            if (StringUtils.isNotBlank((String)email) && !ValidationUtil.isEmailValid(email)) {
                throw new UserInfoValidationException("Can't update user details due to validation error: Email format is invalid. External server:" + extServer.getServerid() + ", Username:" + user.getLogin() + ", firstName:" + firstName + ", lastName:" + lastName);
            }
            user.setFirstName(firstName);
            user.setLastName(lastName);
            user.setEmail(email);
            user.setModifiedDate(new Date());
            user.setLocale(LanguageUtil.getSupportedLocaleByNameOrLanguageCode(locale));
            user.setCountry(LanguageUtil.getSupportedCountry(country));
            this.service.saveUser(user);
            return extUserUseridMap;
        }
        return extUserUseridMap;
    }

    private Organisation createOrganisation(ExtServer extServer, User user, String extCourseId, String extCourseName, String parentOrgId, Boolean prefix) throws UserInfoValidationException {
        String orgName;
        Organisation org = new Organisation();
        String string = orgName = prefix != false ? this.buildName(extServer.getPrefix(), extCourseName) : extCourseName;
        if (StringUtils.isNotBlank((String)orgName) && !ValidationUtil.isOrgNameValid(orgName)) {
            throw new UserInfoValidationException("Can't create organisation due to validation error: organisation name cannot contain any of these characters < > ^ * @ % $. External server:" + extServer.getServerid() + ", orgId:" + extCourseId + ", orgName:" + orgName);
        }
        org.setName(orgName);
        org.setDescription(extCourseId);
        org.setOrganisationState((OrganisationState)this.service.findById(OrganisationState.class, OrganisationState.ACTIVE));
        org.setEnableCourseNotifications(true);
        Organisation parent = (Organisation)this.service.findById(Organisation.class, Integer.valueOf(parentOrgId));
        if (parent != null) {
            org.setParentOrganisation(parent);
            if (!parent.getOrganisationId().equals(this.service.getRootOrganisation().getOrganisationId())) {
                org.setOrganisationType((OrganisationType)this.service.findById(OrganisationType.class, OrganisationType.CLASS_TYPE));
            } else {
                org.setOrganisationType((OrganisationType)this.service.findById(OrganisationType.class, OrganisationType.COURSE_TYPE));
            }
        } else {
            org.setParentOrganisation(this.service.getRootOrganisation());
            org.setOrganisationType((OrganisationType)this.service.findById(OrganisationType.class, OrganisationType.COURSE_TYPE));
        }
        return this.service.saveOrganisation(org, user.getUserId());
    }

    private ExtUserUseridMap createExtUserUseridMap(ExtServer extServer, String extUsername, String password, String salt, String[] userData, boolean prefix) throws UserInfoValidationException {
        String login = prefix ? this.buildName(extServer.getPrefix(), extUsername) : extUsername;
        String firstName = userData[1];
        String lastName = userData[2];
        String email = userData[11];
        if (StringUtils.isBlank((String)login)) {
            throw new UserInfoValidationException("Can't create user due to validation error: Username cannot be blank. External server:" + extServer.getServerid() + ", firstName:" + firstName + ", lastName:" + lastName);
        }
        if (!ValidationUtil.isUserNameValid(login)) {
            throw new UserInfoValidationException("Can't create user due to validation error: Username can only contain alphanumeric characters and no spaces. External server:" + extServer.getServerid() + ", Username:" + login);
        }
        if (StringUtils.isNotBlank((String)firstName) && !ValidationUtil.isFirstLastNameValid(firstName)) {
            throw new UserInfoValidationException("Can't create user due to validation error: First name contains invalid characters. External server:" + extServer.getServerid() + ", Username:" + login + ", firstName:" + firstName + ", lastName:" + lastName);
        }
        if (StringUtils.isNotBlank((String)lastName) && !ValidationUtil.isFirstLastNameValid(lastName)) {
            throw new UserInfoValidationException("Can't create user due to validation error: Last name contains invalid characters. External server:" + extServer.getServerid() + ", Username:" + login + ", firstName:" + firstName + ", lastName:" + lastName);
        }
        if (StringUtils.isNotBlank((String)email) && !ValidationUtil.isEmailValid(email)) {
            throw new UserInfoValidationException("Can't create user due to validation error: Email format is invalid. External server:" + extServer.getServerid() + ", Username:" + login + ", firstName:" + firstName + ", lastName:" + lastName);
        }
        User user = new User();
        user.setLogin(login);
        user.setPassword(password);
        user.setSalt(salt);
        user.setTitle(userData[0]);
        user.setFirstName(userData[1]);
        user.setLastName(userData[2]);
        user.setAddressLine1(userData[3]);
        user.setCity(userData[4]);
        user.setState(userData[5]);
        user.setPostcode(userData[6]);
        user.setCountry(LanguageUtil.getSupportedCountry(userData[7]));
        user.setDayPhone(userData[8]);
        user.setMobilePhone(userData[9]);
        user.setFax(userData[10]);
        user.setEmail(userData[11]);
        user.setAuthenticationMethod((AuthenticationMethod)this.service.findById(AuthenticationMethod.class, AuthenticationMethod.DB));
        user.setCreateDate(new Date());
        user.setDisabledFlag(false);
        user.setLocale(LanguageUtil.getSupportedLocaleByNameOrLanguageCode(userData[12]));
        user.setTimeZone(this.timezoneService.getServerTimezone().getTimezoneId());
        user.setTheme(this.service.getDefaultTheme());
        this.service.saveUser(user);
        ExtUserUseridMap extUserUseridMap = new ExtUserUseridMap();
        extUserUseridMap.setExtServer(extServer);
        extUserUseridMap.setExtUsername(extUsername);
        extUserUseridMap.setUser(user);
        this.service.save(extUserUseridMap);
        return extUserUseridMap;
    }

    private String[] getUserDataFromExtServer(ExtServer extServer, String extUsername) throws UserInfoFetchException {
        try {
            String userDataCallbackUrl = extServer.getUserinfoUrl();
            String timestamp = Long.toString(new Date().getTime());
            String hash = this.hash(extServer, extUsername, timestamp);
            String encodedExtUsername = URLEncoder.encode(extUsername, "UTF8");
            userDataCallbackUrl = userDataCallbackUrl.replaceAll("%username%", encodedExtUsername).replaceAll("%timestamp%", timestamp).replaceAll("%hash%", hash);
            log.debug((Object)userDataCallbackUrl);
            URL url = new URL(userDataCallbackUrl);
            URLConnection conn = url.openConnection();
            if (!(conn instanceof HttpURLConnection)) {
                throw new UserInfoFetchException("Fail to fetch user data from external server:" + extServer.getServerid() + "- Invalid connection type");
            }
            HttpURLConnection httpConn = (HttpURLConnection)conn;
            if (httpConn.getResponseCode() != 200) {
                throw new UserInfoFetchException("Fail to fetch user data from external server:" + extServer.getServerid() + " - Unexpected return HTTP Status:" + httpConn.getResponseCode());
            }
            InputStream is = url.openConnection().getInputStream();
            BufferedReader isReader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String str = isReader.readLine();
            if (str == null) {
                throw new UserInfoFetchException("Fail to fetch user data from external server:" + extServer.getServerid() + " - No data returned from external server");
            }
            return CSVUtil.parse(str);
        }
        catch (MalformedURLException e) {
            log.error((Object)e);
            throw new UserInfoFetchException(e);
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new UserInfoFetchException(e);
        }
        catch (ParseException e) {
            log.error((Object)e);
            throw new UserInfoFetchException(e);
        }
    }

    @Override
    public boolean isIntegrationUser(Integer userId) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("user.userId", userId);
        List list = this.service.findByProperties(ExtUserUseridMap.class, properties);
        return list != null && !list.isEmpty();
    }

    @Override
    public String hash(ExtServer extServer, String extUsername, String timestamp) {
        String serverId = extServer.getServerid();
        String serverKey = extServer.getServerkey();
        String plaintext = timestamp.trim().toLowerCase() + extUsername.trim().toLowerCase() + serverId.trim().toLowerCase() + serverKey.trim().toLowerCase();
        return HashUtil.sha1(plaintext);
    }

    private String buildName(String prefix, String name) {
        return prefix + "_" + name;
    }

    @Override
    public List<ExtServer> getAllExtServers() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("serverTypeId", 1);
        return this.service.findByProperties(ExtServer.class, properties);
    }

    @Override
    public List<ExtServer> getAllToolConsumers() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("serverTypeId", 2);
        return this.service.findByProperties(ExtServer.class, properties);
    }

    @Override
    public List<ExtServerToolAdapterMap> getMappedServers(String toolSig) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("tool.toolSignature", toolSig);
        return this.service.findByProperties(ExtServerToolAdapterMap.class, properties);
    }

    @Override
    public ExtServerToolAdapterMap getMappedServer(String serverId, String toolSig) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("tool.toolSignature", toolSig);
        properties.put("extServer.serverid", serverId);
        List ret = this.service.findByProperties(ExtServerToolAdapterMap.class, properties);
        if (ret != null && ret.size() > 0) {
            return (ExtServerToolAdapterMap)ret.get(0);
        }
        return null;
    }

    @Override
    public void saveExtServerToolAdapterMap(ExtServerToolAdapterMap map) {
        this.service.save(map);
    }

    @Override
    public void deleteExtServerToolAdapterMap(ExtServerToolAdapterMap map) {
        this.service.delete(map);
    }

    @Override
    public void saveExtServer(ExtServer map) {
        this.service.save(map);
    }

    @Override
    public ExtServer getExtServer(Integer sid) {
        return (ExtServer)this.service.findById(ExtServer.class, sid);
    }

    @Override
    public void createExtServerLessonMap(Long lessonId, ExtServer extServer) {
        this.createExtServerLessonMap(lessonId, null, extServer);
    }

    @Override
    public void createExtServerLessonMap(Long lessonId, String resourceLinkId, ExtServer extServer) {
        ExtServerLessonMap map = new ExtServerLessonMap();
        map.setLessonId(lessonId);
        map.setResourceLinkId(resourceLinkId);
        map.setExtServer(extServer);
        this.service.save(map);
    }

    @Override
    public String getLessonFinishCallbackUrl(User user, Lesson lesson) throws UnsupportedEncodingException {
        ExtServer server;
        ExtUserUseridMap extUser;
        Long lessonId;
        ExtServerLessonMap extServerLesson;
        String lessonFinishCallbackUrl = null;
        if (lesson != null && (extServerLesson = this.getExtServerLessonMap(lessonId = lesson.getLessonId())) != null && StringUtils.isNotBlank((String)extServerLesson.getExtServer().getLessonFinishUrl()) && (extUser = this.getExtUserUseridMapByUserId(server = extServerLesson.getExtServer(), user.getUserId())) != null) {
            String extUsername = extUser.getExtUsername();
            if (server.getServerTypeId().equals(1)) {
                lessonFinishCallbackUrl = server.getLessonFinishUrl();
                String timestamp = Long.toString(new Date().getTime());
                String hash = this.hash(server, extUsername, timestamp);
                String encodedExtUsername = URLEncoder.encode(extUsername, "UTF8");
                lessonFinishCallbackUrl = lessonFinishCallbackUrl.replaceAll("%username%", encodedExtUsername).replaceAll("%lessonid%", lessonId.toString()).replaceAll("%timestamp%", timestamp).replaceAll("%hash%", hash);
                log.debug((Object)lessonFinishCallbackUrl);
            } else {
                Long lessonMaxPossibleMark = this.toolService.getLessonMaxPossibleMark(lesson);
                GradebookUserLesson gradebookUserLesson = this.gradebookService.getGradebookUserLesson(lessonId, user.getUserId());
                Double userTotalMark = gradebookUserLesson == null || gradebookUserLesson.getMark() == null ? null : gradebookUserLesson.getMark();
                final String lessonFinishUrl = server.getLessonFinishUrl();
                if (userTotalMark != null && StringUtils.isNotBlank((String)lessonFinishUrl)) {
                    Double score = lessonMaxPossibleMark.equals(0L) ? 0.0 : userTotalMark / (double)lessonMaxPossibleMark.longValue();
                    final String scoreStr = userTotalMark == null || lessonMaxPossibleMark.equals(0L) ? "" : score.toString();
                    final String serverKey = server.getServerid();
                    final String serverSecret = server.getServerkey();
                    final String tcGradebookId = extUser.getTcGradebookId();
                    final ExtUserUseridMap extUserFinal = extUser;
                    Thread preaddLearnersMonitorsThread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                IMSPOXRequest.sendReplaceResult((String)lessonFinishUrl, (String)serverKey, (String)serverSecret, (String)tcGradebookId, (String)scoreStr);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                            catch (OAuthException e) {
                                throw new RuntimeException(e);
                            }
                            catch (GeneralSecurityException e) {
                                throw new RuntimeException(e);
                            }
                            log.debug((Object)("Score (" + scoreStr + ") posted to Tool Consumer (serverKey:" + serverKey + "). extUsername:" + extUserFinal.getExtUsername()));
                        }
                    }, "LAMS_sendScoresLTI_thread");
                    preaddLearnersMonitorsThread.start();
                }
            }
        }
        return lessonFinishCallbackUrl;
    }

    @Override
    public boolean isIntegratedServerGroupFetchingAvailable(Long lessonId) {
        boolean isIntegratedServerGroupFetchingAvailable = false;
        if (lessonId != null) {
            ExtServerLessonMap extServerLesson = this.getExtServerLessonMap(lessonId);
            isIntegratedServerGroupFetchingAvailable = extServerLesson != null && StringUtils.isNotBlank((String)extServerLesson.getExtServer().getExtGroupsUrl());
        }
        return isIntegratedServerGroupFetchingAvailable;
    }

    @Override
    public List<ExtGroupDTO> getExtGroups(Long lessonId, String[] extGroupIds) throws Exception {
        if (lessonId == null) {
            throw new GroupInfoFetchException("Fail to fetch group data from external server: specified lessonId is null");
        }
        Lesson lesson = (Lesson)this.service.findById(Lesson.class, lessonId);
        if (lesson == null) {
            throw new GroupInfoFetchException("Fail to fetch group data from external server: specified lesson is null");
        }
        Organisation organisation = lesson.getOrganisation();
        Integer organisationId = lesson.getOrganisation().getOrganisationId();
        ExtServerLessonMap extServerLesson = this.getExtServerLessonMap(lessonId);
        ExtCourseClassMap extCourse = this.getExtCourseClassMap(organisationId);
        if (extServerLesson == null) {
            throw new GroupInfoFetchException("Fail to fetch group data from external server: there is no corresponding ExtServerLessonMap for lessonId " + lessonId);
        }
        if (StringUtils.isBlank((String)extServerLesson.getExtServer().getExtGroupsUrl())) {
            throw new GroupInfoFetchException("Fail to fetch group data from external server: corresponding ExtCourseClassMap doesn't have extGroupsUrl specified.");
        }
        if (extCourse == null) {
            throw new GroupInfoFetchException("Fail to fetch group data from external server: there is no corresponding ExtCourseClassMap for lessonId " + lessonId);
        }
        ExtServer extServer = extServerLesson.getExtServer();
        Object lmsGroupsUrl = extServer.getExtGroupsUrl();
        if (extGroupIds != null && extGroupIds.length > 0) {
            if (!((String)lmsGroupsUrl).contains("?")) {
                lmsGroupsUrl = (String)lmsGroupsUrl + "?";
            }
            Object extGroupIdsParam = "";
            for (String extGroupId : extGroupIds) {
                extGroupIdsParam = (String)extGroupIdsParam + "&extGroupIds=" + extGroupId;
            }
            lmsGroupsUrl = (String)lmsGroupsUrl + (String)extGroupIdsParam;
        }
        String timestamp = Long.toString(new Date().getTime());
        String hashUsername = "username";
        String hash = this.hash(extServer, hashUsername, timestamp);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uid", hashUsername);
        params.put("ts", timestamp);
        params.put("hash", hash);
        params.put("course_id", extCourse.getCourseid());
        InputStream is = WebUtil.getResponseInputStreamFromExternalServer((String)lmsGroupsUrl, params);
        BufferedReader isReader = new BufferedReader(new InputStreamReader(is));
        String str = isReader.readLine();
        ArrayNode jsonGroups = JsonUtil.readArray(str);
        ArrayList<ExtGroupDTO> extGroups = new ArrayList<ExtGroupDTO>();
        for (JsonNode jsonGroup : jsonGroups) {
            ExtGroupDTO group = new ExtGroupDTO();
            group.setGroupName(JsonUtil.optString(jsonGroup, "groupName"));
            group.setGroupId(JsonUtil.optString(jsonGroup, "groupId"));
            extGroups.add(group);
            if (extGroupIds != null && extGroupIds.length > 0) {
                ArrayList<User> users = new ArrayList<User>();
                ArrayNode jsonUsers = JsonUtil.optArray(jsonGroup, "users");
                for (JsonNode jsonUser : jsonUsers) {
                    String extUsername = JsonUtil.optString(jsonUser, "userName");
                    ExtUserUseridMap extUserUseridMap = this.getExistingExtUserUseridMap(extServer, extUsername);
                    if (extUserUseridMap == null) {
                        String[] userData = new String[13];
                        for (int k = 1; k <= 13; ++k) {
                            String userProperty;
                            userData[k - 1] = userProperty = JsonUtil.optString(jsonUser, "" + k);
                        }
                        String salt = HashUtil.salt();
                        String password = HashUtil.sha1(RandomPasswordGenerator.nextPassword(10));
                        extUserUseridMap = this.createExtUserUseridMap(extServer, extUsername, password, salt, userData, true);
                    }
                    User user = extUserUseridMap.getUser();
                    Integer userId = extUserUseridMap.getUser().getUserId();
                    this.updateUserRoles(user, organisation, false);
                    if (!lesson.getLessonClass().getLearnersGroup().hasLearner(user)) {
                        this.lessonService.addLearner(lessonId, userId);
                    }
                    users.add(user);
                }
                group.setUsers(users);
                continue;
            }
            group.setNumberUsers(JsonUtil.optInt(jsonGroup, "groupSize"));
        }
        return extGroups;
    }

    @Override
    public ExtCourseClassMap getExtCourseClassMap(Integer sid, Long lessonId) {
        Lesson lesson = this.lessonService.getLesson(lessonId);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("extServer.sid", sid);
        properties.put("organisation.organisationId", lesson.getOrganisation().getOrganisationId());
        List list = this.service.findByProperties(ExtCourseClassMap.class, properties);
        return list == null || list.isEmpty() ? null : (ExtCourseClassMap)list.get(0);
    }

    @Override
    public ExtServerLessonMap getLtiConsumerLesson(String serverId, String resourceLinkId) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("extServer.serverid", serverId);
        properties.put("resourceLinkId", resourceLinkId);
        List list = this.service.findByProperties(ExtServerLessonMap.class, properties);
        return list == null || list.isEmpty() ? null : (ExtServerLessonMap)list.get(0);
    }

    @Override
    public ExtServerLessonMap getExtServerLessonMap(Long lessonId) {
        List list = this.service.findByProperty(ExtServerLessonMap.class, "lessonId", lessonId);
        if (list == null || list.size() == 0) {
            return null;
        }
        return (ExtServerLessonMap)list.get(0);
    }

    private ExtUserUseridMap getExtUserUseridMapByUserId(ExtServer extServer, Integer userId) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("extServer.sid", extServer.getSid());
        properties.put("user.userId", userId);
        List list = this.service.findByProperties(ExtUserUseridMap.class, properties);
        if (list == null || list.size() == 0) {
            return null;
        }
        return (ExtUserUseridMap)list.get(0);
    }

    private ExtCourseClassMap getExtCourseClassMap(Integer organisationId) {
        List list = this.service.findByProperty(ExtCourseClassMap.class, "organisation.organisationId", organisationId);
        if (list == null || list.size() == 0) {
            return null;
        }
        return (ExtCourseClassMap)list.get(0);
    }

    public void setService(IUserManagementService service) {
        this.service = service;
    }

    public void setLessonService(ILessonService lessonService) {
        this.lessonService = lessonService;
    }

    public void setGradebookService(IGradebookService gradebookService) {
        this.gradebookService = gradebookService;
    }

    public void setToolService(ILamsCoreToolService toolService) {
        this.toolService = toolService;
    }

    public void setTimezoneService(ITimezoneService timezoneService) {
        this.timezoneService = timezoneService;
    }
}

