/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.integration.util;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.integration.ExtServer;
import org.lamsfoundation.lams.integration.ExtUserUseridMap;
import org.lamsfoundation.lams.integration.UserInfoFetchException;
import org.lamsfoundation.lams.integration.UserInfoValidationException;
import org.lamsfoundation.lams.integration.service.IIntegrationService;
import org.lamsfoundation.lams.integration.service.IntegrationService;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.usermanagement.User;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class LoginRequestDispatcher {
    private static Logger log = Logger.getLogger(LoginRequestDispatcher.class);
    public static final String PARAM_USER_ID = "uid";
    public static final String PARAM_SERVER_ID = "sid";
    public static final String PARAM_TIMESTAMP = "ts";
    public static final String PARAM_HASH = "hash";
    public static final String PARAM_METHOD = "method";
    public static final String PARAM_COURSE_ID = "courseid";
    public static final String PARAM_COUNTRY = "country";
    public static final String PARAM_LANGUAGE = "lang";
    public static final String PARAM_IS_UPDATE_USER_DETAILS = "isUpdateUserDetails";
    public static final String PARAM_FIRST_NAME = "firstName";
    public static final String PARAM_LAST_NAME = "lastName";
    public static final String PARAM_EMAIL = "email";
    public static final String PARAM_CUSTOM_CSV = "customCSV";
    public static final String PARAM_EXT_LMS_ID = "extlmsid";
    public static final String PARAM_MODE = "mode";
    public static final String MODE_GRADEBOOK = "gradebook";
    public static final String METHOD_AUTHOR = "author";
    public static final String METHOD_MONITOR = "monitor";
    public static final String METHOD_LEARNER = "learner";
    public static final String METHOD_LEARNER_STRICT_AUTHENTICATION = "learnerStrictAuth";
    public static final String PARAM_LEARNING_DESIGN_ID = "ldId";
    public static final String PARAM_LESSON_ID = "lsid";
    private static final String URL_DEFAULT = "/index.jsp";
    private static final String URL_AUTHOR = "/home/author.do";
    private static final String URL_LEARNER = "/home/learner.do?lessonID=";
    private static final String URL_MONITOR = "/home/monitorLesson&lessonID=.do?lessonID=";
    private static final String URL_GRADEBOOK = "/services/Gradebook?";
    private static IIntegrationService integrationService = null;
    private static ILessonService lessonService = null;

    public static String getRequestURL(HttpServletRequest request) throws ServletException {
        String redirect;
        String method = request.getParameter(PARAM_METHOD);
        String lessonId = request.getParameter(PARAM_LESSON_ID);
        String mode = request.getParameter(PARAM_MODE);
        if (StringUtils.isNotEmpty((String)lessonId)) {
            try {
                LoginRequestDispatcher.addUserToLessonClass(request, lessonId, method);
            }
            catch (UserInfoFetchException e) {
                throw new ServletException((Throwable)e);
            }
            catch (UserInfoValidationException e) {
                throw new ServletException((Throwable)e);
            }
        }
        if ((redirect = request.getParameter("redirectURL")) != null) {
            return request.getContextPath() + "/" + redirect;
        }
        if (MODE_GRADEBOOK.equals(mode)) {
            return request.getContextPath() + URL_GRADEBOOK + request.getQueryString();
        }
        if (METHOD_AUTHOR.equals(method)) {
            String ldID = request.getParameter(PARAM_LEARNING_DESIGN_ID);
            String customCSV = request.getParameter(PARAM_CUSTOM_CSV);
            String extLmsId = request.getParameter(PARAM_SERVER_ID);
            String parameters = "";
            parameters = ldID != null ? parameters + "&learningDesignID=" + ldID : parameters;
            parameters = customCSV != null ? parameters + "&customCSV=" + customCSV : parameters;
            parameters = extLmsId != null ? parameters + "&extlmsid=" + extLmsId : parameters;
            return request.getContextPath() + URL_AUTHOR + parameters;
        }
        if (METHOD_MONITOR.equals(method) && lessonId != null) {
            return request.getContextPath() + URL_MONITOR + lessonId;
        }
        if ((METHOD_LEARNER.equals(method) || METHOD_LEARNER_STRICT_AUTHENTICATION.equals(method)) && lessonId != null) {
            String url = request.getContextPath() + URL_LEARNER + lessonId;
            if (mode != null) {
                url = url + "&mode=" + mode;
            }
            return url;
        }
        return request.getContextPath() + URL_DEFAULT;
    }

    private static void addUserToLessonClass(HttpServletRequest request, String lessonId, String method) throws UserInfoFetchException, UserInfoValidationException {
        if (integrationService == null) {
            integrationService = (IntegrationService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)request.getSession().getServletContext()).getBean("integrationService");
        }
        if (lessonService == null) {
            lessonService = (ILessonService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)request.getSession().getServletContext()).getBean("lessonService");
        }
        String serverId = request.getParameter(PARAM_SERVER_ID);
        String extUsername = request.getParameter(PARAM_USER_ID);
        ExtServer extServer = integrationService.getExtServer(serverId);
        ExtUserUseridMap userMap = integrationService.getExtUserUseridMap(extServer, extUsername);
        User user = userMap.getUser();
        if (user == null) {
            String error = "Unable to add user to lesson class as user is missing from the user map";
            log.error((Object)error);
            throw new UserInfoFetchException(error);
        }
        if (METHOD_LEARNER.equals(method) || METHOD_LEARNER_STRICT_AUTHENTICATION.equals(method)) {
            lessonService.addLearner(Long.parseLong(lessonId), user.getUserId());
        } else if (METHOD_MONITOR.equals(method)) {
            lessonService.addStaffMember(Long.parseLong(lessonId), user.getUserId());
        }
    }
}

