/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.lamsfoundation.lams.learningdesign.ChosenGrouping;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.LearnerChoiceGrouping;
import org.lamsfoundation.lams.learningdesign.RandomGrouping;
import org.lamsfoundation.lams.learningdesign.dto.BaseDTO;
import org.lamsfoundation.lams.lesson.LessonClass;

public class GroupingDTO
extends BaseDTO {
    private Long groupingID;
    private Integer groupingUIID;
    private Integer groupingTypeID;
    private Integer numberOfGroups;
    private Integer learnersPerGroup;
    private Long staffGroupID;
    private Integer maxNumberOfGroups;
    private Boolean equalNumberOfLearnersPerGroup;
    private Boolean viewStudentsBeforeSelection;
    private List groups;

    public GroupingDTO() {
    }

    public GroupingDTO(Long groupingID, Integer groupingUIID, Integer groupingType, Integer numberOfGroups, Integer learnersPerGroup, Long staffGroupID, Integer maxNumberOfGroups, Boolean equalNumberOfLearnersPerGroup, Boolean viewStudentsBeforeSelection, List groupDTOs) {
        this.groupingID = groupingID;
        this.groupingUIID = groupingUIID;
        this.groupingTypeID = groupingType;
        this.numberOfGroups = numberOfGroups;
        this.learnersPerGroup = learnersPerGroup;
        this.staffGroupID = staffGroupID;
        this.maxNumberOfGroups = maxNumberOfGroups;
        this.equalNumberOfLearnersPerGroup = equalNumberOfLearnersPerGroup;
        this.viewStudentsBeforeSelection = viewStudentsBeforeSelection;
        this.groups = groupDTOs;
    }

    public GroupingDTO(Grouping grouping, boolean setupUserList) {
        this.groupingID = grouping.getGroupingId();
        this.groupingUIID = grouping.getGroupingUIID();
        this.maxNumberOfGroups = grouping.getMaxNumberOfGroups();
        this.groupingTypeID = grouping.getGroupingTypeId();
        Set<Group> groupSet = grouping.getGroups();
        this.groups = new ArrayList();
        if (groupSet != null) {
            Iterator<Group> iter = groupSet.iterator();
            while (iter.hasNext()) {
                this.groups.add(iter.next().getGroupDTO(setupUserList));
            }
        }
        this.processGroupingActivity(grouping);
    }

    public void processGroupingActivity(Object object) {
        if (object instanceof RandomGrouping) {
            this.addRandomGroupingAttributes((RandomGrouping)object);
        } else if (object instanceof ChosenGrouping) {
            this.addChosenGroupingAttributes((ChosenGrouping)object);
        } else if (object instanceof LearnerChoiceGrouping) {
            this.addLearnerChoiceGroupingAttributes((LearnerChoiceGrouping)object);
        } else {
            this.addLessonClassAttributes((LessonClass)object);
        }
    }

    private void addRandomGroupingAttributes(RandomGrouping grouping) {
        this.learnersPerGroup = grouping.getLearnersPerGroup();
        this.numberOfGroups = grouping.getNumberOfGroups();
    }

    private void addChosenGroupingAttributes(ChosenGrouping grouping) {
    }

    private void addLearnerChoiceGroupingAttributes(LearnerChoiceGrouping grouping) {
        this.learnersPerGroup = grouping.getLearnersPerGroup();
        this.numberOfGroups = grouping.getNumberOfGroups();
        this.equalNumberOfLearnersPerGroup = grouping.getEqualNumberOfLearnersPerGroup();
        this.viewStudentsBeforeSelection = grouping.getViewStudentsBeforeSelection();
    }

    private void addLessonClassAttributes(LessonClass grouping) {
        this.staffGroupID = grouping.getStaffGroup().getGroupId();
    }

    public Long getGroupingID() {
        return this.groupingID;
    }

    public void setGroupingID(Long groupingID) {
        this.groupingID = groupingID;
    }

    public Integer getGroupingTypeID() {
        return this.groupingTypeID;
    }

    public void setGroupingTypeID(Integer groupingType) {
        this.groupingTypeID = groupingType;
    }

    public Integer getGroupingUIID() {
        return this.groupingUIID;
    }

    public void setGroupingUIID(Integer groupingUIID) {
        this.groupingUIID = groupingUIID;
    }

    public Integer getLearnersPerGroup() {
        return this.learnersPerGroup;
    }

    public void setLearnersPerGroup(Integer learnersPerGroup) {
        this.learnersPerGroup = learnersPerGroup;
    }

    public Integer getMaxNumberOfGroups() {
        return this.maxNumberOfGroups;
    }

    public void setMaxNumberOfGroups(Integer maxNumberOfGroups) {
        this.maxNumberOfGroups = maxNumberOfGroups;
    }

    public Integer getNumberOfGroups() {
        return this.numberOfGroups;
    }

    public void setNumberOfGroups(Integer numberOfGroups) {
        this.numberOfGroups = numberOfGroups;
    }

    public Long getStaffGroupID() {
        return this.staffGroupID;
    }

    public void setStaffGroupID(Long staffGroupID) {
        this.staffGroupID = staffGroupID;
    }

    public List getGroups() {
        return this.groups;
    }

    public void setGroups(List groups) {
        this.groups = groups;
    }

    public Boolean getEqualNumberOfLearnersPerGroup() {
        return this.equalNumberOfLearnersPerGroup;
    }

    public void setEqualNumberOfLearnersPerGroup(Boolean equalNumberOfLearnersPerGroup) {
        this.equalNumberOfLearnersPerGroup = equalNumberOfLearnersPerGroup;
    }

    public Boolean getViewStudentsBeforeSelection() {
        return this.viewStudentsBeforeSelection;
    }

    public void setViewStudentsBeforeSelection(Boolean viewStudentsBeforeSelection) {
        this.viewStudentsBeforeSelection = viewStudentsBeforeSelection;
    }
}

