/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.strategy;

import java.util.ArrayList;
import java.util.Date;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.GateActivity;
import org.lamsfoundation.lams.learningdesign.strategy.SimpleActivityStrategy;
import org.lamsfoundation.lams.usermanagement.User;

public abstract class GateActivityStrategy
extends SimpleActivityStrategy {
    protected GateActivity gateActivity = null;

    public GateActivityStrategy(GateActivity gateActivity) {
        this.gateActivity = gateActivity;
    }

    public boolean shouldOpenGateFor(User learner, int expectedLearnerCount, int waitingLearnerCount) {
        boolean isOpen = this.gateActivity.getGateOpen();
        if (isOpen) {
            if (!this.gateActivity.getAllowedToPassLearners().isEmpty()) {
                this.gateActivity.getAllowedToPassLearners().clear();
            }
            return true;
        }
        if (this.isOpenConditionMet(expectedLearnerCount, waitingLearnerCount)) {
            this.gateActivity.setGateOpen(true);
            this.gateActivity.setGateOpenTime(new Date());
            if (!this.gateActivity.getAllowedToPassLearners().isEmpty()) {
                this.gateActivity.getAllowedToPassLearners().clear();
            }
            return true;
        }
        return this.gateActivity.getAllowedToPassLearners().contains(learner);
    }

    protected abstract boolean isOpenConditionMet(int var1, int var2);

    @Override
    protected abstract void setUpContributionType(ArrayList<Integer> var1);

    @Override
    protected Activity getActivity() {
        return this.gateActivity;
    }
}

