/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.logevent.dao.hibernate;

import java.util.Date;
import java.util.List;
import org.hibernate.SQLQuery;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.lamsfoundation.lams.dao.hibernate.LAMSBaseDAO;
import org.lamsfoundation.lams.logevent.LogEvent;
import org.lamsfoundation.lams.logevent.LogEventType;
import org.lamsfoundation.lams.logevent.dao.ILogEventDAO;
import org.springframework.stereotype.Repository;

@Repository
public class LogEventDAO
extends LAMSBaseDAO
implements ILogEventDAO {
    private static final String GET_LOG_EVENT_BY_ID = "from " + LogEvent.class.getName() + "where id = ?";
    private static final String GET_LOG_EVENT_BY_USER = "from " + LogEvent.class.getName() + " where user_id = ? order by occurred_date_time asc";
    private static final String GET_LOG_EVENTS_OCCURED_BETWEEN_DATES = "from " + LogEvent.class.getName() + " where occurred_date_time > ? and occurred_date_time <= ? order by occurred_date_time asc";
    private static final String GET_OLDEST_LOG_EVENT_DATE = "select min(occurredDateTime) from " + LogEvent.class.getName();
    private static final String GET_LOG_EVENT_TYPES = "from " + LogEventType.class.getName();

    @Override
    public void save(LogEvent logEvent) {
        super.insert(logEvent);
    }

    @Override
    public LogEvent getById(Long logEventId) {
        List<?> list = this.doFind(GET_LOG_EVENT_BY_ID, logEventId);
        if (list.size() > 0) {
            return (LogEvent)list.get(0);
        }
        return null;
    }

    @Override
    public List<LogEvent> getByUser(Integer userId) {
        return this.doFind(GET_LOG_EVENT_BY_USER, userId);
    }

    @Override
    public List<LogEvent> getEventsOccurredBetween(Date startDate, Date finishDate) {
        return this.doFind(GET_LOG_EVENTS_OCCURED_BETWEEN_DATES, startDate, finishDate);
    }

    @Override
    public List<LogEventType> getEventTypes() {
        return this.doFind(GET_LOG_EVENT_TYPES, new Object[0]);
    }

    @Override
    public Date getOldestEventDate() {
        List<?> list = this.doFind(GET_OLDEST_LOG_EVENT_DATE, new Object[0]);
        if (list.size() > 0) {
            return (Date)list.get(0);
        }
        return null;
    }

    @Override
    public List<Object[]> getEventsForTablesorter(int page, int size, int sorting, String searchString, Date startDate, Date endDate, String area, Integer typeId) {
        String sortingOrder;
        switch (sorting) {
            case 0: {
                sortingOrder = "occurred_date_time ASC";
                break;
            }
            case 1: {
                sortingOrder = "occurred_date_time DESC";
                break;
            }
            default: {
                sortingOrder = "occurred_date_time ASC";
            }
        }
        StringBuilder queryText = new StringBuilder();
        queryText.append("SELECT le.*, lesson.name lessonName, activity.title activityName FROM lams_log_event le ").append(" LEFT JOIN lams_lesson lesson ON le.lesson_id = lesson.lesson_id").append(" LEFT JOIN lams_learning_activity activity ON le.activity_id = activity.activity_id");
        this.addWhereClause(startDate, endDate, area, typeId, queryText);
        queryText.append(" ORDER BY " + sortingOrder);
        SQLQuery query = this.getSession().createSQLQuery(queryText.toString());
        query.addEntity("event", LogEvent.class);
        query.addScalar("lessonName", (Type)StringType.INSTANCE);
        query.addScalar("activityName", (Type)StringType.INSTANCE);
        this.addParameters(startDate, endDate, area, typeId, query);
        query.setFirstResult(page * size).setMaxResults(size);
        return query.list();
    }

    private void addWhereClause(Date startDate, Date endDate, String area, Integer typeId, StringBuilder queryText) {
        boolean needAnd = false;
        if (startDate != null && endDate != null || area != null || typeId != null) {
            queryText.append(" WHERE ");
            if (startDate != null && endDate != null) {
                queryText.append("( occurred_date_time BETWEEN :startDate AND DATE_ADD(:endDate,INTERVAL 1 DAY)) ");
                needAnd = true;
            }
            if (typeId != null) {
                if (needAnd) {
                    queryText.append(" AND ");
                }
                queryText.append(" log_event_type_id = :typeId ");
            } else if (area != null) {
                if (needAnd) {
                    queryText.append(" AND ");
                }
                queryText.append(" log_event_type_id in (SELECT log_event_type_id FROM lams_log_event_type WHERE area = :area) ");
            }
        }
    }

    private void addParameters(Date startDate, Date endDate, String area, Integer typeId, SQLQuery query) {
        if (startDate != null && endDate != null) {
            query.setDate("startDate", startDate);
            query.setDate("endDate", endDate);
        }
        if (typeId != null) {
            query.setInteger("typeId", typeId.intValue());
        } else if (area != null) {
            query.setString("area", area);
        }
    }

    @Override
    public int countEventsWithRestrictions(String searchString, Date startDate, Date endDate, String area, Integer typeId) {
        StringBuilder queryText = new StringBuilder();
        queryText.append("SELECT count(*) FROM lams_log_event e ");
        this.addWhereClause(startDate, endDate, area, typeId, queryText);
        SQLQuery query = this.getSession().createSQLQuery(queryText.toString());
        this.addParameters(startDate, endDate, area, typeId, query);
        List list = query.list();
        if (list == null || list.size() == 0) {
            return 0;
        }
        return ((Number)list.get(0)).intValue();
    }
}

