/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.logevent.service;

import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.lesson.dao.ILessonDAO;
import org.lamsfoundation.lams.logevent.LogEvent;
import org.lamsfoundation.lams.logevent.LogEventType;
import org.lamsfoundation.lams.logevent.dao.ILogEventDAO;
import org.lamsfoundation.lams.logevent.service.ILogEventService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.web.session.SessionManager;

public class LogEventService
implements ILogEventService {
    private Logger log = Logger.getLogger(LogEventService.class);
    private final String AUDIT_CHANGE_I18N_KEY = "audit.change.entry";
    private final String AUDIT_MARK_CHANGE_I18N_KEY = "audit.change.mark";
    private final String AUDIT_HIDE_I18N_KEY = "audit.hide.entry";
    private final String AUDIT_SHOW_I18N_KEY = "audit.show.entry";
    private final String AUDIT_STARTED_EDITING_I18N_KEY = "audit.started.editing.activity";
    private final String AUDIT_FINISHED_EDITING_I18N_KEY = "audit.finished.editing.activity";
    private final String AUDIT_CANCELLED_EDITING_I18N_KEY = "audit.cancelled.editing.activity";
    private static LogEventService instance;
    private ILogEventDAO logEventDAO;
    private IUserManagementService userManagementService;
    private MessageService messageService;
    private ILessonDAO lessonDAO;

    public LogEventService() {
        if (instance == null) {
            instance = this;
        }
    }

    public static LogEventService getInstance() {
        return instance;
    }

    @Override
    public void logEvent(Integer logEventTypeId, Integer userId, Integer targetUserId, Long lessonId, Long activityId, String description) {
        this.logEvent(logEventTypeId, userId, targetUserId, lessonId, activityId, description, null);
    }

    @Override
    public void logEvent(Integer logEventTypeId, Integer userId, Integer targetUserId, Long lessonId, Long activityId, String description, Date eventDate) {
        User user = userId != null ? (User)this.userManagementService.findById(User.class, userId) : null;
        User targetUser = targetUserId != null ? (User)this.userManagementService.findById(User.class, targetUserId) : null;
        LogEvent logEvent = new LogEvent();
        logEvent.setLogEventTypeId(logEventTypeId);
        logEvent.setUser(user);
        logEvent.setTargetUser(targetUser);
        logEvent.setLessonId(lessonId);
        logEvent.setActivityId(activityId);
        logEvent.setDescription(description);
        if (eventDate != null) {
            logEvent.setOccurredDateTime(eventDate);
        }
        this.logEventDAO.save(logEvent);
    }

    @Override
    public LogEvent getLogEventById(Long logEventId) {
        return this.logEventDAO.getById(logEventId);
    }

    @Override
    public List<LogEvent> getLogEventByUser(Integer userId) {
        return this.logEventDAO.getByUser(userId);
    }

    @Override
    public List<LogEvent> getEventsOccurredBetween(Date startDate, Date finishDate) {
        return this.logEventDAO.getEventsOccurredBetween(startDate, finishDate);
    }

    @Override
    public List<LogEventType> getEventTypes() {
        return this.logEventDAO.getEventTypes();
    }

    @Override
    public Date getOldestEventDate() {
        return this.logEventDAO.getOldestEventDate();
    }

    @Override
    public List<Object[]> getEventsForTablesorter(int page, int size, int sorting, String searchString, Date startDate, Date endDate, String area, Integer typeId) {
        return this.logEventDAO.getEventsForTablesorter(page, size, sorting, searchString, startDate, endDate, area, typeId);
    }

    @Override
    public int countEventsWithRestrictions(String searchString, Date startDate, Date endDate, String area, Integer typeId) {
        return this.logEventDAO.countEventsWithRestrictions(searchString, startDate, endDate, area, typeId);
    }

    private Integer getCurrentUserId() {
        UserDTO user;
        HttpSession ss = SessionManager.getSession();
        if (ss != null && (user = (UserDTO)ss.getAttribute("user")) != null) {
            return user.getUserID();
        }
        return null;
    }

    private UserDTO getCurrentUser() {
        HttpSession ss = SessionManager.getSession();
        if (ss != null) {
            return (UserDTO)ss.getAttribute("user");
        }
        return null;
    }

    @Override
    public void logChangeLearnerContent(Long learnerUserId, String learnerUserLogin, Long toolContentId, String originalText, String newText) {
        Object[] args = new Object[5];
        args[0] = learnerUserLogin + "(" + learnerUserId + ")";
        args[1] = originalText;
        args[2] = newText;
        this.logLearnerChange(19, learnerUserId, toolContentId, "audit.change.entry", args);
    }

    @Override
    public void logMarkChange(Long learnerUserId, String learnerUserLogin, Long toolContentId, String originalMark, String newMark) {
        Object[] args = new Object[5];
        args[0] = learnerUserLogin + "(" + learnerUserId + ")";
        args[1] = originalMark;
        args[2] = newMark;
        this.logLearnerChange(17, learnerUserId, toolContentId, "audit.change.mark", args);
    }

    @Override
    public void logHideLearnerContent(Long learnerUserId, String learnerUserLogin, Long toolContentId, String hiddenItem) {
        Object[] args = new Object[4];
        args[0] = learnerUserLogin + "(" + learnerUserId + ")";
        args[1] = hiddenItem;
        this.logLearnerChange(20, learnerUserId, toolContentId, "audit.hide.entry", args);
    }

    @Override
    public void logShowLearnerContent(Long learnerUserId, String learnerUserLogin, Long toolContentId, String hiddenItem) {
        Object[] args = new Object[4];
        args[0] = learnerUserLogin + "(" + learnerUserId + ")";
        args[1] = hiddenItem;
        this.logLearnerChange(20, learnerUserId, toolContentId, "audit.show.entry", args);
    }

    @Override
    public void logToolEvent(int eventType, Long toolContentId, Long learnerUserId, String message) {
        Long[] ids = this.lessonDAO.getLessonActivityIdsForToolContentId(toolContentId);
        Long lessonId = ids[0];
        Long activityId = ids[1];
        Integer currentUserId = this.getCurrentUserId();
        this.logEvent(eventType, currentUserId, learnerUserId != null ? Integer.valueOf(learnerUserId.intValue()) : null, lessonId, activityId, message);
    }

    private void logLearnerChange(int eventType, Long learnerUserId, Long toolContentId, String messageKey, Object[] args) {
        Long[] ids = this.lessonDAO.getLessonActivityIdsForToolContentId(toolContentId);
        Long lessonId = ids[0];
        Long activityId = ids[1];
        UserDTO currentUser = this.getCurrentUser();
        args[args.length - 1] = currentUser.getUserID();
        args[args.length - 2] = currentUser.getLogin();
        this.logEvent(eventType, currentUser.getUserID(), learnerUserId != null ? Integer.valueOf(learnerUserId.intValue()) : null, lessonId, activityId, this.messageService.getMessage(messageKey, args));
    }

    @Override
    public void logChangeLearnerArbitraryChange(Long learnerUserId, String learnerUserLogin, Long toolContentId, String message) {
        Long[] ids = this.lessonDAO.getLessonActivityIdsForToolContentId(toolContentId);
        Long lessonId = ids[0];
        Long activityId = ids[1];
        this.logEvent(19, this.getCurrentUserId(), learnerUserId != null ? Integer.valueOf(learnerUserId.intValue()) : null, lessonId, activityId, message);
    }

    @Override
    public void logStartEditingActivityInMonitor(Long toolContentId) {
        this.logEditActivityInMonitor(toolContentId, "audit.started.editing.activity");
    }

    @Override
    public void logFinishEditingActivityInMonitor(Long toolContentId) {
        this.logEditActivityInMonitor(toolContentId, "audit.finished.editing.activity");
    }

    @Override
    public void logCancelEditingActivityInMonitor(Long toolContentId) {
        this.logEditActivityInMonitor(toolContentId, "audit.cancelled.editing.activity");
    }

    private void logEditActivityInMonitor(Long toolContentId, String messageKey) {
        Long[] ids = this.lessonDAO.getLessonActivityIdsForToolContentId(toolContentId);
        Long lessonId = ids[0];
        Long activityId = ids[1];
        UserDTO user = this.getCurrentUser();
        String userString = user != null ? user.getLogin() + " (" + user.getUserID() + ")" : "";
        String activityString = " (" + activityId + ")";
        String message = this.messageService.getMessage(messageKey, new Object[]{userString, activityString});
        this.logEvent(9, this.getCurrentUserId(), null, lessonId != null ? Long.valueOf(lessonId) : null, activityId != null ? Long.valueOf(activityId) : null, message.toString());
    }

    public void setLogEventDAO(ILogEventDAO logEventDAO) {
        this.logEventDAO = logEventDAO;
    }

    public void setUserManagementService(IUserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public void setLessonDAO(ILessonDAO lessonDAO) {
        this.lessonDAO = lessonDAO;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }
}

