/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.outcome.dao.hibernate;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.lamsfoundation.lams.dao.hibernate.LAMSBaseDAO;
import org.lamsfoundation.lams.outcome.Outcome;
import org.lamsfoundation.lams.outcome.OutcomeMapping;
import org.lamsfoundation.lams.outcome.OutcomeResult;
import org.lamsfoundation.lams.outcome.OutcomeScale;
import org.lamsfoundation.lams.outcome.dao.IOutcomeDAO;
import org.lamsfoundation.lams.usermanagement.Role;
import org.springframework.stereotype.Repository;

@Repository
public class OutcomeDAO
extends LAMSBaseDAO
implements IOutcomeDAO {
    private static final String FIND_CONTENT_FOLDER_ID_BY_ORGANISATION = "SELECT * FROM (SELECT content_folder_id FROM lams_outcome WHERE organisation_id ? UNION SELECT content_folder_id FROM lams_outcome_scale WHERE organisation_id ?) AS a WHERE content_folder_id IS NOT NULL LIMIT 1";
    private static final String FIND_OUTCOMES_SORTED_BY_NAME = "FROM Outcome o WHERE (o.organisation IS NULL ?) ORDER BY o.name, o.code";
    private static final String FIND_AUTHOR_ORGANISATIONS = "SELECT uor.userOrganisation.organisation.organisationId FROM UserOrganisationRole uor WHERE uor.userOrganisation.user.userId = ? AND uor.role.roleId = " + Role.ROLE_AUTHOR;
    private static final String FIND_SCALES_SORTED_BY_NAME = "FROM OutcomeScale o WHERE (o.organisation IS NULL ?) ORDER BY o.name, o.code";

    @Override
    public String getContentFolderID(Integer organisationId) {
        String queryString = FIND_CONTENT_FOLDER_ID_BY_ORGANISATION.replace("?", (CharSequence)(organisationId == null ? "IS NULL" : "=" + organisationId));
        SQLQuery query = this.getSession().createSQLQuery(queryString);
        return (String)query.uniqueResult();
    }

    @Override
    public List<Outcome> getOutcomesSortedByName(Integer organisationId) {
        String queryString = FIND_OUTCOMES_SORTED_BY_NAME.replace("?", (CharSequence)(organisationId == null ? "" : "OR o.organisation.organisationId = " + organisationId));
        return this.find(queryString);
    }

    @Override
    public List<Outcome> getOutcomesSortedByName(String search, Set<Integer> organisationIds) {
        String queryString = FIND_OUTCOMES_SORTED_BY_NAME;
        if (organisationIds != null && !organisationIds.isEmpty()) {
            queryString = queryString.replace("?", "OR o.organisation.organisationId IN (:organisationIds)) ? ");
        }
        if (StringUtils.isNotBlank((String)search)) {
            queryString = queryString.replace("?", "AND (o.name LIKE :search OR o.code LIKE :search)");
        }
        queryString = queryString.replace("?", "");
        Query query = this.getSession().createQuery(queryString);
        if (organisationIds != null && !organisationIds.isEmpty()) {
            query.setParameterList("organisationIds", organisationIds);
        }
        if (StringUtils.isNotBlank((String)search)) {
            query.setString("search", "%" + search + "%");
        }
        return query.list();
    }

    @Override
    public List<OutcomeMapping> getOutcomeMappings(Long lessonId, Long toolContentId, Long itemId) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (lessonId != null) {
            properties.put("lessonId", lessonId);
        }
        if (toolContentId != null) {
            properties.put("toolContentId", toolContentId);
        }
        if (itemId != null) {
            properties.put("itemId", itemId);
        }
        return this.findByProperties(OutcomeMapping.class, properties);
    }

    @Override
    public List<OutcomeScale> getScalesSortedByName(Integer organisationId) {
        String queryString = FIND_SCALES_SORTED_BY_NAME.replace("?", (CharSequence)(organisationId == null ? "" : "OR o.organisation.organisationId = " + organisationId));
        return this.find(queryString);
    }

    @Override
    public List<Integer> getAuthorOrganisations(Integer userId) {
        return this.find(FIND_AUTHOR_ORGANISATIONS, new Object[]{userId});
    }

    @Override
    public List<OutcomeResult> getOutcomeResults(Integer userId, Long lessonId, Long toolContentId, Long itemId) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (lessonId != null) {
            properties.put("mapping.outcome.lessonId", lessonId);
        }
        if (toolContentId != null) {
            properties.put("mapping.outcome.toolContentId", toolContentId);
        }
        if (itemId != null) {
            properties.put("mapping.outcome.itemId", itemId);
        }
        if (userId != null) {
            properties.put("user.userId", userId);
        }
        return this.findByProperties(OutcomeResult.class, properties);
    }

    @Override
    public OutcomeResult getOutcomeResult(Integer userId, Long mappingId) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("user.userId", userId);
        properties.put("mapping.mappingId", mappingId);
        List result = this.findByProperties(OutcomeResult.class, properties);
        return result.isEmpty() ? null : (OutcomeResult)result.get(0);
    }
}

