/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.outcome.service;

import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.lamsfoundation.lams.outcome.Outcome;
import org.lamsfoundation.lams.outcome.OutcomeMapping;
import org.lamsfoundation.lams.outcome.OutcomeResult;
import org.lamsfoundation.lams.outcome.OutcomeScale;
import org.lamsfoundation.lams.outcome.OutcomeScaleItem;
import org.lamsfoundation.lams.outcome.dao.IOutcomeDAO;
import org.lamsfoundation.lams.outcome.service.IOutcomeService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.ExcelCell;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.multipart.MultipartFile;

public class OutcomeService
implements IOutcomeService {
    private IOutcomeDAO outcomeDAO;
    private MessageService messageService;
    private static Logger log = Logger.getLogger(OutcomeService.class);

    @Override
    public String getContentFolderId(Integer organisationId) {
        String contentFolderId = this.outcomeDAO.getContentFolderID(organisationId);
        return contentFolderId == null ? FileUtil.generateUniqueContentFolderID() : contentFolderId;
    }

    @Override
    public List<Outcome> getOutcomes(Integer organisationId) {
        return this.outcomeDAO.getOutcomesSortedByName(organisationId);
    }

    @Override
    public List<OutcomeScale> getScales(Integer organisationId) {
        return this.outcomeDAO.getScalesSortedByName(organisationId);
    }

    @Override
    public List<Outcome> getOutcomes(String search, Set<Integer> organisationIds) {
        if (organisationIds == null) {
            Integer userId = OutcomeService.getUserDTO().getUserID();
            organisationIds = new HashSet<Integer>(this.outcomeDAO.getAuthorOrganisations(userId));
        }
        return this.outcomeDAO.getOutcomesSortedByName(search, organisationIds);
    }

    @Override
    public List<OutcomeMapping> getOutcomeMappings(Long lessonId, Long toolContentId, Long itemId) {
        return this.outcomeDAO.getOutcomeMappings(lessonId, toolContentId, itemId);
    }

    @Override
    public List<OutcomeResult> getOutcomeResults(Integer userId, Long lessonId, Long toolContentId, Long itemId) {
        return this.outcomeDAO.getOutcomeResults(userId, lessonId, toolContentId, itemId);
    }

    @Override
    public OutcomeResult getOutcomeResult(Integer userId, Long mappingId) {
        return this.outcomeDAO.getOutcomeResult(userId, mappingId);
    }

    @Override
    public OutcomeScale getDefaultScale() {
        return (OutcomeScale)this.outcomeDAO.find(OutcomeScale.class, Long.valueOf(1L));
    }

    @Override
    public boolean isDefaultScale(Long scaleId) {
        return scaleId != null && 1L == scaleId;
    }

    @Override
    public void copyOutcomeMappings(Long sourceLessonId, Long sourceToolContentId, Long sourceItemId, Long targetLessonId, Long targetToolContentId, Long targetItemId) {
        List<OutcomeMapping> sourceMappings = this.getOutcomeMappings(sourceLessonId, sourceToolContentId, sourceItemId);
        for (OutcomeMapping sourceMapping : sourceMappings) {
            OutcomeMapping targetMapping = new OutcomeMapping();
            targetMapping.setOutcome(sourceMapping.getOutcome());
            targetMapping.setLessonId(targetLessonId);
            targetMapping.setToolContentId(targetToolContentId);
            targetMapping.setItemId(targetItemId);
            this.outcomeDAO.insert(targetMapping);
        }
    }

    @Override
    public LinkedHashMap<String, ExcelCell[][]> exportScales() {
        LinkedHashMap<String, ExcelCell[][]> dataToExport = new LinkedHashMap<String, ExcelCell[][]>();
        LinkedList<ExcelCell[]> rowList = new LinkedList<ExcelCell[]>();
        ExcelCell[] row = new ExcelCell[]{new ExcelCell((Object)this.messageService.getMessage("outcome.manage.add.name"), true), new ExcelCell((Object)this.messageService.getMessage("outcome.manage.add.code"), true), new ExcelCell((Object)this.messageService.getMessage("outcome.manage.add.description"), true), new ExcelCell((Object)this.messageService.getMessage("scale.manage.add.value"), true)};
        rowList.add(row);
        List<OutcomeScale> scales = this.getScales(null);
        for (OutcomeScale scale : scales) {
            row = new ExcelCell[]{new ExcelCell((Object)scale.getName(), false), new ExcelCell((Object)scale.getCode(), false), new ExcelCell((Object)scale.getDescription(), false), new ExcelCell((Object)scale.getItemString(), false)};
            rowList.add(row);
        }
        ExcelCell[][] data = (ExcelCell[][])rowList.toArray((T[])new ExcelCell[0][]);
        dataToExport.put(this.messageService.getMessage("scale.title"), data);
        return dataToExport;
    }

    @Override
    public LinkedHashMap<String, ExcelCell[][]> exportOutcomes() {
        LinkedHashMap<String, ExcelCell[][]> dataToExport = new LinkedHashMap<String, ExcelCell[][]>();
        LinkedList<ExcelCell[]> rowList = new LinkedList<ExcelCell[]>();
        ExcelCell[] row = new ExcelCell[]{new ExcelCell((Object)this.messageService.getMessage("outcome.manage.add.name"), true), new ExcelCell((Object)this.messageService.getMessage("outcome.manage.add.code"), true), new ExcelCell((Object)this.messageService.getMessage("outcome.manage.add.description"), true), new ExcelCell((Object)this.messageService.getMessage("outcome.manage.add.scale"), true)};
        rowList.add(row);
        List<Outcome> outcomes = this.getOutcomes(null);
        for (Outcome outcome : outcomes) {
            row = new ExcelCell[]{new ExcelCell((Object)outcome.getName(), false), new ExcelCell((Object)outcome.getCode(), false), new ExcelCell((Object)outcome.getDescription(), false), new ExcelCell((Object)outcome.getScale().getCode(), false)};
            rowList.add(row);
        }
        ExcelCell[][] data = (ExcelCell[][])rowList.toArray((T[])new ExcelCell[0][]);
        dataToExport.put(this.messageService.getMessage("index.outcome.manage"), data);
        return dataToExport;
    }

    @Override
    public int importScales(MultipartFile fileItem) throws IOException {
        POIFSFileSystem fs = new POIFSFileSystem(fileItem.getInputStream());
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        HSSFSheet sheet = wb.getSheetAt(0);
        int startRow = sheet.getFirstRowNum();
        int endRow = sheet.getLastRowNum();
        User user = null;
        int counter = 0;
        for (int i = startRow + 5; i < endRow + 1; ++i) {
            HSSFRow row = sheet.getRow(i);
            HSSFCell cell = row.getCell(1);
            String code = cell.getStringCellValue();
            List foundScales = this.outcomeDAO.findByProperty(OutcomeScale.class, "code", code);
            if (!foundScales.isEmpty()) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Skipping an outcome scale with existing code: " + code));
                continue;
            }
            cell = row.getCell(0);
            String name = cell.getStringCellValue();
            cell = row.getCell(2);
            String description = cell.getStringCellValue();
            cell = row.getCell(3);
            String itemsString = cell.getStringCellValue();
            OutcomeScale scale = new OutcomeScale();
            scale.setName(name);
            scale.setCode(code);
            scale.setDescription(description);
            if (user == null) {
                UserDTO userDTO = OutcomeService.getUserDTO();
                user = (User)this.outcomeDAO.find(User.class, userDTO.getUserID());
            }
            scale.setCreateBy(user);
            scale.setCreateDateTime(new Date());
            this.outcomeDAO.insert(scale);
            List<String> items = OutcomeScale.parseItems(itemsString);
            int value = 0;
            for (String itemString : items) {
                OutcomeScaleItem item = new OutcomeScaleItem();
                item.setName(itemString);
                item.setValue(value++);
                item.setScale(scale);
                this.outcomeDAO.insert(item);
            }
            ++counter;
        }
        return counter;
    }

    @Override
    public int importOutcomes(MultipartFile fileItem) throws IOException {
        POIFSFileSystem fs = new POIFSFileSystem(fileItem.getInputStream());
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        HSSFSheet sheet = wb.getSheetAt(0);
        int startRow = sheet.getFirstRowNum();
        int endRow = sheet.getLastRowNum();
        User user = null;
        int counter = 0;
        for (int i = startRow + 5; i < endRow + 1; ++i) {
            OutcomeScale scale;
            HSSFRow row = sheet.getRow(i);
            HSSFCell cell = row.getCell(1);
            String code = cell.getStringCellValue();
            List foundOutcomes = this.outcomeDAO.findByProperty(Outcome.class, "code", code);
            if (!foundOutcomes.isEmpty()) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Skipping an outcome with existing code: " + code));
                continue;
            }
            cell = row.getCell(3);
            String scaleCode = cell.getStringCellValue();
            List foundScales = this.outcomeDAO.findByProperty(OutcomeScale.class, "code", scaleCode);
            OutcomeScale outcomeScale = scale = foundScales.isEmpty() ? null : (OutcomeScale)foundScales.get(0);
            if (scale == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Skipping an outcome with missing scale with code: " + scaleCode));
                continue;
            }
            cell = row.getCell(0);
            String name = cell.getStringCellValue();
            cell = row.getCell(2);
            String description = cell.getStringCellValue();
            Outcome outcome = new Outcome();
            outcome.setName(name);
            outcome.setCode(code);
            outcome.setDescription(description);
            outcome.setScale(scale);
            if (user == null) {
                UserDTO userDTO = OutcomeService.getUserDTO();
                user = (User)this.outcomeDAO.find(User.class, userDTO.getUserID());
            }
            outcome.setCreateBy(user);
            outcome.setCreateDateTime(new Date());
            this.outcomeDAO.insert(outcome);
            ++counter;
        }
        return counter;
    }

    private static UserDTO getUserDTO() {
        HttpSession ss = SessionManager.getSession();
        return (UserDTO)ss.getAttribute("user");
    }

    public void setOutcomeDAO(IOutcomeDAO outcomeDAO) {
        this.outcomeDAO = outcomeDAO;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }
}

