/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.policies.service;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.policies.Policy;
import org.lamsfoundation.lams.policies.PolicyConsent;
import org.lamsfoundation.lams.policies.PolicyDTO;
import org.lamsfoundation.lams.policies.dao.IPolicyDAO;
import org.lamsfoundation.lams.policies.dto.UserPolicyConsentDTO;
import org.lamsfoundation.lams.policies.service.IPolicyService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;

public class PolicyService
implements IPolicyService {
    private IPolicyDAO policyDAO;
    private IUserManagementService userManagementService;
    private ILessonService lessonService;

    @Override
    public void storeUserConsent(String login, Long policyUid) {
        User user = this.userManagementService.getUserByLogin(login);
        Policy policy = this.policyDAO.getPolicyByUid(policyUid);
        PolicyConsent consent = new PolicyConsent();
        consent.setUser(user);
        consent.setPolicy(policy);
        this.userManagementService.save(consent);
    }

    @Override
    public Policy getPolicyByUid(Long uid) {
        return this.policyDAO.getPolicyByUid(uid);
    }

    @Override
    public void togglePolicyStatus(Long policyUid) {
        Policy policy = this.policyDAO.getPolicyByUid(policyUid);
        Integer newPolicyStatus = Policy.STATUS_ACTIVE.equals(policy.getPolicyStateId()) ? Policy.STATUS_INACTIVE : Policy.STATUS_ACTIVE;
        policy.setPolicyStateId(newPolicyStatus);
        this.userManagementService.save(policy);
        if (Policy.STATUS_ACTIVE.equals(newPolicyStatus)) {
            Long policyId = policy.getPolicyId();
            List<Policy> previousVersions = this.getPreviousVersionsPolicies(policyId);
            for (Policy previousVersion : previousVersions) {
                if (previousVersion.getUid().equals(policyUid) || !Policy.STATUS_ACTIVE.equals(previousVersion.getPolicyStateId())) continue;
                previousVersion.setPolicyStateId(Policy.STATUS_INACTIVE);
                this.userManagementService.save(previousVersion);
            }
        }
    }

    @Override
    public Collection<Policy> getPoliciesOfDistinctVersions() {
        List<Policy> policies = this.policyDAO.getAllPoliciesWithUserConsentsCount();
        LinkedHashMap<Long, Integer> policyCount = new LinkedHashMap<Long, Integer>();
        for (Policy policy : policies) {
            Long policyId = policy.getPolicyId();
            int previousVersionsCount = ((HashMap)policyCount).get(policyId) == null ? 0 : (Integer)((HashMap)policyCount).get(policyId);
            policyCount.put(policy.getPolicyId(), previousVersionsCount + 1);
        }
        LinkedHashMap<Long, Policy> filteredPolicies = new LinkedHashMap<Long, Policy>();
        for (Policy policy : policies) {
            Long policyId = policy.getPolicyId();
            boolean hasPreviousVersions = ((HashMap)policyCount).get(policyId) != null && (Integer)((HashMap)policyCount).get(policyId) > 1;
            policy.setPreviousVersions(hasPreviousVersions);
            if (filteredPolicies.containsKey(policyId)) {
                Policy alreadyAddedPolicy = (Policy)((HashMap)filteredPolicies).get(policyId);
                Integer policyStateId = policy.getPolicyStateId();
                if (Policy.STATUS_ACTIVE.equals(policyStateId)) {
                    filteredPolicies.put(policyId, policy);
                    continue;
                }
                if (Policy.STATUS_ACTIVE.equals(alreadyAddedPolicy.getPolicyStateId()) || !policy.getLastModified().after(alreadyAddedPolicy.getLastModified())) continue;
                filteredPolicies.put(policyId, policy);
                continue;
            }
            filteredPolicies.put(policyId, policy);
        }
        return ((HashMap)filteredPolicies).values();
    }

    @Override
    public List<Policy> getPreviousVersionsPolicies(Long policyId) {
        return this.policyDAO.getPreviousVersionsPolicies(policyId);
    }

    @Override
    public boolean isPolicyConsentRequiredForUser(Integer userId) {
        return this.policyDAO.isPolicyConsentRequiredForUser(userId);
    }

    @Override
    public List<PolicyDTO> getPolicyDtosByUser(Integer userId) {
        return this.policyDAO.getPolicyDtosByUser(userId);
    }

    @Override
    public List<PolicyConsent> getConsentsByUserId(Integer userId) {
        return this.policyDAO.getConsentsByUserId(userId);
    }

    @Override
    public List<UserPolicyConsentDTO> getConsentDtosByPolicy(Long policyUid, int page, int size, String sortBy, String sortOrder, String searchString) {
        return this.policyDAO.getConsentDtosByPolicy(policyUid, page, size, sortBy, sortOrder, searchString);
    }

    public void setPolicyDAO(IPolicyDAO policyDAO) {
        this.policyDAO = policyDAO;
    }

    public void setUserManagementService(IUserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public void setLessonService(ILessonService lessonService) {
        this.lessonService = lessonService;
    }
}

