/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.LinkedHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellUtil;
import org.apache.poi.ss.util.WorkbookUtil;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.lamsfoundation.lams.util.ExcelCell;
import org.lamsfoundation.lams.util.FileUtil;

public class ExcelUtil {
    private static CellStyle defaultStyle;
    private static CellStyle boldStyle;
    private static CellStyle percentageStyle;
    private static String percentageStyleFormatString;
    private static CellStyle greenColor;
    private static CellStyle blueColor;
    private static CellStyle redColor;
    private static CellStyle yellowColor;
    private static CellStyle borderStyleLeftThin;
    private static CellStyle borderStyleLeftThinPercentage;
    private static CellStyle borderStyleLeftThick;
    private static CellStyle borderStyleRightThick;
    private static CellStyle borderStyleLeftThinBoldFont;
    private static CellStyle borderStyleLeftThinBoldFontPercentage;
    private static CellStyle borderStyleLeftThickBoldFont;
    private static CellStyle borderStyleRightThickBoldFont;
    private static CellStyle borderStyleBottomThin;
    private static CellStyle borderStyleBottomThinBoldFont;
    private static CellStyle borderStyleRightThickPercentage;
    private static CellStyle borderStyleRightThickBoldFontPercentage;
    public static final String DEFAULT_FONT_NAME = "Calibri-Regular";

    public static void createExcelXLS(OutputStream out, LinkedHashMap<String, ExcelCell[][]> dataToExport, String dateHeader, boolean displaySheetTitle) throws IOException {
        HSSFWorkbook workbook = new HSSFWorkbook();
        ExcelUtil.create((Workbook)workbook, out, dataToExport, dateHeader, displaySheetTitle);
    }

    public static void createExcel(OutputStream out, LinkedHashMap<String, ExcelCell[][]> dataToExport, String dateHeader, boolean displaySheetTitle) throws IOException {
        SXSSFWorkbook workbook = new SXSSFWorkbook(100);
        ExcelUtil.create((Workbook)workbook, out, dataToExport, dateHeader, displaySheetTitle);
    }

    private static void create(Workbook workbook, OutputStream out, LinkedHashMap<String, ExcelCell[][]> dataToExport, String dateHeader, boolean displaySheetTitle) throws IOException {
        Font defaultFont = workbook.createFont();
        defaultFont.setFontName(DEFAULT_FONT_NAME);
        defaultStyle = workbook.createCellStyle();
        defaultStyle.setFont(defaultFont);
        boldStyle = workbook.createCellStyle();
        Font boldFont = workbook.createFont();
        boldFont.setBold(true);
        boldFont.setFontName(DEFAULT_FONT_NAME);
        boldStyle.setFont(boldFont);
        blueColor = workbook.createCellStyle();
        blueColor.setFillForegroundColor(IndexedColors.LIGHT_CORNFLOWER_BLUE.getIndex());
        blueColor.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        blueColor.setFont(defaultFont);
        redColor = workbook.createCellStyle();
        redColor.setFillForegroundColor(IndexedColors.RED.getIndex());
        redColor.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        redColor.setFont(defaultFont);
        greenColor = workbook.createCellStyle();
        greenColor.setFillForegroundColor(IndexedColors.LIME.getIndex());
        greenColor.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        Font whiteFont = workbook.createFont();
        whiteFont.setColor(IndexedColors.WHITE.getIndex());
        whiteFont.setFontName(DEFAULT_FONT_NAME);
        greenColor.setFont(whiteFont);
        yellowColor = workbook.createCellStyle();
        yellowColor.setFillForegroundColor(IndexedColors.GOLD.getIndex());
        yellowColor.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        yellowColor.setFont(defaultFont);
        percentageStyle = workbook.createCellStyle();
        short percentageDataFormatId = workbook.createDataFormat().getFormat(percentageStyleFormatString);
        percentageStyle.setDataFormat(percentageDataFormatId);
        borderStyleLeftThin = workbook.createCellStyle();
        borderStyleLeftThin.setBorderLeft(BorderStyle.THIN);
        borderStyleLeftThin.setFont(defaultFont);
        borderStyleLeftThick = workbook.createCellStyle();
        borderStyleLeftThick.setBorderLeft(BorderStyle.THICK);
        borderStyleLeftThick.setFont(defaultFont);
        borderStyleRightThick = workbook.createCellStyle();
        borderStyleRightThick.setBorderRight(BorderStyle.THICK);
        borderStyleRightThick.setFont(defaultFont);
        borderStyleLeftThinBoldFont = workbook.createCellStyle();
        borderStyleLeftThinBoldFont.setBorderLeft(BorderStyle.THIN);
        borderStyleLeftThinBoldFont.setFont(boldFont);
        borderStyleLeftThickBoldFont = workbook.createCellStyle();
        borderStyleLeftThickBoldFont.setBorderLeft(BorderStyle.THICK);
        borderStyleLeftThickBoldFont.setFont(boldFont);
        borderStyleRightThickBoldFont = workbook.createCellStyle();
        borderStyleRightThickBoldFont.setBorderRight(BorderStyle.THICK);
        borderStyleRightThickBoldFont.setFont(boldFont);
        borderStyleBottomThin = workbook.createCellStyle();
        borderStyleBottomThin.setBorderBottom(BorderStyle.THIN);
        borderStyleBottomThin.setFont(defaultFont);
        borderStyleBottomThinBoldFont = workbook.createCellStyle();
        borderStyleBottomThinBoldFont.setBorderBottom(BorderStyle.THIN);
        borderStyleBottomThinBoldFont.setFont(boldFont);
        borderStyleLeftThinPercentage = workbook.createCellStyle();
        borderStyleLeftThinPercentage.setBorderLeft(BorderStyle.THIN);
        borderStyleLeftThinPercentage.setFont(defaultFont);
        borderStyleLeftThinPercentage.setDataFormat(percentageDataFormatId);
        borderStyleLeftThinBoldFontPercentage = workbook.createCellStyle();
        borderStyleLeftThinBoldFontPercentage.setBorderLeft(BorderStyle.THIN);
        borderStyleLeftThinBoldFontPercentage.setFont(boldFont);
        borderStyleLeftThinBoldFontPercentage.setDataFormat(percentageDataFormatId);
        borderStyleRightThickPercentage = workbook.createCellStyle();
        borderStyleRightThickPercentage.setBorderRight(BorderStyle.THICK);
        borderStyleRightThickPercentage.setDataFormat(percentageDataFormatId);
        borderStyleRightThickBoldFontPercentage = workbook.createCellStyle();
        borderStyleRightThickBoldFontPercentage.setBorderRight(BorderStyle.THICK);
        borderStyleRightThickBoldFontPercentage.setFont(boldFont);
        borderStyleRightThickBoldFontPercentage.setDataFormat(percentageDataFormatId);
        int i = 0;
        for (String sheetName : dataToExport.keySet()) {
            if (dataToExport.get(sheetName) == null) continue;
            String sheetTitle = displaySheetTitle ? sheetName : null;
            ExcelUtil.createSheet(workbook, sheetName, sheetTitle, i, dateHeader, dataToExport.get(sheetName));
            ++i;
        }
        workbook.write(out);
        out.close();
    }

    public static void createSheet(Workbook workbook, String sheetName, String sheetTitle, int sheetIndex, String dateHeader, ExcelCell[][] data) throws IOException {
        Row row;
        sheetName = WorkbookUtil.createSafeSheetName((String)sheetName);
        while (workbook.getSheet((String)sheetName) != null) {
            sheetName = (String)sheetName + " ";
        }
        Sheet sheet = workbook.createSheet((String)sheetName);
        if (workbook instanceof SXSSFWorkbook) {
            ((SXSSFSheet)sheet).trackAllColumnsForAutoSizing();
        }
        if (!StringUtils.isBlank((String)sheetTitle)) {
            row = sheet.createRow(0);
            ExcelUtil.createCell(new ExcelCell((Object)sheetTitle, true), 0, row, workbook);
        }
        if (!StringUtils.isBlank((String)dateHeader)) {
            row = sheet.createRow(1);
            ExcelUtil.createCell(new ExcelCell((Object)dateHeader, false), 0, row, workbook);
            ExcelUtil.createCell(new ExcelCell((Object)FileUtil.EXPORT_TO_SPREADSHEET_TITLE_DATE_FORMAT.format(new Date()), false), 1, row, workbook);
        }
        if (data != null) {
            int maxColumnSize = 0;
            for (int rowIndex = 0; rowIndex < data.length; ++rowIndex) {
                int rowIndexOffset = StringUtils.isBlank((String)sheetTitle) && StringUtils.isBlank((String)dateHeader) ? 0 : 4;
                Row row2 = sheet.createRow(rowIndex + rowIndexOffset);
                int columnSize = data[rowIndex].length;
                for (int columnIndex = 0; columnIndex < columnSize; ++columnIndex) {
                    ExcelCell excelCell = data[rowIndex][columnIndex];
                    ExcelUtil.createCell(excelCell, columnIndex, row2, workbook);
                }
                if (columnSize <= maxColumnSize) continue;
                maxColumnSize = columnSize;
            }
            for (int i = 0; i < maxColumnSize; ++i) {
                sheet.autoSizeColumn(i);
            }
        }
    }

    public static void createCell(ExcelCell excelCell, int cellnum, Row row, Workbook workbook) {
        if (excelCell != null) {
            Cell cell = row.createCell(cellnum);
            if (excelCell.getCellValue() != null && excelCell.getCellValue() instanceof Date) {
                cell.setCellValue(FileUtil.EXPORT_TO_SPREADSHEET_CELL_DATE_FORMAT.format(excelCell.getCellValue()));
            } else if (excelCell.getCellValue() != null && excelCell.getCellValue() instanceof Double) {
                cell.setCellValue(((Double)excelCell.getCellValue()).doubleValue());
            } else if (excelCell.getCellValue() != null && excelCell.getCellValue() instanceof Long) {
                cell.setCellValue(((Long)excelCell.getCellValue()).doubleValue());
            } else if (excelCell.getCellValue() != null && excelCell.getCellValue() instanceof Integer) {
                cell.setCellValue(((Integer)excelCell.getCellValue()).doubleValue());
            } else if (excelCell.getCellValue() != null) {
                cell.setCellValue(excelCell.getCellValue().toString());
            }
            cell.setCellStyle(defaultStyle);
            if (excelCell.isBold().booleanValue()) {
                cell.setCellStyle(boldStyle);
            }
            if (excelCell.isPercentage().booleanValue()) {
                cell.setCellStyle(percentageStyle);
            }
            if (excelCell.getColor() != null) {
                switch (excelCell.getColor()) {
                    case BLUE: {
                        cell.setCellStyle(blueColor);
                        break;
                    }
                    case GREEN: {
                        cell.setCellStyle(greenColor);
                        break;
                    }
                    case RED: {
                        cell.setCellStyle(redColor);
                        break;
                    }
                    case YELLOW: {
                        cell.setCellStyle(yellowColor);
                        break;
                    }
                }
            }
            if (excelCell.getBorderStyle() != 0) {
                switch (excelCell.getBorderStyle()) {
                    case 1: {
                        if (excelCell.isBold().booleanValue() && excelCell.isPercentage().booleanValue()) {
                            cell.setCellStyle(borderStyleLeftThinBoldFontPercentage);
                            break;
                        }
                        if (excelCell.isBold().booleanValue()) {
                            cell.setCellStyle(borderStyleLeftThinBoldFont);
                            break;
                        }
                        if (excelCell.isPercentage().booleanValue()) {
                            cell.setCellStyle(borderStyleLeftThinPercentage);
                            break;
                        }
                        cell.setCellStyle(borderStyleLeftThin);
                        break;
                    }
                    case 4: {
                        if (excelCell.isBold().booleanValue()) {
                            cell.setCellStyle(borderStyleLeftThickBoldFont);
                            break;
                        }
                        cell.setCellStyle(borderStyleLeftThick);
                        break;
                    }
                    case 2: {
                        if (excelCell.isBold().booleanValue() && excelCell.isPercentage().booleanValue()) {
                            cell.setCellStyle(borderStyleRightThickBoldFontPercentage);
                            break;
                        }
                        if (excelCell.isBold().booleanValue()) {
                            cell.setCellStyle(borderStyleRightThickBoldFont);
                            break;
                        }
                        if (excelCell.isPercentage().booleanValue()) {
                            cell.setCellStyle(borderStyleRightThickPercentage);
                            break;
                        }
                        cell.setCellStyle(borderStyleRightThick);
                        break;
                    }
                    case 3: {
                        if (excelCell.isBold().booleanValue()) {
                            cell.setCellStyle(borderStyleBottomThinBoldFont);
                            break;
                        }
                        cell.setCellStyle(borderStyleBottomThin);
                        break;
                    }
                }
            }
            if (excelCell.getAlignment() != 0) {
                switch (excelCell.getAlignment()) {
                    case 1: {
                        CellUtil.setCellStyleProperty((Cell)cell, (String)"alignment", (Object)HorizontalAlignment.GENERAL);
                        break;
                    }
                    case 2: {
                        CellUtil.setCellStyleProperty((Cell)cell, (String)"alignment", (Object)HorizontalAlignment.LEFT);
                        break;
                    }
                    case 3: {
                        CellUtil.setCellStyleProperty((Cell)cell, (String)"alignment", (Object)HorizontalAlignment.CENTER);
                        break;
                    }
                    case 4: {
                        CellUtil.setCellStyleProperty((Cell)cell, (String)"alignment", (Object)HorizontalAlignment.RIGHT);
                        break;
                    }
                }
            }
        }
    }

    static {
        percentageStyleFormatString = "0.00%";
    }
}

