/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import java.text.NumberFormat;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.springframework.web.multipart.MultipartFile;

public class FileValidatorUtil {
    public static final String LARGE_FILE = "largeFile";
    public static final String MSG_KEY = "errors.maxfilesize";

    public static boolean validateFileSize(MultipartFile file, boolean largeFile) {
        float maxFileSize;
        Long fileSize = 0L;
        try {
            fileSize = file.getSize();
        }
        catch (Exception e) {
            return true;
        }
        float f = maxFileSize = largeFile ? (float)Configuration.getAsInt(ConfigurationKeys.UPLOAD_FILE_LARGE_MAX_SIZE) : (float)Configuration.getAsInt(ConfigurationKeys.UPLOAD_FILE_MAX_SIZE);
        if ((float)fileSize.longValue() > maxFileSize) {
            String maxSize = FileValidatorUtil.formatSize(maxFileSize);
            return false;
        }
        return true;
    }

    public static boolean validateFileSize(Long fileSize, boolean largeFile) {
        float maxFileSize;
        float f = maxFileSize = largeFile ? (float)Configuration.getAsInt(ConfigurationKeys.UPLOAD_FILE_LARGE_MAX_SIZE) : (float)Configuration.getAsInt(ConfigurationKeys.UPLOAD_FILE_MAX_SIZE);
        if ((float)fileSize.longValue() > maxFileSize) {
            String maxSize = FileValidatorUtil.formatSize(maxFileSize);
            return false;
        }
        return true;
    }

    public static String formatSize(double size) {
        String unit = null;
        if (size >= 1024.0) {
            if ((size /= 1024.0) >= 1024.0) {
                size /= 1024.0;
                unit = " MB";
            } else {
                unit = " KB";
            }
        } else {
            unit = " B";
        }
        NumberFormat format = NumberFormat.getInstance();
        format.setMaximumFractionDigits(1);
        return format.format(size) + unit;
    }
}

