/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.lamsfoundation.lams.usermanagement.SupportedLocale;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.CommonConstants;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class LanguageUtil {
    public static final String DEFAULT_LANGUAGE = "en";
    public static final String DEFAULT_COUNTRY = "AU";
    public static final String DEFAULT_DIRECTION = "LTR";
    private static IUserManagementService service;
    private static MessageService messageService;

    public static String[] getDefaultLangCountry() {
        String languageIsoCode = null;
        String countryIsoCode = null;
        String serverLang = Configuration.get(ConfigurationKeys.SERVER_LANGUAGE);
        if (serverLang != null) {
            if (serverLang.length() >= 2) {
                languageIsoCode = serverLang.substring(0, 2);
            }
            if (serverLang.length() >= 5) {
                countryIsoCode = serverLang.substring(3, 5);
            }
        }
        if (languageIsoCode == null) {
            languageIsoCode = DEFAULT_LANGUAGE;
        }
        if (countryIsoCode == null) {
            languageIsoCode = DEFAULT_COUNTRY;
        }
        return new String[]{languageIsoCode, countryIsoCode};
    }

    public static String getDefaultDirection() {
        String direction = Configuration.get(ConfigurationKeys.SERVER_PAGE_DIRECTION);
        if (direction == null) {
            direction = DEFAULT_DIRECTION;
        }
        return direction;
    }

    public static TimeZone getDefaultTimeZone() {
        return TimeZone.getDefault();
    }

    public static String getDefaultCountry() {
        String serverCountry = Configuration.get(ConfigurationKeys.SERVER_COUNTRY);
        return StringUtils.isBlank((String)serverCountry) ? DEFAULT_COUNTRY : serverCountry;
    }

    public static String getSupportedCountry(String input) {
        String country;
        String string = country = input == null ? null : input.toUpperCase();
        if (StringUtils.isBlank((String)country) || !Arrays.asList(CommonConstants.COUNTRY_CODES).contains(country)) {
            country = LanguageUtil.getDefaultCountry();
        }
        return country;
    }

    public static SupportedLocale getDefaultLocale() {
        String localeName = Configuration.get(ConfigurationKeys.SERVER_LANGUAGE);
        String langIsoCode = DEFAULT_LANGUAGE;
        String countryIsoCode = DEFAULT_COUNTRY;
        if (StringUtils.isNotBlank((String)localeName) && localeName.length() > 2) {
            langIsoCode = localeName.substring(0, 2);
            countryIsoCode = localeName.substring(3);
        }
        SupportedLocale locale = null;
        locale = LanguageUtil.getSupportedLocaleOrNull(langIsoCode, countryIsoCode);
        if (locale == null) {
            locale = LanguageUtil.getSupportedLocaleOrNull(DEFAULT_LANGUAGE, DEFAULT_COUNTRY);
        }
        return locale;
    }

    public static SupportedLocale getSupportedLocale(String input) {
        List list = LanguageUtil.getService().findByProperty(SupportedLocale.class, "languageIsoCode", input);
        if (list != null && list.size() > 0) {
            return (SupportedLocale)list.get(0);
        }
        list = LanguageUtil.getService().findByProperty(SupportedLocale.class, "countryIsoCode", input);
        if (list != null && list.size() > 0) {
            return (SupportedLocale)list.get(0);
        }
        return LanguageUtil.getDefaultLocale();
    }

    public static Locale getSupportedLocaleByNameOrLanguageCode(Locale locale) {
        String localeId = MessageFormat.format("{0}_{1}", locale.getLanguage(), locale.getCountry());
        SupportedLocale supportedLocale = LanguageUtil.getSupportedLocaleByNameOrLanguageCode(localeId);
        return new Locale(supportedLocale.getLanguageIsoCode(), supportedLocale.getCountryIsoCode());
    }

    public static SupportedLocale getSupportedLocaleByNameOrLanguageCode(String input) {
        SupportedLocale locale = null;
        if (StringUtils.isNotBlank((String)input)) {
            String localeLanguage;
            if (input.length() == 5 && input.indexOf("_") == 2) {
                localeLanguage = input.substring(0, 2).toLowerCase();
                String localeCountry = input.substring(3).toUpperCase();
                locale = LanguageUtil.getSupportedLocaleOrNull(localeLanguage, localeCountry);
            }
            if (locale == null && input.length() >= 2) {
                localeLanguage = input.substring(0, 2).toLowerCase();
                List list = LanguageUtil.getService().findByProperty(SupportedLocale.class, "languageIsoCode", localeLanguage);
                if (list != null && list.size() > 0) {
                    locale = (SupportedLocale)list.get(0);
                }
            }
        }
        if (locale == null) {
            locale = LanguageUtil.getDefaultLocale();
        }
        return locale;
    }

    public static SupportedLocale getSupportedLocale(String langIsoCode, String countryIsoCode) {
        SupportedLocale locale = LanguageUtil.getSupportedLocaleOrNull(langIsoCode, countryIsoCode);
        if (locale == null) {
            locale = LanguageUtil.getDefaultLocale();
        }
        return locale;
    }

    private static SupportedLocale getSupportedLocaleOrNull(String langIsoCode, String countryIsoCode) {
        SupportedLocale locale = null;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)countryIsoCode)) {
            properties.put("countryIsoCode", countryIsoCode.trim());
        }
        if (StringUtils.isNotBlank((String)langIsoCode)) {
            properties.put("languageIsoCode", langIsoCode.trim());
        }
        if (properties.isEmpty()) {
            return null;
        }
        List list = LanguageUtil.getService().findByProperties(SupportedLocale.class, properties);
        if (list != null && list.size() > 0) {
            Collections.sort(list);
            locale = (SupportedLocale)list.get(0);
        } else {
            locale = null;
        }
        return locale;
    }

    public static Map<String, String> getCountryCodes(boolean enforceUsingDefaultLocale) {
        LanguageUtil.getMessageService();
        SupportedLocale lamsDefaultLocale = enforceUsingDefaultLocale ? LanguageUtil.getDefaultLocale() : null;
        HashMap<String, String> countryCodesMap = new HashMap<String, String>();
        for (String countryCode : CommonConstants.COUNTRY_CODES) {
            String countryName = enforceUsingDefaultLocale ? messageService.getMessage("country." + countryCode, lamsDefaultLocale) : messageService.getMessage("country." + countryCode);
            countryCodesMap.put(countryCode, countryName);
        }
        return countryCodesMap.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.naturalOrder())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
    }

    private static IUserManagementService getService() {
        if (service == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)SessionManager.getServletContext());
            service = (IUserManagementService)ctx.getBean("userManagementService");
        }
        return service;
    }

    private static MessageService getMessageService() {
        if (messageService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)SessionManager.getServletContext());
            messageService = (MessageService)ctx.getBean("commonMessageService");
        }
        return messageService;
    }
}

