/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import java.util.Locale;
import org.lamsfoundation.lams.usermanagement.SupportedLocale;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;

public class MessageService {
    private MessageSource messageSource;

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public String getMessage(String key) {
        Object message;
        try {
            message = this.messageSource.getMessage(key, null, LocaleContextHolder.getLocale());
        }
        catch (NoSuchMessageException e) {
            message = "??" + key + "??";
        }
        return message;
    }

    public String getMessage(String key, SupportedLocale supportedLocale) {
        Object message;
        Locale locale = new Locale(supportedLocale.getLanguageIsoCode(), supportedLocale.getCountryIsoCode());
        try {
            message = this.messageSource.getMessage(key, null, locale);
        }
        catch (NoSuchMessageException e) {
            message = "??" + key + "??";
        }
        return message;
    }

    public String getMessage(String key, String defaultMessage) {
        String message = defaultMessage;
        try {
            message = this.messageSource.getMessage(key, null, defaultMessage, LocaleContextHolder.getLocale());
        }
        catch (NoSuchMessageException e) {
            message = defaultMessage;
        }
        return message;
    }

    public String getMessage(String key, Object[] args) {
        Object message;
        try {
            message = this.messageSource.getMessage(key, args, LocaleContextHolder.getLocale());
        }
        catch (NoSuchMessageException e) {
            message = "??" + key + "??";
        }
        return message;
    }

    public String getMessage(String key, Object[] args, SupportedLocale supportedLocale) {
        Object message;
        Locale locale = new Locale(supportedLocale.getLanguageIsoCode(), supportedLocale.getCountryIsoCode());
        try {
            message = this.messageSource.getMessage(key, args, locale);
        }
        catch (NoSuchMessageException e) {
            message = "??" + key + "??";
        }
        return message;
    }

    public String getMessage(String key, Object[] args, String defaultMessage) {
        String message = defaultMessage;
        try {
            message = this.messageSource.getMessage(key, args, defaultMessage, LocaleContextHolder.getLocale());
        }
        catch (NoSuchMessageException e) {
            message = defaultMessage;
        }
        return message;
    }
}

