/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import java.io.File;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;

public class UploadFileUtil {
    private static Logger log = Logger.getLogger(UploadFileUtil.class);
    private static final int DEFAULT_MAX_SIZE = 5000000;
    private static final int DEFAULT_MEMORY_SIZE = 4096;

    public static float getMaxFileSize() {
        int max_size = 5000000;
        int tempInt = Configuration.getAsInt(ConfigurationKeys.UPLOAD_FILE_MAX_SIZE);
        if (tempInt != -1) {
            max_size = tempInt;
        }
        return max_size != 0 ? (float)max_size / 1024.0f / 1024.0f : 0.0f;
    }

    public static float getMaxLargeFileSize() {
        int max_size = 5000000;
        int tempInt = Configuration.getAsInt(ConfigurationKeys.UPLOAD_FILE_LARGE_MAX_SIZE);
        if (tempInt != -1) {
            max_size = tempInt;
        }
        return max_size != 0 ? (float)max_size / 1024.0f / 1024.0f : 0.0f;
    }

    public static File getUploadBaseDir() {
        String baseDirPath = Configuration.get(ConfigurationKeys.LAMS_EAR_DIR) + File.separator + "lams-www.war" + File.separator + "secure";
        File baseDir = new File(baseDirPath);
        baseDir.mkdir();
        return baseDir;
    }

    public static File getUploadDir(String contentFolderID, String type) {
        File uploadDir = UploadFileUtil.getUploadBaseDir();
        String[] splitContentDir = UploadFileUtil.splitContentDir(contentFolderID);
        for (int groupIndex = 0; groupIndex < splitContentDir.length; ++groupIndex) {
            uploadDir = new File(uploadDir, splitContentDir[groupIndex]);
        }
        uploadDir = new File(uploadDir, type);
        uploadDir.mkdirs();
        return uploadDir;
    }

    public static String getUploadFileName(File uploadDir, String fileName) {
        int counter = 1;
        Object finalName = fileName;
        File uploadFile = new File(uploadDir, fileName);
        while (uploadFile.exists()) {
            finalName = UploadFileUtil.getFileNameWithoutExtension(fileName) + "_" + counter + "." + UploadFileUtil.getFileExtension(fileName);
            uploadFile = new File(uploadDir, (String)finalName);
            ++counter;
        }
        return finalName;
    }

    public static String getUploadWebPath(String contentFolderID, String type) {
        return "/" + Configuration.get(ConfigurationKeys.SERVER_URL_CONTEXT_PATH) + "/www/secure/" + String.join((CharSequence)"/", UploadFileUtil.splitContentDir(contentFolderID)) + "/" + type;
    }

    public static String getFileNameWithoutExtension(String fileName) {
        return fileName.substring(0, fileName.lastIndexOf("."));
    }

    public static String getFileExtension(String fileName) {
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }

    private static String[] splitContentDir(String contentFolderID) {
        String[] result = new String[6];
        String trimmedFolder = contentFolderID.replace("-", "").replace("/", "");
        for (int groupIndex = 0; groupIndex < 6; ++groupIndex) {
            result[groupIndex] = "" + trimmedFolder.charAt(groupIndex * 2) + trimmedFolder.charAt(groupIndex * 2 + 1);
        }
        return result;
    }
}

